/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business.actions;

import com.testin.itestin.business.TestViewNode;
import com.testin.itestin.business.actions.ActionDrag;
import com.testin.itestin.business.actions.ActionRule;
import com.testin.itestin.business.actions.ActionTouch;
import com.testin.itestin.business.actions.ActionType;
import com.testin.itestin.business.actions.RemoteActionKey;
import com.testin.itestin.business.actions.RemoteActionType;
import com.testin.itestin.business.actions.TestActionAssert;
import com.testin.itestin.business.actions.TestActionCheck;
import com.testin.itestin.business.actions.TestActionClick;
import com.testin.itestin.business.actions.TestActionDrag;
import com.testin.itestin.business.actions.TestActionInputkey;
import com.testin.itestin.business.actions.TestActionInputtext;
import com.testin.itestin.business.actions.TestActionNote;
import com.testin.itestin.business.actions.TestActionScreenshot;
import com.testin.itestin.business.actions.TestActionSleep;
import com.testin.itestin.business.actions.TestActionStartActivity;
import com.testin.javafx.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class TestAction {
    ActionType action;
    ActionRule rule;

    public abstract String show();

    public abstract String expr();

    public ActionType getActionType() {
        return this.action;
    }

    public void setAction(ActionType action) {
        this.action = action;
    }

    public ActionRule getRule() {
        return this.rule;
    }

    public void setRule(ActionRule rule) {
        this.rule = rule;
    }

    public String getActionName() {
        if (this.action == ActionType.click) {
            if (this.rule == ActionRule.shortaction) {
                return this.getString("emulatorcontroller.menuitems1");
            }
            if (this.rule == ActionRule.longaction) {
                return this.getString("emulatorcontroller.menuitems2");
            }
            if (this.rule == ActionRule.doubleaction) {
                return this.getString("emulatorcontroller.doubleclick");
            }
        } else if (this.action == ActionType.drag) {
            if (this.rule == ActionRule.up) {
                return this.getString("emulatorcontroller.menuitems3");
            }
            if (this.rule == ActionRule.down) {
                return this.getString("emulatorcontroller.menuitems4");
            }
            if (this.rule == ActionRule.left) {
                return this.getString("emulatorcontroller.menuitems5");
            }
            if (this.rule == ActionRule.right) {
                return this.getString("emulatorcontroller.menuitems6");
            }
        } else if (this.action == ActionType.inputtext) {
            if (this.rule == ActionRule.text) {
                return this.getString("emulatorcontroller.menuitems9");
            }
            if (this.rule == ActionRule.username) {
                return this.getString("emulatorcontroller.menuitems10");
            }
            if (this.rule == ActionRule.password) {
                return this.getString("emulatorcontroller.menuitems11");
            }
            if (this.rule == ActionRule.randomtext) {
                return this.getString("emulatorcontroller.menuitems12");
            }
        } else {
            if (this.action == ActionType.inputkey) {
                return this.getString("coordscriptshowcontroller.scriptshowinTable.press");
            }
            if (this.action == ActionType.check) {
                if (this.rule == ActionRule.check) {
                    return this.getString("emulatorcontroller.menuitems7");
                }
                if (this.rule == ActionRule.uncheck) {
                    return this.getString("emulatorcontroller.menuitems8");
                }
            } else {
                if (this.action == ActionType.sleep) {
                    return this.getString("coordscriptshowcontroller.scriptshowinTable.delay");
                }
                if (this.action == ActionType.screenshot) {
                    return this.getString("coordscriptshowcontroller.scriptshowinTable.screen");
                }
                if (this.action == ActionType.assertfor) {
                    if (this.rule == ActionRule.waittext) {
                        return this.getString("testaction.getactionname.waittext");
                    }
                    if (this.rule == ActionRule.waitwidget) {
                        return this.getString("testaction.getactionname.waitcontroller");
                    }
                } else if (this.action == ActionType.local_touch) {
                    if (this.rule == ActionRule.down) {
                        return this.getString("testaction.getactionname.press");
                    }
                    if (this.rule == ActionRule.move) {
                        return this.getString("testaction.getactionname.drag");
                    }
                    if (this.rule == ActionRule.up) {
                        return this.getString("testaction.getactionname.release");
                    }
                    if (this.rule == ActionRule.tap) {
                        return this.getString("coordscriptshowcontroller.scriptshowinTable.touch");
                    }
                } else {
                    if (this.action == ActionType.local_drag) {
                        return this.getString("testaction.getactionname.drag");
                    }
                    if (this.action == ActionType.remote_touch) {
                        if (this.rule == ActionRule.down) {
                            return this.getString("testaction.getactionname.remote.press");
                        }
                        if (this.rule == ActionRule.move) {
                            return this.getString("testaction.getactionname.remote.drag");
                        }
                        if (this.rule == ActionRule.up) {
                            return this.getString("testaction.getactionname.remote.release");
                        }
                        if (this.rule == ActionRule.tap) {
                            return this.getString("coordscriptshowcontroller.scriptshowinTable.remote.touch");
                        }
                    } else {
                        if (this.action == ActionType.remote_drag) {
                            return this.getString("testaction.getactionname.remote.drag");
                        }
                        if (this.action == ActionType.remote_key) {
                            if (this.rule == ActionRule.down) {
                                return this.getString("testaction.getactionname.press");
                            }
                            if (this.rule == ActionRule.up) {
                                return this.getString("testaction.getactionname.release");
                            }
                            if (this.rule == ActionRule.press) {
                                return this.getString("coordscriptshowcontroller.scriptshowinTable.press");
                            }
                        } else if (this.action == ActionType.remote_type) {
                            if (this.rule == ActionRule.text) {
                                return this.getString("emulatorcontroller.menuitems9");
                            }
                            if (this.rule == ActionRule.username) {
                                return this.getString("emulatorcontroller.menuitems10");
                            }
                            if (this.rule == ActionRule.password) {
                                return this.getString("emulatorcontroller.menuitems11");
                            }
                            if (this.rule == ActionRule.randomtext) {
                                return this.getString("emulatorcontroller.menuitems12");
                            }
                        } else {
                            if (this.action == ActionType.note) {
                                return this.getString("coordscriptshowcontroller.menuitem5");
                            }
                            if (this.action == ActionType.startactivity) {
                                return this.getString("testaction.getactionname.start");
                            }
                        }
                    }
                }
            }
        }
        return "";
    }

    private String getString(String keyname) {
        return Main.getInternationalString(keyname);
    }

    public String toString() {
        return this.expr();
    }

    public static HashMap<String, String> parseExpr(String expr) {
        HashMap<String, String> data = new HashMap<String, String>();
        Pattern p = Pattern.compile("\\[(.*?)\\]");
        Matcher m = p.matcher(expr);
        ArrayList<String> kvs = new ArrayList<String>();
        while (m.find()) {
            kvs.add(m.group(1));
        }
        for (String str : kvs) {
            int index = str.indexOf("/");
            String key = str.substring(0, index);
            String value = str.substring(index + 1);
            data.put(key, value);
        }
        return data;
    }

    public static boolean isScriptValid(String script) {
        if (StringUtils.isEmpty((String)script) || !script.contains("]")) {
            return false;
        }
        String[] attrs = script.split("]");
        int i = 0;
        while (i < attrs.length) {
            String attr = attrs[i].trim();
            if (!(!StringUtils.isNotEmpty((String)attr) || attr.startsWith("[") && attr.contains("/"))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static TestAction newInstance(String expr) {
        if (expr == null) {
            return null;
        }
        TestAction testAction = null;
        HashMap<String, String> data = TestAction.parseExpr(expr);
        ActionType action = ActionType.getAction(data.get("action"));
        switch (action) {
            case click: {
                testAction = TestAction.onClick(data);
                break;
            }
            case drag: {
                testAction = TestAction.onDrag(data);
                break;
            }
            case check: {
                testAction = TestAction.onCheck(data);
                break;
            }
            case inputkey: {
                testAction = TestAction.onInputkey(data);
                break;
            }
            case inputtext: {
                testAction = TestAction.onInputtext(data);
                break;
            }
            case sleep: {
                testAction = TestAction.onSleep(data);
                break;
            }
            case screenshot: {
                testAction = TestAction.onScreenshot(data);
                break;
            }
            case assertfor: {
                testAction = TestAction.onAssertfor(data);
                break;
            }
            case local_touch: {
                testAction = TestAction.onActionTouch(data);
                break;
            }
            case local_drag: {
                testAction = TestAction.onActionDrag(data);
                break;
            }
            case remote_touch: {
                testAction = TestAction.onActionTouch(data);
                break;
            }
            case remote_drag: {
                testAction = TestAction.onActionDrag(data);
                break;
            }
            case remote_key: {
                testAction = TestAction.onRemoteKey(data);
                break;
            }
            case remote_type: {
                testAction = TestAction.onRemoteType(data);
                break;
            }
            case startactivity: {
                testAction = TestAction.onStartactivity(data);
                break;
            }
            case note: {
                testAction = TestAction.onActionNote(data);
                break;
            }
        }
        if (testAction != null) {
            testAction.setAction(ActionType.getAction(data.get("action")));
            testAction.setRule(ActionRule.getRule(data.get("rule")));
        }
        return testAction;
    }

    private static TestAction onActionNote(HashMap<String, String> data) {
        TestActionNote action = new TestActionNote();
        String str = data.get("text");
        action.setNote(str);
        return action;
    }

    private static TestAction onClick(HashMap<String, String> data) {
        TestActionClick action = new TestActionClick();
        TestViewNode viewNode = new TestViewNode();
        action.setRotation(0);
        action.setViewNode(viewNode);
        viewNode.setClazz(data.get("clazz"));
        viewNode.setId(data.get("id"));
        viewNode.setXpath(data.get("xpath"));
        if (data.get("position") != null) {
            viewNode.setPosition(Integer.parseInt(data.get("position")));
        }
        viewNode.setText(data.get("text"));
        if (data.get("apptype") != null) {
            viewNode.setApptype(data.get("apptype"));
        }
        if (data.get("zindex") != null) {
            viewNode.setZindex(Integer.parseInt(data.get("zindex")));
        }
        viewNode.setIndex(data.get("index"));
        return action;
    }

    private static TestAction onDrag(HashMap<String, String> data) {
        TestActionDrag action = new TestActionDrag();
        TestViewNode viewNode = new TestViewNode();
        action.setRotation(0);
        action.setViewNode(viewNode);
        viewNode.setClazz(data.get("clazz"));
        viewNode.setId(data.get("id"));
        viewNode.setXpath(data.get("xpath"));
        if (data.get("position") != null) {
            viewNode.setPosition(Integer.parseInt(data.get("position")));
        }
        viewNode.setText(data.get("text"));
        if (data.get("apptype") != null) {
            viewNode.setApptype(data.get("apptype"));
        }
        if (data.get("zindex") != null) {
            viewNode.setZindex(Integer.parseInt(data.get("zindex")));
        }
        return action;
    }

    private static TestAction onCheck(HashMap<String, String> data) {
        TestActionCheck action = new TestActionCheck();
        TestViewNode viewNode = new TestViewNode();
        action.setRotation(0);
        action.setViewNode(viewNode);
        viewNode.setClazz(data.get("clazz"));
        viewNode.setId(data.get("id"));
        viewNode.setXpath(data.get("xpath"));
        if (data.get("position") != null) {
            viewNode.setPosition(Integer.parseInt(data.get("position")));
        }
        viewNode.setText(data.get("text"));
        return action;
    }

    private static TestAction onInputkey(HashMap<String, String> data) {
        TestActionInputkey action = new TestActionInputkey();
        action.setKeyName(data.get("keycode"));
        return action;
    }

    private static TestAction onInputtext(HashMap<String, String> data) {
        TestActionInputtext action = new TestActionInputtext();
        TestViewNode viewNode = new TestViewNode();
        action.setRotation(0);
        action.setViewNode(viewNode);
        action.setText(data.get("text"));
        if (ActionRule.getRule(data.get("rule")) == ActionRule.randomtext) {
            action.setLen(Integer.parseInt(data.get("len")));
        }
        viewNode.setClazz(data.get("clazz"));
        viewNode.setId(data.get("id"));
        viewNode.setXpath(data.get("xpath"));
        if (data.get("position") != null) {
            viewNode.setPosition(Integer.parseInt(data.get("position")));
        }
        if (data.get("apptype") != null) {
            viewNode.setApptype(data.get("apptype"));
        }
        if (data.get("zindex") != null) {
            viewNode.setZindex(Integer.parseInt(data.get("zindex")));
        }
        return action;
    }

    private static TestAction onSleep(HashMap<String, String> data) {
        TestActionSleep action = new TestActionSleep();
        action.setSleep(Integer.parseInt(data.get("time")));
        return action;
    }

    private static TestAction onScreenshot(HashMap<String, String> data) {
        TestActionScreenshot action = new TestActionScreenshot();
        action.setImageName(data.get("img"));
        return action;
    }

    private static TestAction onAssertfor(HashMap<String, String> data) {
        TestActionAssert action = new TestActionAssert();
        TestViewNode viewNode = new TestViewNode();
        action.setRotation(0);
        action.setViewNode(viewNode);
        action.setText(data.get("text"));
        action.setTimeout(Integer.parseInt(data.get("timeout")));
        viewNode.setClazz(data.get("clazz"));
        viewNode.setId(data.get("id"));
        viewNode.setXpath(data.get("xpath"));
        if (data.get("position") != null) {
            viewNode.setPosition(Integer.parseInt(data.get("position")));
        }
        viewNode.setText(data.get("text"));
        if (data.get("apptype") != null) {
            viewNode.setApptype(data.get("apptype"));
        }
        if (data.get("zindex") != null) {
            viewNode.setZindex(Integer.parseInt(data.get("zindex")));
        }
        return action;
    }

    private static TestAction onActionTouch(HashMap<String, String> data) {
        ActionTouch action = new ActionTouch();
        String str = data.get("data");
        String[] strs = str.split(",");
        action.setRotation(Integer.parseInt(strs[0]));
        action.setX(Float.parseFloat(strs[1]));
        action.setY(Float.parseFloat(strs[2]));
        return action;
    }

    private static TestAction onActionDrag(HashMap<String, String> data) {
        ActionDrag action = new ActionDrag();
        String str = data.get("data");
        String[] strs = str.split(",");
        action.setRotation(Integer.parseInt(strs[0]));
        action.setFromX(Float.parseFloat(strs[1]));
        action.setFromY(Float.parseFloat(strs[3]));
        action.setToX(Float.parseFloat(strs[2]));
        action.setToY(Float.parseFloat(strs[4]));
        return action;
    }

    private static TestAction onRemoteKey(HashMap<String, String> data) {
        RemoteActionKey action = new RemoteActionKey();
        action.setKeyName(data.get("keycode"));
        return action;
    }

    private static TestAction onRemoteType(HashMap<String, String> data) {
        RemoteActionType action = new RemoteActionType();
        action.setText(data.get("text"));
        if (ActionRule.getRule(data.get("rule")) == ActionRule.randomtext) {
            action.setLen(Integer.parseInt(data.get("len")));
        }
        return action;
    }

    private static TestAction onStartactivity(HashMap<String, String> data) {
        TestActionStartActivity action = new TestActionStartActivity();
        action.setComponent(data.get("component"));
        return action;
    }

    public boolean isForDevice() {
        return ActionType.isActionForDevice(this.getActionType());
    }
}

