/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business.recorder;

import com.testin.itestin.business.ScriptListener;
import com.testin.itestin.business.ViewRecorder;
import com.testin.itestin.business.recorder.RecorderListener;
import com.testin.itestin.business.utils.StatusMgt;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DevicesManager;
import org.apache.log4j.Logger;

public class RecorderThread
extends Thread {
    static Logger log = Logger.getLogger(RecorderThread.class);
    private boolean stop = false;
    private ViewRecorder recorder;
    private RecorderListener recorderListener;
    private ScriptListener scriptListener;

    public RecorderThread(RecorderListener recorderListener, ScriptListener scriptListener) {
        this.setName("Recorder");
        this.setRecorderListener(recorderListener);
        this.setScriptListener(scriptListener);
    }

    @Override
    public void run() {
        try {
            log.info((Object)"Start recorder thread.");
            this.handleStartWork();
            UIController.sendRecordStartMsg(769);
            this.setRecorder(new ViewRecorder(DevicesManager.getDevice()));
            this.getRecorder().record(this.getScriptListener(), this);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public RecorderListener getRecorderListener() {
        return this.recorderListener;
    }

    public void setRecorderListener(RecorderListener recorderListener) {
        this.recorderListener = recorderListener;
    }

    public void sendPromptMsg(String msg) {
        if (this.getRecorderListener() != null) {
            this.getRecorderListener().showPromptMsg(msg);
        }
    }

    public void handleStartWork() {
        StatusMgt.setViewRecorderStop(false);
        if (this.getRecorderListener() != null) {
            this.getRecorderListener().recorderStart();
        }
    }

    public void handleStopWork() {
        if (this.getRecorderListener() != null) {
            this.getRecorderListener().recorderStop();
        }
    }

    public ScriptListener getScriptListener() {
        return this.scriptListener;
    }

    public void setScriptListener(ScriptListener scriptListener) {
        this.scriptListener = scriptListener;
    }

    public ViewRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(ViewRecorder recorder) {
        this.recorder = recorder;
    }
}

