/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business.utils;

import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.actions.TestAction;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.device.event.EventDetector;
import com.testin.itestin.device.event.EventListener;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.os.Handler;
import com.testin.itestin.os.Message;
import com.testin.itestin.util.Utils;
import com.testin.javafx.ui.include.RecordActionController;
import com.testin.javafx.ui.include.ScriptShowController;
import com.testin.javafx.ui.include.TopController;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.apache.log4j.Logger;

public class UIController {
    static Logger log = Logger.getLogger(UIController.class);
    private static ApplicationInfo appInfo;
    private static Handler actionHandler;
    private static Handler scriptListHandler;
    private static Handler screenShotHandler;
    private static Handler scriptShowHandler;
    private static Handler coordscriptShowHandler;
    private static Handler topHandler;
    private static Handler emulatorHandler;
    private static Handler coordEmulatorHandler;
    private static Handler pixelListHandler;
    private static Handler recordActionHandler;
    private static ScriptShowController scriptShowController;
    private static TopController topController;
    private static RecordActionController recordActionController;
    private static EventDetector eventDetector;
    private static EventListener screenEventListener;
    private static int rotation;
    private static int autoImgName;
    private static long lastActionTime;

    static {
        eventDetector = null;
        screenEventListener = null;
        rotation = 0;
        autoImgName = 1;
        lastActionTime = 0L;
    }

    public static Handler getPixelListHandler() {
        return pixelListHandler;
    }

    public static void setPixelListHandler(Handler pixelListHandler) {
        UIController.pixelListHandler = pixelListHandler;
    }

    public static Handler getActionHandler() {
        return actionHandler;
    }

    public static void setActionHandler(Handler actionHandler) {
        UIController.actionHandler = actionHandler;
    }

    public static Handler getScriptListHandler() {
        return scriptListHandler;
    }

    public static void setScriptListHandler(Handler scriptListHandler) {
        UIController.scriptListHandler = scriptListHandler;
    }

    public static Handler getScreenShotHandler() {
        return screenShotHandler;
    }

    public static void setScreenShotHandler(Handler screenShotHandler) {
        UIController.screenShotHandler = screenShotHandler;
    }

    public static ApplicationInfo getAppInfo() {
        return appInfo;
    }

    public static void setAppInfo(ApplicationInfo appInfo) {
        UIController.appInfo = appInfo;
    }

    public static Handler getTopHandler() {
        return topHandler;
    }

    public static void setTopHandler(Handler topHandler) {
        UIController.topHandler = topHandler;
    }

    public static Handler getEmulatorHandler() {
        return emulatorHandler;
    }

    public static void setEmulatorHandler(Handler emulatorHandler) {
        UIController.emulatorHandler = emulatorHandler;
    }

    public static Handler getCoordEmulatorHandler() {
        return coordEmulatorHandler;
    }

    public static void setCoordEmulatorHandler(Handler coordEmulatorHandler) {
        UIController.coordEmulatorHandler = coordEmulatorHandler;
    }

    public static Handler getScriptShowHandler() {
        return scriptShowHandler;
    }

    public static void setScriptShowHandler(Handler scriptShowHandler) {
        UIController.scriptShowHandler = scriptShowHandler;
    }

    public static Handler getRecordActionHandler() {
        return recordActionHandler;
    }

    public static void setRecordActionHandler(Handler recordActionHandler) {
        UIController.recordActionHandler = recordActionHandler;
    }

    public static Handler getCoordscriptShowHandler() {
        return coordscriptShowHandler;
    }

    public static void setCoordscriptShowHandler(Handler coordscriptShowHandler) {
        UIController.coordscriptShowHandler = coordscriptShowHandler;
    }

    public static int getRotation() {
        return rotation;
    }

    public static void setRotation(int rotation) {
        UIController.rotation = rotation;
    }

    public static int getAutoImgName() {
        return autoImgName;
    }

    public static void setAutoImgName(int autoImgName) {
        UIController.autoImgName = autoImgName;
    }

    public static String getNextAutoImgName() {
        return "pic_" + autoImgName++;
    }

    public static long getLastActionTime() {
        return lastActionTime;
    }

    public static void setLastActionTime(long lastActionTime) {
        UIController.lastActionTime = lastActionTime;
    }

    public static void setLastActionTimeToCurrentTime() {
        lastActionTime = System.currentTimeMillis();
    }

    public static long getLastActionElapseTime() {
        if (lastActionTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - lastActionTime;
    }

    public static EventDetector getEventDetector() {
        return eventDetector;
    }

    public static void setEventDetector(EventDetector eventDetector) {
        UIController.eventDetector = eventDetector;
        UIController.updateDeviceSideRecordStatusDisplay();
    }

    public static void updateDeviceSideRecordStatusDisplay() {
        Message msg = new Message();
        msg.setStatus(1283);
        if (UIController.getEmulatorHandler() != null) {
            UIController.getEmulatorHandler().sendMessage(msg);
        }
        if (UIController.getCoordEmulatorHandler() != null) {
            UIController.getCoordEmulatorHandler().sendMessage(msg);
        }
    }

    public static void startScreenEventListener() {
        log.info((Object)"Start Screen Event Listener...");
        EventDetector eventDetector = new EventDetector();
        eventDetector.start();
        UIController.setEventDetector(eventDetector);
    }

    public static void endScreenEventListener() {
        log.info((Object)"End Screen Event Listener.");
        UIController.setScreenEventListener(null);
        if (UIController.getEventDetector() != null && UIController.getEventDetector().isAlive()) {
            UIController.getEventDetector().endCurrentEventListener();
        } else {
            try {
                DeviceInfo deviceinfo = DevicesManager.getDevice();
                if (DevicesManager.isDeviceOK(deviceinfo)) {
                    deviceinfo.getDeviceShell().kill("getevent");
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static EventListener getScreenEventListener() {
        return screenEventListener;
    }

    public static void setScreenEventListener(EventListener screenEventListener) {
        UIController.screenEventListener = screenEventListener;
    }

    public static boolean isEventDetectorRunning() {
        return UIController.getEventDetector() != null && UIController.getEventDetector().isAlive();
    }

    public static ScriptShowController getScriptShowController() {
        return scriptShowController;
    }

    public static void setScriptShowController(ScriptShowController scriptShowController) {
        UIController.scriptShowController = scriptShowController;
    }

    public static TopController getTopController() {
        return topController;
    }

    public static void setTopController(TopController topController) {
        UIController.topController = topController;
    }

    public static RecordActionController getRecordActionController() {
        return recordActionController;
    }

    public static void setRecordActionController(RecordActionController recordActionController) {
        UIController.recordActionController = recordActionController;
    }

    public static void updateNodeSytleClass(final Node node, final String stylename) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                node.getStyleClass().clear();
                node.getStyleClass().add((Object)stylename);
            }
        });
    }

    public static void updateLabelText(final Label node, final String text) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                node.setText(text);
            }
        });
    }

    public static void cleenScreens() {
        Message m;
        if (UIController.getScriptShowHandler() != null) {
            m = new Message();
            m.setStatus(768);
            UIController.getScriptShowHandler().sendMessage(m);
        }
        if (UIController.getEmulatorHandler() != null) {
            m = new Message();
            m.setStatus(768);
            UIController.getEmulatorHandler().sendMessage(m);
        }
        if (UIController.getCoordscriptShowHandler() != null) {
            m = new Message();
            m.setStatus(768);
            UIController.getCoordscriptShowHandler().sendMessage(m);
        }
        if (UIController.getCoordEmulatorHandler() != null) {
            m = new Message();
            m.setStatus(768);
            UIController.getCoordEmulatorHandler().sendMessage(m);
        }
    }

    public static void sendRecordStartMsg(int type) {
        Message m;
        if (UIController.getScriptShowHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 0) {
            m = new Message();
            m.setStatus(769);
            UIController.getScriptShowHandler().sendMessage(m);
        }
        if (UIController.getEmulatorHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 0) {
            m = new Message();
            m.setStatus(769);
            UIController.getEmulatorHandler().sendMessage(m);
        }
        if (UIController.getCoordscriptShowHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 1) {
            m = new Message();
            m.setStatus(769);
            UIController.getCoordscriptShowHandler().sendMessage(m);
        }
        if (UIController.getCoordEmulatorHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 1) {
            m = new Message();
            m.setStatus(769);
            UIController.getCoordEmulatorHandler().sendMessage(m);
        }
        if (UIController.getTopHandler() != null) {
            m = new Message();
            m.setStatus(769);
            UIController.getTopHandler().sendMessage(m);
        }
    }

    public static void sendRecordStopMsg(int type) {
        Message m;
        if (type == 0) {
            if (UIController.getEmulatorHandler() != null) {
                m = new Message();
                m.setStatus(770);
                UIController.getEmulatorHandler().sendMessage(m);
            }
            if (UIController.getScriptShowHandler() != null) {
                m = new Message();
                m.setStatus(770);
                UIController.getScriptShowHandler().sendMessage(m);
            }
        }
        if (type == 1) {
            if (UIController.getCoordscriptShowHandler() != null) {
                m = new Message();
                m.setStatus(770);
                UIController.getCoordscriptShowHandler().sendMessage(m);
            }
            if (UIController.getCoordEmulatorHandler() != null) {
                m = new Message();
                m.setStatus(770);
                UIController.getCoordEmulatorHandler().sendMessage(m);
            }
        }
        if (UIController.getTopHandler() != null) {
            m = new Message();
            m.setStatus(770);
            UIController.getTopHandler().sendMessage(m);
        }
    }

    public static void sendReplayStartMsg() {
        Message m;
        if (UIController.getScriptShowHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 0) {
            m = new Message();
            m.setStatus(1025);
            UIController.getScriptShowHandler().sendMessage(m);
        }
        if (UIController.getEmulatorHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 0) {
            m = new Message();
            m.setStatus(1025);
            UIController.getEmulatorHandler().sendMessage(m);
        }
        if (UIController.getCoordEmulatorHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 1) {
            m = new Message();
            m.setStatus(1025);
            UIController.getCoordEmulatorHandler().sendMessage(m);
        }
    }

    public static void sendReplayStopMsg() {
        Message m;
        if (UIController.getEmulatorHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 0) {
            m = new Message();
            m.setStatus(1026);
            UIController.getEmulatorHandler().sendMessage(m);
        }
        if (UIController.getCoordEmulatorHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 1) {
            m = new Message();
            m.setStatus(1026);
            UIController.getCoordEmulatorHandler().sendMessage(m);
        }
    }

    public static void sendReplayStopMsg(int errormsg) {
        Message m;
        if (UIController.getScriptShowHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 0) {
            m = new Message();
            m.setStatus(1026);
            m.setContent(errormsg);
            UIController.getScriptShowHandler().sendMessage(m);
        }
        if (UIController.getCoordscriptShowHandler() != null && SingleTestCase.getInstance().getRecordStyle() == 1) {
            m = new Message();
            m.setStatus(1026);
            m.setContent(errormsg);
            UIController.getCoordscriptShowHandler().sendMessage(m);
        }
    }

    public static void addLastTakeScreen() {
        if (SingleTestCase.getInstance().isAutoShot()) {
            UIController.addSleepAction(3000);
            Utils.sleep(10L);
            UIController.addScreenshotAction(UIController.getNextAutoImgName());
        }
    }

    public static void addScreenshotAction(String screenshotName) {
        TestAction takeScreenAction = null;
        takeScreenAction = Utils.generateScreenshotAction(screenshotName);
        Message tableMsg = new Message();
        tableMsg.setStatus(773);
        tableMsg.setContent(takeScreenAction);
        UIController.getScriptShowHandler().sendMessage(tableMsg);
    }

    public static void addSleepAction(int sleepTime) {
        TestAction sleepAction = null;
        sleepAction = Utils.generateSleepAction(sleepTime);
        Message tableMsg = new Message();
        tableMsg.setStatus(773);
        tableMsg.setContent(sleepAction);
        UIController.getScriptShowHandler().sendMessage(tableMsg);
    }
}

