/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.common;

import com.testin.itestin.service.ProxyLoader;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class Proxy {
    public static final int HTTP_PROXY_NONE = 0;
    public static final int HTTP_PROXY_USER = 1;
    public static final int HTTP_PROXY_IE = 2;
    public static int proxyType = 0;
    public static String proxyHost = "";
    public static int proxyPort = 8080;
    public static String proxyUser = "";
    public static String proxyPassword = "";

    static {
        ProxyLoader.getInstance().loadConfig();
        Proxy.setProxy();
    }

    public static void save() {
        ProxyLoader.getInstance().saveConfig();
    }

    public static void setProxy() {
        if (proxyType == 1) {
            Properties prop = System.getProperties();
            prop.setProperty("proxySet", "true");
            prop.setProperty("http.proxyHost", proxyHost);
            prop.setProperty("http.proxyPort", String.valueOf(proxyPort));
            if (StringUtils.isNotEmpty((String)proxyUser) && StringUtils.isNotEmpty((String)proxyPassword)) {
                Authenticator.setDefault(new MyAuthenticator(proxyUser, proxyPassword));
            } else {
                Authenticator.setDefault(null);
            }
        } else if (proxyType == 2) {
            System.setProperty("java.net.useSystemProxies", "true");
            if (StringUtils.isNotEmpty((String)proxyUser) && StringUtils.isNotEmpty((String)proxyPassword)) {
                Authenticator.setDefault(new MyAuthenticator(proxyUser, proxyPassword));
            }
        } else {
            Properties prop = System.getProperties();
            prop.setProperty("proxySet", "false");
            prop.setProperty("http.proxyHost", "");
            prop.setProperty("http.proxyPort", "");
            Authenticator.setDefault(null);
        }
    }

    static class MyAuthenticator
    extends Authenticator {
        private String user = "";
        private String password = "";

        public MyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

