/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.Utils;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class AndroidDevicesManager {
    static Logger log = Logger.getLogger(AndroidDevicesManager.class);
    private BlockingQueue<IDevice> disconnectedDevices = new LinkedBlockingQueue<IDevice>();
    private BlockingQueue<IDevice> connectedDevices = new LinkedBlockingQueue<IDevice>();
    private ComplexDeviceChangeListener complexDeviceChangeListener = new ComplexDeviceChangeListener();
    private static AndroidDevicesManager androidDevicesManager = new AndroidDevicesManager();
    private Thread disconnectDeviceHandler = new Thread("DisconnectDeviceHandler"){

        @Override
        public void run() {
            while (true) {
                DeviceInfo di;
                block6: {
                    log.debug((Object)"Running DisconnectDeviceHandler.");
                    IDevice device = (IDevice)AndroidDevicesManager.this.disconnectedDevices.take();
                    di = DevicesManager.getInstance().getDeviceInfoBySn(device.getSerialNumber());
                    if (di != null) break block6;
                    Utils.gc();
                    continue;
                }
                try {
                    try {
                        di.setDevice(null);
                        di.onDeviceDisconnected();
                        Utils.sleep(1000L);
                        DevicesManager.getInstance().removeDeviceInfo(di);
                        DevicesManager.getInstance().notifyDeviceStateListener(di, 9);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                        Utils.gc();
                    }
                }
                catch (Throwable throwable) {
                    Utils.gc();
                    throw throwable;
                }
                Utils.gc();
            }
        }
    };
    private Thread connectDeviceHandler = new Thread("ConnectDeviceHandler"){

        @Override
        public void run() {
            while (true) {
                try {
                    IDevice device = (IDevice)AndroidDevicesManager.this.connectedDevices.take();
                    String sn = device.getSerialNumber();
                    if (sn.equals("AndroidDevice")) continue;
                    try {
                        DeviceInfo deviceInfo = DevicesManager.getInstance().getDeviceInfoBySn(sn);
                        if (deviceInfo == null) {
                            deviceInfo = DeviceInfo.Factory.newInstance(sn);
                            deviceInfo.setDevice(device);
                            AndroidDevicesManager.this.initDevice(deviceInfo);
                            DevicesManager.getInstance().addDeviceInfo(deviceInfo);
                        } else {
                            deviceInfo.setDevice(device);
                            AndroidDevicesManager.this.initDevice(deviceInfo);
                        }
                        Utils.sleep(1000L);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    continue;
                }
                finally {
                    Utils.gc();
                    continue;
                }
                break;
            }
        }
    };

    private AndroidDevicesManager() {
    }

    static AndroidDevicesManager getInstance() {
        return androidDevicesManager;
    }

    void start() {
        AndroidDebugBridge.init((boolean)false);
        String adbPath = DirectoryService.getAdbPath();
        AndroidDebugBridge.createBridge((String)adbPath, (boolean)false);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.complexDeviceChangeListener);
        ThreadPool.execute(this.connectDeviceHandler);
        ThreadPool.execute(this.disconnectDeviceHandler);
    }

    private void initDevice(DeviceInfo deviceInfo) {
        try {
            if (deviceInfo.getState() == 9 && deviceInfo.getDevice() != null && deviceInfo.getDevice().isOnline()) {
                log.info((Object)("will init device." + deviceInfo.getDevice().getSerialNumber()));
                Message msg = deviceInfo.init();
                log.info((Object)String.format("init device.%s status=%s,msg=%s", deviceInfo.getDevice().getSerialNumber(), msg.getStatus(), msg.getContent()));
                if (msg.getStatus() == 0) {
                    deviceInfo.onDeviceConnected();
                    DevicesManager.getInstance().notifyDeviceStateListener(deviceInfo, 0);
                }
            } else if (deviceInfo.getDevice() != null) {
                deviceInfo.getDevice().isOnline();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private final class ComplexDeviceChangeListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private ComplexDeviceChangeListener() {
        }

        public void deviceConnected(IDevice device) {
            if (device.isOnline()) {
                AndroidDevicesManager.this.connectedDevices.add(device);
            }
        }

        public void deviceDisconnected(IDevice device) {
            if (device != null) {
                AndroidDevicesManager.this.disconnectedDevices.add(device);
            }
        }

        public void deviceChanged(IDevice device, int changeMask) {
            if ((changeMask & 1) != 0 && device.isOnline()) {
                this.deviceConnected(device);
            }
        }
    }
}

