/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.testin.itestin.device.AdbForm;
import com.testin.itestin.device.Clicker;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.DevicePropReader;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.ImageCoder;
import com.testin.itestin.device.Scroller;
import com.testin.itestin.device.event.VirtualKeys;
import com.testin.itestin.device.logcat.MainLogcat;
import com.testin.itestin.device.tools.Busybox;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.shell.IShellOutputReceiver;
import com.testin.itestin.shell.MultiLineReceiver;
import com.testin.itestin.shell.ShellCommandUnresponsiveException;
import com.testin.itestin.shell.ShellExecutor;
import com.testin.itestin.util.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AndroidShell
implements IDeviceShell {
    static Logger log = Logger.getLogger(AndroidShell.class);
    DeviceInfo deviceInfo;
    String serialNumber;
    MainLogcat mainLogcat;
    final String dumpWindow = "dumpsys window";
    final String dumpWindowPolicy = "dumpsys window policy";
    String window_cmd = "dumpsys window policy";

    AndroidShell(DeviceInfo deviceInfo) {
        this.deviceInfo = deviceInfo;
        this.serialNumber = deviceInfo.getSerialNumber();
        this.mainLogcat = new MainLogcat(this);
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public Message initDevice() {
        log.info((Object)"init device.");
        DevicePropReader devicePropReader = new DevicePropReader(this);
        Message msg = devicePropReader.readProp();
        if (msg.getStatus() == 0) {
            String keyMap;
            block12: {
                if (devicePropReader.deviceProp != null) {
                    this.deviceInfo.setBrandName(devicePropReader.deviceProp.brandName);
                    this.deviceInfo.setModelName(devicePropReader.deviceProp.modelName);
                    this.deviceInfo.setSdkVer(devicePropReader.deviceProp.sdkVer);
                    this.deviceInfo.setReleaseVer(devicePropReader.deviceProp.releaseVer);
                }
                try {
                    String oppoFile = String.valueOf(DirectoryService.getToolsDir()) + File.separator + "oppo.monkey";
                    this.push(oppoFile, "/data/local/tmp/itestin.monkey", 30000);
                    msg = this.executeShellCommand("monkey -f /data/local/tmp/itestin.monkey 1", 15000);
                    if (msg.getStatus() == 0) {
                        String res = msg.getContent();
                        if (res.contains("Events injected: 1")) {
                            this.deviceInfo.setMonkeyEventType(1);
                        }
                        break block12;
                    }
                    return msg;
                }
                catch (Exception ex) {
                    msg.setStatus(20);
                    msg.setContent("\u8bfb\u53d6\u4e8b\u4ef6\u53c2\u6570\u5931\u8d25");
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            try {
                IDevice device = this.deviceInfo.getDevice();
                RawImage rawImage = device.getScreenshot();
                this.deviceInfo.setScreenDpiWidth(rawImage.width);
                this.deviceInfo.setScreenDpiHeight(rawImage.height);
            }
            catch (Exception e) {
                msg.setStatus(20);
                msg.setContent("\u8bfb\u53d6\u5206\u8fa8\u7387\u5931\u8d25");
                log.error((Object)e.getMessage(), (Throwable)e);
                return msg;
            }
            int portraitOrientation = this.getPortraitOrientation();
            if (portraitOrientation == -1) {
                msg.setStatus(20);
                msg.setContent("\u8bfb\u53d6\u5c4f\u5e55\u53c2\u6570\u5931\u8d25");
                return msg;
            }
            this.deviceInfo.setPortraitOrientation(portraitOrientation);
            int rotation = this.getRotation();
            boolean flag = this.updateDisplayWH(rotation);
            if (!flag) {
                this.deviceInfo.setDisplayWidth(this.deviceInfo.getScreenDpiWidth());
                this.deviceInfo.setDisplayHeight(this.deviceInfo.getScreenDpiHeight());
            }
            if (StringUtils.isNotEmpty((String)(keyMap = this.getVirtualKeyMap()))) {
                this.deviceInfo.setVirtualkeys(new VirtualKeys(keyMap));
            } else {
                this.deviceInfo.setVirtualkeys(null);
            }
            boolean isBtnTouchSupport = this.isBtnTouchEventSupported();
            this.deviceInfo.setSupportBtnTouchEvent(isBtnTouchSupport);
            this.deviceInfo.setSupportScreenEventCapture(this.hasLabel_X_And_Y() && this.deviceInfo.getSdkVer() >= 15);
        }
        return msg;
    }

    private boolean hasLabel_X_And_Y() {
        Message exeResult = this.executeShellCommand("getevent -p -l", 5000);
        if (exeResult.getStatus() == 0) {
            String[] contents = exeResult.getContent().split("add device");
            int i = 0;
            while (i < contents.length) {
                if (contents[i].contains("ABS_MT_POSITION_X") && contents[i].contains("ABS_MT_POSITION_Y")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isBtnTouchEventSupported() {
        Message exeResult = this.executeShellCommand("getevent -p -l", 5000);
        if (exeResult.getStatus() == 0) {
            String[] contents = exeResult.getContent().split("add device");
            int i = 0;
            while (i < contents.length) {
                if (contents[i].contains("BTN_TOUCH") && contents[i].contains("ABS_MT_POSITION_X")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private String getVirtualKeyMap() {
        Message exeResult = this.executeShellCommand("cat /sys/board_properties/virtualkeys*", 5000);
        if (exeResult.getStatus() == 0) {
            return exeResult.getContent();
        }
        return "";
    }

    @Override
    public int getPortraitOrientation() {
        int portraitOrientation = this.deviceInfo.getPortraitOrientation();
        if (portraitOrientation != -1) {
            return portraitOrientation;
        }
        Message msg = new Message();
        try {
            msg = this.executeShellCommand(this.window_cmd, 10000);
            if (msg.getStatus() == 0) {
                String ret = msg.getContent();
                Pattern p2 = Pattern.compile(".*mPortraitRotation=(\\d).*");
                Matcher m = p2.matcher(ret);
                if (m.find()) {
                    portraitOrientation = Integer.parseInt(m.group(1));
                    this.deviceInfo.setPortraitOrientation(portraitOrientation);
                } else {
                    this.window_cmd = "dumpsys window";
                    msg = this.executeShellCommand(this.window_cmd, 10000);
                    if (msg.getStatus() == 0) {
                        ret = msg.getContent();
                        p2 = Pattern.compile(".*mPortraitRotation=(\\d).*");
                        m = p2.matcher(ret);
                        if (m.find()) {
                            portraitOrientation = Integer.parseInt(m.group(1));
                            this.deviceInfo.setPortraitOrientation(portraitOrientation);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            msg.setStatus(20);
            msg.setContent("\u8bfb\u53d6\u5c4f\u5e55\u53c2\u6570\u5931\u8d25");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (portraitOrientation == -1 && this.deviceInfo.getSdkVer() <= 10) {
            portraitOrientation = 0;
        }
        return portraitOrientation;
    }

    @Override
    public int getRotation() {
        int orientation = 0;
        Pattern p = Pattern.compile(".*mRotation=(\\d)[,\\s].*", 40);
        try {
            Matcher m;
            Message msg = this.executeShellCommand("dumpsys window windows", 10000);
            String ret = msg.getContent();
            if (ret != null && (m = p.matcher(ret)).find()) {
                orientation = Integer.parseInt(m.group(1));
                int w = this.deviceInfo.getScreenDpiWidth();
                int h = this.deviceInfo.getScreenDpiHeight();
                int portraitOrientation = this.deviceInfo.getPortraitOrientation();
                if (portraitOrientation == 0 && w > 0 && h > 0 && w > h) {
                    --orientation;
                    orientation = (orientation + 4) % 4;
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return orientation;
    }

    @Override
    public boolean updateDisplayWH(int rotation) {
        boolean ret;
        block4: {
            Message msg = new Message();
            ret = false;
            try {
                String[] searchPatterns;
                boolean portrait = rotation == 0 || rotation == 2;
                msg = this.executeShellCommand(this.window_cmd, 10000);
                if (msg.getStatus() != 0) break block4;
                String dumpWinResult = msg.getContent();
                String[] stringArray = searchPatterns = new String[]{".*mStable=\\(\\d+,\\d+\\)-\\((\\d+),(\\d+)\\)", ".*mStableFullscreen=\\(\\d+,\\d+\\)-\\((\\d+),(\\d+)\\)", ".*mRestrictedScreen=\\(\\d+,\\d+\\)\\s(\\d+)x(\\d+)"};
                int n = searchPatterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String searchPattern = stringArray[n2];
                    if (this.setDisplayWH(searchPattern, dumpWinResult, portrait)) {
                        ret = true;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                msg.setStatus(20);
                msg.setContent("\u8bfb\u53d6\u5c4f\u5e55\u53c2\u6570\u5931\u8d25");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return ret;
    }

    private boolean setDisplayWH(String searchPattern, String dumpWinStr, boolean isPortrait) {
        try {
            Pattern p2 = Pattern.compile(searchPattern);
            Matcher m = p2.matcher(dumpWinStr);
            if (m.find()) {
                if (isPortrait) {
                    this.deviceInfo.setDisplayWidth(Integer.parseInt(m.group(1)));
                    this.deviceInfo.setDisplayHeight(Integer.parseInt(m.group(2)));
                } else {
                    this.deviceInfo.setDisplayWidth(Integer.parseInt(m.group(2)));
                    this.deviceInfo.setDisplayHeight(Integer.parseInt(m.group(1)));
                }
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.warn((Object)("Unable to set display width and height. error msg: " + e.getMessage()));
        }
        return false;
    }

    @Override
    public byte[] getScreenshot(int rotate) {
        IDevice device;
        RawImage rawImage;
        byte[] buff;
        block4: {
            buff = null;
            rawImage = null;
            device = this.deviceInfo.getDevice();
            if (device != null) break block4;
            log.error((Object)"device is not found!");
            return null;
        }
        try {
            rawImage = device.getScreenshot();
            Utils.CURRENT_SCREENSHOT_TAKEN_TIME = System.currentTimeMillis();
            if (rawImage != null) {
                buff = ImageCoder.rotate(this.decoder(rawImage), rotate);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return buff;
    }

    private byte[] decoder(RawImage rawImage) throws IOException {
        byte[] buff = null;
        BufferedImage image = null;
        int width2 = rawImage.width;
        int height2 = rawImage.height;
        image = rawImage.bpp == 24 ? new BufferedImage(width2, height2, 1) : (rawImage.bpp == 32 ? new BufferedImage(width2, height2, 1) : new BufferedImage(width2, height2, 8));
        int index = 0;
        int indexInc = rawImage.bpp >> 3;
        int y = 0;
        while (y < rawImage.height) {
            int x = 0;
            while (x < rawImage.width) {
                int value = rawImage.getARGB(index);
                image.setRGB(x, y, value);
                ++x;
                index += indexInc;
            }
            ++y;
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "JPEG", bo);
        buff = bo.toByteArray();
        return buff;
    }

    @Override
    public Message clearMainLog() {
        return this.mainLogcat.clearLog();
    }

    @Override
    public void startMainLog(IDeviceShell.LogcatLevel level, String filter, IDeviceShell.ILogcatListener listener) {
        this.mainLogcat.startLog(level, filter, listener);
    }

    @Override
    public void stopMainLog() {
        this.mainLogcat.stopLog();
    }

    @Override
    public Message installApp(String localPath, int timeout) {
        log.info((Object)("Install app: " + localPath + ", timeout: " + timeout));
        String cmd = null;
        int sdkVer = this.deviceInfo.getSdkVer();
        localPath = String.format("\"%s\"", localPath);
        cmd = sdkVer >= 8 ? "install -r " + localPath : "install -r " + localPath;
        cmd = AdbForm.formAdbRequest(this.serialNumber, cmd);
        Message msg = new Message();
        try {
            InstallOutputReceiver rcvr = new InstallOutputReceiver();
            ShellExecutor.executeCommand(DirectoryService.getToolsDir(), cmd, rcvr, timeout);
            msg.setContent(rcvr.getOutput());
        }
        catch (ShellCommandUnresponsiveException e) {
            msg.setStatus(10);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.info((Object)String.format("Install %s finished, status: %s, content: %s", localPath, msg.getStatus(), msg.getContent()));
        return msg;
    }

    @Override
    public boolean checkAppIsInstalled(String packageName) {
        long size = this.getRomotePackageSize(packageName);
        return size > 0L;
    }

    @Override
    public Message uninstallApp(String packageName) {
        log.info((Object)("Uninstall package: " + packageName));
        Message msg = new Message();
        if (!this.deviceInfo.isStateOK()) {
            log.info((Object)("Device " + this.deviceInfo + " state is unknown. Ignore uninstall action for package: " + packageName));
            return msg;
        }
        String cmd = String.format("uninstall \"%s\"", packageName);
        cmd = AdbForm.formAdbRequest(this.serialNumber, cmd);
        try {
            int timeout = 30000;
            InstallOutputReceiver rcvr = new InstallOutputReceiver();
            ShellExecutor.executeCommand(DirectoryService.getToolsDir(), cmd, rcvr, timeout);
            msg.setContent(rcvr.getOutput());
        }
        catch (ShellCommandUnresponsiveException e) {
            msg.setStatus(10);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.info((Object)String.format("Uninstall %s finished, status: %s, content: %s", packageName, msg.getStatus(), msg.getContent()));
        return msg;
    }

    @Override
    public Message startApp(String packageName, String launchablePath, int timeout) {
        String command = String.format("am start -a android.intent.action.MAIN -n '%s'", launchablePath);
        return this.executeShellCommand(command, timeout);
    }

    @Override
    public Message forceStop(String packageName) {
        int timeout = 10000;
        String command = null;
        int ver = this.deviceInfo.getSdkVer();
        if (ver >= 14) {
            command = "am force-stop " + packageName;
            return this.executeShellCommand(command, timeout);
        }
        return new Message();
    }

    @Override
    public Message kill(String processName) {
        Busybox busybox = new Busybox(this.deviceInfo);
        return busybox.killall(processName);
    }

    @Override
    public void click(int x, int y) {
        new Clicker(this).click(x, y);
    }

    @Override
    public void longClick(int x, int y) {
        new Clicker(this).longClick(x, y);
    }

    @Override
    public void drag(int fromX, int toX, int fromY, int toY) {
        Scroller scroller = new Scroller(this);
        scroller.drag(fromX, toX, fromY, toY);
    }

    @Override
    public Message inputKey(IDeviceShell.KeyCode keyCode) {
        int key = 0;
        switch (keyCode) {
            case BACK: {
                key = 4;
                break;
            }
            case HOME: {
                key = 3;
                break;
            }
            case MENU: {
                key = 82;
                break;
            }
            case DPAD_LEFT: {
                key = 21;
                break;
            }
            case DPAD_CENTER: {
                key = 23;
                break;
            }
        }
        int timeout = 5000;
        String command = "input keyevent " + key;
        return this.executeShellCommand(command, timeout);
    }

    @Override
    public Message push(String local, String remote, int timeout) {
        String.format("push \"%s\" \"%s\"", local, remote);
        Message msg = new Message();
        try {
            IDevice device = this.deviceInfo.getDevice();
            device.pushFile(local, remote);
            msg.setStatus(0);
        }
        catch (SyncException e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (TimeoutException e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return msg;
    }

    @Override
    public Message executeShellCommand(String command, int timeout) {
        Message msg = new Message();
        ShellExecutor.DefaultShellOutputReceiver rcvr = new ShellExecutor.DefaultShellOutputReceiver();
        msg = this.executeShellCommand(command, rcvr, timeout);
        msg.setContent(rcvr.getOutput());
        return msg;
    }

    @Override
    public Message executeShellCommand(String command, IShellOutputReceiver rcvr, int timeout) {
        AdbForm.formAdbShellRequest(this.serialNumber, command);
        Message msg = new Message();
        try {
            IDevice device = this.deviceInfo.getDevice();
            device.executeShellCommand(command, (com.android.ddmlib.IShellOutputReceiver)rcvr, timeout);
            msg.setStatus(0);
        }
        catch (TimeoutException e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (com.android.ddmlib.ShellCommandUnresponsiveException e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            msg.setStatus(20);
            msg.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return msg;
    }

    @Override
    public long getRomotePackageSize(String packageName) {
        long psize = 0L;
        int timeout = 10000;
        try {
            int pos;
            String command = "pm path " + packageName;
            Message msg = this.executeShellCommand(command, timeout);
            String res = msg.getContent();
            String path = "";
            if (res != null && !res.equals("") && (pos = res.indexOf("package:")) != -1) {
                res = res.replace("\r\n", "");
                path = res.substring(pos + "package:".length());
            }
            if (path != null && !path.equals("")) {
                psize = this.getRemoteFileSize(path, timeout);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return psize;
    }

    private long getRemoteFileSize(String path, int timeout) {
        long psize = 0L;
        String command = "ls -l " + path;
        Message msg = this.executeShellCommand(command, timeout);
        String res = msg.getContent();
        if (res != null && !res.equals("")) {
            String[] tmps = res.split(" ");
            ArrayList<String> infos = new ArrayList<String>();
            String[] stringArray = tmps;
            int n = tmps.length;
            int n2 = 0;
            while (n2 < n) {
                String tmp = stringArray[n2];
                if (!tmp.trim().equals("")) {
                    infos.add(tmp);
                }
                ++n2;
            }
            String[] values = new String[infos.size()];
            infos.toArray(values);
            try {
                if (values.length == 7) {
                    psize = Long.parseLong(values[3]);
                } else if (values.length == 9) {
                    psize = Long.parseLong(values[4]);
                }
            }
            catch (NumberFormatException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            if (psize == 0L) {
                int index = -1;
                int i = 0;
                while (i < values.length) {
                    String s = values[i];
                    if (s.indexOf("system") != -1) {
                        index = i;
                    }
                    ++i;
                }
                if (index > 0 && values.length > index + 1) {
                    psize = Long.parseLong(values[index + 1]);
                }
            }
        }
        return psize;
    }

    private final class InstallOutputReceiver
    extends MultiLineReceiver {
        private static final String EOF = "\r\n";
        private boolean isCancel = false;
        private StringBuffer output = new StringBuffer();

        private InstallOutputReceiver() {
        }

        @Override
        public void processNewLines(String[] arg0) {
            String[] stringArray = arg0;
            int n = arg0.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.length() > 0) {
                    this.output.append(String.valueOf(line) + EOF);
                }
                if (line.indexOf("error: closed") != -1) {
                    this.cancel();
                } else if (line.indexOf("waiting for device") != -1) {
                    this.cancel();
                } else if (line.indexOf("Success") != -1) {
                    this.cancel();
                }
                ++n2;
            }
        }

        public String getOutput() {
            return this.output.toString();
        }

        public void cancel() {
            this.isCancel = true;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancel;
        }
    }
}

