/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device;

import com.android.ddmlib.IDevice;
import com.testin.itestin.device.AndroidShell;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.event.VirtualKeys;
import com.testin.itestin.os.Message;
import com.testin.itestin.util.Utils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DeviceInfo {
    static Logger log = Logger.getLogger(DeviceInfo.class);
    private String serialNumber;
    private String brandName;
    private String modelName;
    private int sdkVer;
    private String releaseVer;
    private int screenDpiWidth;
    private int screenDpiHeight;
    private int displayWidth;
    private int displayHeight;
    private int portraitOrientation = -1;
    private int monkeyEventType;
    private boolean supportScreenEventCapture = false;
    private IDevice device;
    private IDeviceShell deviceShell;
    private boolean online;
    private boolean runTask = false;
    private VirtualKeys virtualkeys;
    private boolean supportBtnTouchEvent;

    private DeviceInfo(String serialNumber) {
        this.serialNumber = serialNumber;
        this.online = false;
    }

    Message init() {
        return this.deviceShell.initDevice();
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getModelName() {
        if (!StringUtils.isEmpty((String)this.modelName) && !StringUtils.isEmpty((String)this.getBrandName())) {
            return this.modelName.replace(this.getBrandName(), "").trim();
        }
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public int getSdkVer() {
        return this.sdkVer;
    }

    public void setSdkVer(int sdkVer) {
        this.sdkVer = sdkVer;
    }

    public String getReleaseVer() {
        return this.releaseVer;
    }

    public void setReleaseVer(String releaseVer) {
        this.releaseVer = releaseVer;
    }

    public int getScreenDpiWidth() {
        return this.screenDpiWidth;
    }

    public void setScreenDpiWidth(int screenDpiWidth) {
        this.screenDpiWidth = screenDpiWidth;
    }

    public int getScreenDpiHeight() {
        return this.screenDpiHeight;
    }

    public void setScreenDpiHeight(int screenDpiHeight) {
        this.screenDpiHeight = screenDpiHeight;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplayWidth(int displayWidth) {
        log.info((Object)("Set display width to " + displayWidth));
        this.displayWidth = displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public void setDisplayHeight(int displayHeight) {
        log.info((Object)("Set display height to " + displayHeight));
        this.displayHeight = displayHeight;
    }

    public int getPortraitOrientation() {
        return this.portraitOrientation;
    }

    public void setPortraitOrientation(int portraitOrientation) {
        this.portraitOrientation = portraitOrientation;
    }

    public int getMonkeyEventType() {
        return this.monkeyEventType;
    }

    public void setMonkeyEventType(int monkeyEventType) {
        this.monkeyEventType = monkeyEventType;
    }

    public IDevice getDevice() {
        return this.device;
    }

    public void setDevice(IDevice device) {
        this.device = device;
    }

    public IDeviceShell getDeviceShell() {
        return this.deviceShell;
    }

    public void setDeviceShell(IDeviceShell deviceShell) {
        this.deviceShell = deviceShell;
    }

    public void onDeviceConnected() {
        this.online = true;
    }

    public void onDeviceDisconnected() {
        this.online = false;
    }

    public int getState() {
        if (this.online && this.runTask) {
            return 1;
        }
        if (this.online) {
            return 0;
        }
        return 9;
    }

    public boolean isStateOK() {
        return this.getState() != 9;
    }

    public void startWork() {
        this.runTask = true;
    }

    public void stopWork() {
        this.runTask = false;
    }

    public boolean isWork() {
        return this.online && this.runTask;
    }

    public String toString() {
        return String.format("SN: %s, Brand: %s, Model: %s, SDK: %s, ScreenWidth: %s, ScreenHeight: %s", this.getSerialNumber(), this.getBrandName(), this.getModelName(), this.getSdkVer(), this.getDisplayWidth(), this.getDisplayHeight());
    }

    public void setVirtualkeys(VirtualKeys virtualKeys) {
        this.virtualkeys = virtualKeys;
    }

    public VirtualKeys getVirtualkeys() {
        return this.virtualkeys;
    }

    public void setSupportBtnTouchEvent(boolean isBtnTouchSupport) {
        this.supportBtnTouchEvent = isBtnTouchSupport;
    }

    public boolean isSupportBtnTouchEvent() {
        return this.supportBtnTouchEvent;
    }

    public boolean isSupportScreenEventCapture() {
        return this.supportScreenEventCapture;
    }

    public void setSupportScreenEventCapture(boolean supportScreenEventCapture) {
        this.supportScreenEventCapture = supportScreenEventCapture;
    }

    public String getPixel() {
        int h;
        int w = this.getScreenDpiWidth();
        String pixel = w < (h = this.getScreenDpiHeight()) ? String.format("%sx%s", w, h) : String.format("%sx%s", h, w);
        return pixel;
    }

    public String getScreenProportion() {
        int w = this.getScreenDpiWidth();
        int h = this.getScreenDpiHeight();
        int divisionfactor = Utils.getLargestDivisionFactor(w, h);
        if (w > h) {
            return String.format("%s:%s", w / divisionfactor, h / divisionfactor);
        }
        return String.format("%s:%s", h / divisionfactor, w / divisionfactor);
    }

    /* synthetic */ DeviceInfo(String string, DeviceInfo deviceInfo) {
        this(string);
    }

    public static final class Factory {
        public static DeviceInfo newInstance(String serialNumber) {
            DeviceInfo di = new DeviceInfo(serialNumber, null);
            AndroidShell deviceShell = new AndroidShell(di);
            di.setDeviceShell(deviceShell);
            return di;
        }
    }
}

