/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device;

import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.os.Message;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DevicePropReader {
    public static final String PROP_BUILD_VERSION = "ro.build.version.release";
    public static final String PROP_BUILD_API_LEVEL = "ro.build.version.sdk";
    public static final String PROP_PRODUCT_BRAND = "ro.product.brand";
    public static final String PROP_PRODUCT_MODEL = "ro.product.model";
    public static final String PROP_BUILD_DISPLAY_ID = "ro.build.display.id";
    public static final String PROP_BUILD_ID = "ro.build.id";
    String propRegex = "\\[(.*?)\\]:\\s\\[(.*?)\\]";
    Pattern propPattern;
    IDeviceShell deviceShell;
    public DeviceProp deviceProp;

    DevicePropReader(IDeviceShell deviceShell) {
        this.deviceShell = deviceShell;
        this.deviceProp = new DeviceProp();
        this.propPattern = Pattern.compile(this.propRegex);
    }

    public Message readProp() {
        String command = "getprop";
        int timeout = 10000;
        Message msg = this.deviceShell.executeShellCommand(command, timeout);
        if (msg.getStatus() == 0) {
            String[] lines;
            String res;
            this.deviceProp.propertiesStr = res = msg.getContent();
            String[] stringArray = lines = res.split("\r\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher m;
                String line = stringArray[n2];
                if (!line.equals("") && (m = this.propPattern.matcher(line)).find()) {
                    String name = m.group(1);
                    String value = m.group(2);
                    if (name.equals(PROP_BUILD_VERSION)) {
                        this.deviceProp.releaseVer = value;
                    } else if (name.equals(PROP_BUILD_API_LEVEL)) {
                        this.deviceProp.sdkVer = Integer.parseInt(value);
                    } else if (name.equals(PROP_PRODUCT_BRAND)) {
                        this.deviceProp.brandName = value;
                    } else if (name.equals(PROP_PRODUCT_MODEL)) {
                        this.deviceProp.modelName = value;
                    } else if (name.equals(PROP_BUILD_DISPLAY_ID)) {
                        this.deviceProp.displayId = value;
                    } else if (name.equals(PROP_BUILD_ID)) {
                        this.deviceProp.buildId = value;
                    }
                }
                ++n2;
            }
        }
        return msg;
    }

    public class DeviceProp {
        public String releaseVer;
        public int sdkVer;
        public String brandName;
        public String modelName;
        public String displayId;
        public String buildId;
        public String propertiesStr;
    }
}

