/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device;

import com.testin.itestin.device.AndroidDevicesManager;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.IDeviceShell;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DevicesManager {
    static Logger log = Logger.getLogger(DevicesManager.class);
    private static DevicesManager devicesManager = new DevicesManager();
    private List<DeviceInfo> deviceInfos = new ArrayList<DeviceInfo>();
    private DeviceInfo currentDeviceInfo;
    private List<DeviceStateListener> listeners = new ArrayList<DeviceStateListener>();

    private DevicesManager() {
    }

    public static DevicesManager getInstance() {
        return devicesManager;
    }

    public static DeviceInfo getDevice() {
        return DevicesManager.getInstance().getCurrentDeviceInfo();
    }

    public static IDeviceShell getShell() {
        DeviceInfo deviceinfo = DevicesManager.getDevice();
        if (DevicesManager.isDeviceOK(deviceinfo)) {
            return deviceinfo.getDeviceShell();
        }
        return null;
    }

    public static boolean isDeviceOK(DeviceInfo deviceinfo) {
        return deviceinfo != null && deviceinfo.getDevice() != null && deviceinfo.getDevice().isOnline();
    }

    public static boolean isDeviceOK() {
        DeviceInfo deviceinfo = DevicesManager.getDevice();
        return deviceinfo != null && deviceinfo.getDevice() != null && deviceinfo.getDevice().isOnline();
    }

    public void start() {
        AndroidDevicesManager.getInstance().start();
    }

    public void addDeviceStateListener(DeviceStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeDeviceStateListener(DeviceStateListener listener) {
        this.listeners.add(listener);
    }

    void notifyDeviceStateListener(DeviceInfo deviceInfo, int state) {
        for (DeviceStateListener listener : this.listeners) {
            listener.onStateChange(deviceInfo, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeviceInfo(DeviceInfo deviceInfo) {
        List<DeviceInfo> list = this.deviceInfos;
        synchronized (list) {
            log.info((Object)String.format("Device %s conntected. Info %s", deviceInfo.getSerialNumber(), deviceInfo.toString()));
            this.deviceInfos.add(deviceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDeviceInfo(DeviceInfo deviceInfo) {
        List<DeviceInfo> list = this.deviceInfos;
        synchronized (list) {
            log.info((Object)String.format("Device %s disconnected. Info: %s", deviceInfo.getSerialNumber(), deviceInfo.toString()));
            String sn = deviceInfo.getSerialNumber();
            DeviceInfo di = this.getDeviceInfoBySn(sn);
            this.deviceInfos.remove(di);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<DeviceInfo> getDeviceInfos() {
        List<DeviceInfo> list = this.deviceInfos;
        synchronized (list) {
            ArrayList<DeviceInfo> dis = new ArrayList<DeviceInfo>();
            for (DeviceInfo di : this.deviceInfos) {
                dis.add(di);
            }
            return dis.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeviceInfo getDeviceInfoBySn(String sn) {
        List<DeviceInfo> list = this.deviceInfos;
        synchronized (list) {
            DeviceInfo cfg = null;
            for (DeviceInfo di : this.deviceInfos) {
                if (!sn.equals(di.getSerialNumber())) continue;
                cfg = di;
                break;
            }
            return cfg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<DeviceInfo> getOnlineDeviceInfos() {
        List<DeviceInfo> list = this.deviceInfos;
        synchronized (list) {
            ArrayList<DeviceInfo> dis = new ArrayList<DeviceInfo>();
            for (DeviceInfo di : this.deviceInfos) {
                if (di.getState() == 9 || di.getDevice() == null || !di.getDevice().isOnline()) continue;
                dis.add(di);
            }
            return dis.iterator();
        }
    }

    public void setCurrentDeviceInfo(DeviceInfo di) {
        this.currentDeviceInfo = di;
    }

    private DeviceInfo getCurrentDeviceInfo() {
        return this.currentDeviceInfo;
    }

    public static interface DeviceStateListener {
        public void onStateChange(DeviceInfo var1, int var2);
    }
}

