/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device;

import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class Monkey {
    static Logger log = Logger.getLogger(Monkey.class);
    private IDeviceShell deviceShell;
    private String command;
    private int timeout;
    private int fnIndex;
    private int flag = 0;
    private boolean isCancelled = false;
    private String monkeyLog = null;
    final Thread monkeyTest = new Thread("MonkeyTest"){

        @Override
        public void run() {
            try {
                Message msg = Monkey.this.deviceShell.executeShellCommand(Monkey.this.command, Monkey.this.timeout * 2);
                Monkey.this.monkeyLog = msg.getContent();
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            Monkey.this.isCancelled = true;
            Utils.gc();
        }
    };

    public Monkey(IDeviceShell deviceShell) {
        this.deviceShell = deviceShell;
        this.fnIndex = 1;
    }

    private void checkMonkeyEventCount() {
        if (this.flag == 0) {
            String oppoFile = String.valueOf(DirectoryService.getToolsDir()) + File.separator + "oppo.monkey";
            this.deviceShell.push(oppoFile, "/data/local/tmp/itestin.monkey", 30000);
            Message msg = this.deviceShell.executeShellCommand("monkey -f /data/local/tmp/itestin.monkey 1", 15000);
            String res = msg.getContent();
            this.flag = res.contains("Events injected: 1") ? 2 : 1;
        }
    }

    /*
     * Loose catch block
     */
    public void execute(String monkey, int eventCount, int timeout) {
        this.checkMonkeyEventCount();
        String remote = "/data/local/tmp/itestin.monkey";
        String local = String.valueOf(DirectoryService.getTempDir()) + File.separatorChar + this.hashCode() + "_" + this.fnIndex + "_itestin.monkey";
        ++this.fnIndex;
        File local_f = new File(local);
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(local_f);
                fos.write(monkey.getBytes("utf-8"));
                fos.flush();
                fos.close();
                fos = null;
                String command = "monkey -f " + remote + " 1";
                if (this.flag == 2) {
                    command = "monkey -f " + remote + " " + eventCount;
                }
                this.deviceShell.push(local, remote, timeout);
                this.deviceShell.executeShellCommand(command, timeout);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
                if (local_f.exists()) {
                    local_f.delete();
                }
            }
            catch (UnsupportedEncodingException e) {
                block27: {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    if (fos == null) break block27;
                    try {
                        fos.close();
                    }
                    catch (IOException e3) {
                        log.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                }
                if (local_f.exists()) {
                    local_f.delete();
                }
            }
            catch (IOException e) {
                block28: {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    if (fos == null) break block28;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        fos.close();
                    }
                    catch (IOException e4) {
                        log.error((Object)e4.getMessage(), (Throwable)e4);
                    }
                }
                if (local_f.exists()) {
                    local_f.delete();
                }
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (local_f.exists()) {
                local_f.delete();
            }
        }
    }

    public void startMonkeyTest(String packageName, int timeout) {
        this.isCancelled = false;
        this.monkeyLog = null;
        this.timeout = timeout;
        int eventCount = timeout / 1000 * 5;
        int seed = 1;
        this.command = "monkey --throttle 500 --pct-trackball 0 --pct-nav 0 --pct-appswitch 0 -c android.intent.category.LAUNCHER --pct-anyevent 0 -s " + seed + " -p '" + packageName + "' -v " + eventCount;
        ThreadPool.execute(this.monkeyTest);
    }

    public void startMonkeyTest(int timeout) {
        this.isCancelled = false;
        this.monkeyLog = null;
        this.timeout = timeout;
        int eventCount = timeout / 1000 * 5;
        int seed = 1;
        this.command = "monkey --throttle 500 --pct-trackball 0 --pct-nav 0 --pct-appswitch 0 -c android.intent.category.LAUNCHER --pct-anyevent 0 -s " + seed + " -v " + eventCount;
        ThreadPool.execute(this.monkeyTest);
    }

    public boolean isCancel() {
        return this.isCancelled;
    }

    public String getMonkeyLog() {
        return this.monkeyLog;
    }

    public void stopMonkeyTest() {
    }
}

