/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device.event;

import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.event.Pointer;

public class Action {
    private Pointer point = null;
    private long time = 0L;
    private boolean isTouchDown = false;
    private boolean isTouchUp = false;
    private int pressure = 50;
    private IDeviceShell.KeyCode keycode = null;

    public Action(int x, int y) {
        this.setPoint(new Pointer(x, y));
        this.setTime(System.currentTimeMillis());
    }

    public Action(IDeviceShell.KeyCode keycode, boolean ispressdown, boolean isrelease) {
        this.setPoint(new Pointer(0, 0));
        this.setKeycode(keycode);
        this.setTouchDown(ispressdown);
        this.setTouchUp(isrelease);
        this.setTime(System.currentTimeMillis());
    }

    public Action(int x, int y, int pressure) {
        this.setPoint(new Pointer(x, y));
        this.setTime(System.currentTimeMillis());
    }

    public Action(Pointer point) {
        this.setPoint(point);
        this.setTime(System.currentTimeMillis());
    }

    public Action(int x, int y, boolean istouchdown, boolean istouchup) {
        this.setPoint(new Pointer(x, y));
        this.setTime(System.currentTimeMillis());
        this.setTouchDown(istouchdown);
        this.setTouchUp(istouchup);
    }

    public Pointer getPoint() {
        return this.point;
    }

    public void setPoint(Pointer point) {
        this.point = point;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isOldAction() {
        return System.currentTimeMillis() - this.getTime() > 100L;
    }

    public boolean isVeryOldAction() {
        return System.currentTimeMillis() - this.getTime() > 1000L;
    }

    public String toString() {
        if (this.isTouchDown() || this.isTouchUp()) {
            return String.format("%s", this.isTouchDown() ? "TOUCH DOWN" : "TOUCH UP");
        }
        return String.format("%s%s", this.getPoint(), this.getTime());
    }

    public boolean isTouchDown() {
        return this.isTouchDown;
    }

    public void setTouchDown(boolean isTouchDown) {
        this.isTouchDown = isTouchDown;
    }

    public boolean isTouchUp() {
        return this.isTouchUp;
    }

    public void setTouchUp(boolean isTouchUp) {
        this.isTouchUp = isTouchUp;
    }

    public float getPressure() {
        return (float)this.pressure / 255.0f;
    }

    public void setPressure(int pressure) {
        this.pressure = pressure;
    }

    public IDeviceShell.KeyCode getKeycode() {
        return this.keycode;
    }

    public void setKeycode(IDeviceShell.KeyCode keycode) {
        this.keycode = keycode;
    }
}

