/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device.event;

import com.testin.itestin.business.actions.ActionRule;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.event.Action;
import com.testin.itestin.device.event.Pointer;
import java.util.ArrayList;

public class Event {
    public static final int CLICK = 0;
    public static final int LONG_CLICK = 1;
    public static final int DRAG = 2;
    public static final int KEY_PRESS = 3;
    public static final int END = 999;
    public static final int DOUBLE_CLICK = 4;
    private long time = 0L;
    private int type = 0;
    private IDeviceShell.KeyCode keycode;
    private Pointer center = null;
    private Pointer start = null;
    private Pointer end = null;
    private ArrayList<Action> actionList = new ArrayList();
    private String windowInfo = "";

    public Event() {
        this.setTime(System.currentTimeMillis());
    }

    public Event(int type) {
        this.setType(type);
        this.setTime(System.currentTimeMillis());
    }

    public Event(int eventType, Pointer centerpoint) {
        this.setType(eventType);
        this.setCenter(centerpoint);
        this.setTime(System.currentTimeMillis());
        this.setWindowInfo(this.windowInfo);
    }

    public Event(int eventType, Pointer start, Pointer end) {
        this.setType(eventType);
        this.setStart(start);
        this.setEnd(end);
        this.setTime(System.currentTimeMillis());
    }

    public Event(int eventType, ArrayList<Action> actions) {
        this.setType(eventType);
        this.setActionList(actions);
        if (actions.size() > 1) {
            this.setStart(actions.get(0).getPoint().isZero() ? actions.get(1).getPoint() : actions.get(0).getPoint());
            this.setEnd(actions.get(actions.size() - 1).getPoint().isZero() ? actions.get(actions.size() - 2).getPoint() : actions.get(actions.size() - 1).getPoint());
        }
        this.setTime(System.currentTimeMillis());
    }

    private void cloneArray(ArrayList<Action> actions) {
        if (actions == null) {
            return;
        }
        int i = 0;
        while (i < actions.size()) {
            if (i == 0 && !actions.get(i).isTouchDown()) {
                actions.get(i).setTouchDown(true);
            }
            if (i == actions.size() - 1 && !actions.get(i).isTouchUp()) {
                actions.get(i).setTouchUp(true);
            }
            this.actionList.add(actions.get(i));
            ++i;
        }
    }

    public Event(int eventType, IDeviceShell.KeyCode keycode) {
        this.setType(eventType);
        this.setKeycode(keycode);
        this.setCenter(new Pointer(0, 0));
        this.setTime(System.currentTimeMillis());
    }

    public IDeviceShell.KeyCode getKeycode() {
        return this.keycode;
    }

    public void setKeycode(IDeviceShell.KeyCode keycode) {
        this.keycode = keycode;
    }

    public Pointer getCenter() {
        return this.center;
    }

    public void setCenter(Pointer center) {
        this.center = center;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Pointer getStart() {
        return this.start;
    }

    public void setStart(Pointer start) {
        this.start = start;
    }

    public Pointer getEnd() {
        return this.end;
    }

    public void setEnd(Pointer end) {
        this.end = end;
    }

    public String getTypeName() {
        switch (this.getType()) {
            case 0: {
                return "CLICK";
            }
            case 2: {
                return "DRAG";
            }
            case 1: {
                return "LONGCLICK";
            }
            case 3: {
                return "KEYPRESS";
            }
            case 4: {
                return "DOUBLE_CLICK";
            }
        }
        return "UNKNOWN";
    }

    public String getKeyName() {
        String keyname = "";
        switch (this.getKeycode()) {
            case BACK: {
                keyname = "BACK";
                break;
            }
            case MENU: {
                keyname = "MENU";
                break;
            }
            case HOME: {
                keyname = "HOME";
                break;
            }
            case SEARCH: {
                keyname = "SEARCH";
                break;
            }
            default: {
                keyname = "UNKNOWN";
            }
        }
        return keyname;
    }

    public int getEventCount() {
        if (this.getType() == 3) {
            return 1;
        }
        return this.getActionList().size();
    }

    public ArrayList<Action> getActionList() {
        return this.actionList;
    }

    public void setActionList(ArrayList<Action> actionList) {
        this.cloneArray(actionList);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getStartTime() {
        if (this.getActionList() != null && this.getActionList().size() > 0) {
            return this.getActionList().get(0).getTime();
        }
        return this.getTime();
    }

    public long getEndTime() {
        if (this.getActionList() != null && this.getActionList().size() > 0) {
            return this.getActionList().get(this.getActionList().size() - 1).getTime();
        }
        return this.getTime();
    }

    public ActionRule getRule() {
        if (this.getType() == 0) {
            return ActionRule.shortaction;
        }
        if (this.getType() == 1) {
            return ActionRule.longaction;
        }
        if (this.getType() == 4) {
            return ActionRule.doubleaction;
        }
        if (this.getType() == 3) {
            return ActionRule.press;
        }
        if (this.getType() == 2) {
            return this.getDragDirection();
        }
        return null;
    }

    private ActionRule getDragDirection() {
        Pointer startPoint = this.getStart();
        Pointer endPoint = this.getEnd();
        int a = endPoint.getX() - startPoint.getX();
        int b = endPoint.getY() - startPoint.getY();
        if (Math.abs(a) <= Math.abs(b)) {
            if (b < 0) {
                return ActionRule.up;
            }
            return ActionRule.down;
        }
        if (Math.abs(b) <= Math.abs(a)) {
            if (a < 0) {
                return ActionRule.left;
            }
            return ActionRule.right;
        }
        return ActionRule.none;
    }

    public String toString() {
        if (this.getType() == 0 || this.getType() == 1 || this.getType() == 4) {
            return String.format("Type: %s Center: %s", this.getTypeName(), this.getCenter());
        }
        if (this.getType() == 2) {
            return String.format("Type: %s Start:%s End: %s", this.getTypeName(), this.getStart(), this.getEnd());
        }
        if (this.getType() == 3) {
            return String.format("Type: %s Key: %s", this.getTypeName(), this.getKeyName());
        }
        return "NONE";
    }

    public boolean isEmpty() {
        return this.getType() == 0;
    }

    public boolean isEnd() {
        return this.getType() == 999;
    }

    public int getDistance(Event anotherEvent) {
        if (this.getCenter() != null && anotherEvent.getCenter() != null) {
            return (int)Math.sqrt(Math.pow(Math.abs(this.getCenter().getX() - anotherEvent.getCenter().getX()), 2.0) + Math.pow(Math.abs(this.getCenter().getY() - anotherEvent.getCenter().getY()), 2.0));
        }
        return -1;
    }

    public String getWindowInfo() {
        return this.windowInfo;
    }

    public void setWindowInfo(String windowInfo) {
        this.windowInfo = windowInfo;
    }
}

