/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device.event;

import com.android.ddmlib.ViewClient;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.event.Action;
import com.testin.itestin.device.event.Event;
import com.testin.itestin.device.event.EventDispatcher;
import com.testin.itestin.device.event.EventOutputReceiver;
import com.testin.itestin.device.event.Pointer;
import com.testin.itestin.util.Utils;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EventAnalyzer
extends Thread {
    static Logger log = Logger.getLogger(EventAnalyzer.class);
    public static ArrayList<Action> actionQueue = new ArrayList();
    private DeviceInfo device = null;
    private boolean hasUpAndDownEvent = false;
    private boolean stop = false;
    private String curWindowInfo = "";
    private Event lastEvent = null;
    private ExecutorService event_handler_threads = Executors.newFixedThreadPool(40);

    public EventAnalyzer(DeviceInfo deviceinfo) {
        this.setDevice(deviceinfo);
    }

    @Override
    public void run() {
        try {
            do {
                if (actionQueue.size() > 0) {
                    if (StringUtils.isEmpty((String)this.getCurWindowInfo())) {
                        this.setCurWindowInfo(ViewClient.getCurrentWindowInfo());
                    }
                    if (actionQueue.get(actionQueue.size() - 1).isVeryOldAction()) {
                        this.analyzeEvent();
                    } else if (EventOutputReceiver.hasTrackingId) {
                        if (EventOutputReceiver.findTrackingIdEnd) {
                            this.analyzeEvent();
                        }
                    } else if (this.isHasUpAndDownEvent()) {
                        if (actionQueue.get(actionQueue.size() - 1).isTouchUp()) {
                            this.analyzeEvent();
                        }
                    } else if (actionQueue.get(actionQueue.size() - 1).isOldAction() || actionQueue.get(actionQueue.size() - 1).isTouchUp()) {
                        this.analyzeEvent();
                    }
                }
                Utils.sleep(10L);
            } while (!this.isStop());
        }
        finally {
            EventOutputReceiver.hasTrackingId = false;
            EventOutputReceiver.findTrackingIdEnd = false;
            log.info((Object)"EventAnalyzer Ends!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeEvent() {
        ArrayList<Action> arrayList = actionQueue;
        synchronized (arrayList) {
            block8: {
                if (this.isActionQueueValid(actionQueue)) break block8;
                actionQueue.clear();
                EventOutputReceiver.hasTrackingId = false;
                EventOutputReceiver.findTrackingIdEnd = false;
                this.setCurWindowInfo("");
                return;
            }
            try {
                try {
                    Event event = this.analyzeEvent(actionQueue);
                    actionQueue.clear();
                    this.queueEvent(event);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    EventOutputReceiver.hasTrackingId = false;
                    EventOutputReceiver.findTrackingIdEnd = false;
                    this.setCurWindowInfo("");
                }
            }
            catch (Throwable throwable) {
                EventOutputReceiver.hasTrackingId = false;
                EventOutputReceiver.findTrackingIdEnd = false;
                this.setCurWindowInfo("");
                throw throwable;
            }
            EventOutputReceiver.hasTrackingId = false;
            EventOutputReceiver.findTrackingIdEnd = false;
            this.setCurWindowInfo("");
        }
    }

    private void queueEvent(Event event) {
        if (Utils.enableScreenEventDetector) {
            event.setWindowInfo(this.getCurWindowInfo());
            this.addEventToQueue(event);
        } else {
            log.info((Object)("screen event detector is not enabled, so ignore this event: " + event));
        }
    }

    private void addEventToQueue(final Event event) {
        if (UIController.getScreenEventListener() != null && !this.isStop()) {
            Thread handler = new Thread(){

                @Override
                public void run() {
                    if (event.getType() == 0) {
                        if (EventAnalyzer.this.lastEvent != null) {
                            if (event.getStartTime() - EventAnalyzer.this.lastEvent.getEndTime() < 600L && event.getDistance(EventAnalyzer.this.lastEvent) < 25) {
                                event.setType(4);
                            }
                        } else {
                            EventAnalyzer.this.lastEvent = event;
                            for (int timeElapse = 0; timeElapse <= 600; timeElapse += 10) {
                                Utils.sleep(10L);
                                if (EventAnalyzer.this.lastEvent != null) continue;
                                return;
                            }
                        }
                    }
                    EventAnalyzer.this.lastEvent = null;
                    EventDispatcher.eventQueue.add(event);
                }
            };
            this.event_handler_threads.execute(handler);
        }
    }

    private boolean isActionQueueValid(ArrayList<Action> actionlist) {
        if (actionlist == null) {
            return false;
        }
        int i = 0;
        while (i < actionlist.size()) {
            if (actionlist.get(i).getPoint() != null && !actionlist.get(i).getPoint().isZero()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event analyzeEvent(ArrayList<Action> actions) {
        ArrayList<Action> arrayList = actions;
        synchronized (arrayList) {
            if (actions.size() > 0) {
                long timeconsumed = Math.abs(actions.get(0).getTime() - actions.get(actions.size() - 1).getTime());
                int left = actions.get(actions.size() / 2).getPoint().getX();
                int top = actions.get(actions.size() / 2).getPoint().getY();
                int right = actions.get(actions.size() / 2).getPoint().getX();
                int bottom = actions.get(actions.size() / 2).getPoint().getY();
                int i = 1;
                while (i < actions.size()) {
                    Pointer point = actions.get(i).getPoint();
                    if (left > point.getX() && point.getX() != 0) {
                        left = point.getX();
                    }
                    if (top > point.getY() && point.getY() != 0) {
                        top = point.getY();
                    }
                    if (right < point.getX() && point.getX() != 0) {
                        right = point.getX();
                    }
                    if (bottom < point.getY() && point.getY() != 0) {
                        bottom = point.getY();
                    }
                    ++i;
                }
                int len = (int)Math.sqrt(Math.pow(Math.abs(right - left), 2.0) + Math.pow(Math.abs(bottom - top), 2.0));
                int centerX = left + Math.abs(right - left) / 2;
                int centerY = top + Math.abs(bottom - top) / 2;
                IDeviceShell.KeyCode virtualKey = this.getKeyCode(new Pointer(centerX, centerY));
                IDeviceShell.KeyCode hardKey = this.getKeyCode(actions);
                if (virtualKey != null) {
                    return new Event(3, virtualKey);
                }
                if (hardKey != null) {
                    return new Event(3, hardKey);
                }
                if (len > 20 && timeconsumed > 200L || len > 100 || len > 30 && timeconsumed >= 50L) {
                    return new Event(2, actions);
                }
                if (len <= 10 && timeconsumed > 600L) {
                    Event event = new Event(1, new Pointer(centerX, centerY));
                    event.setActionList(actions);
                    return event;
                }
                Event event = new Event(0, new Pointer(centerX, centerY));
                event.setActionList(actions);
                return event;
            }
            return new Event();
        }
    }

    private IDeviceShell.KeyCode getKeyCode(ArrayList<Action> actionList) {
        int i = 0;
        while (i < actionList.size()) {
            if (actionList.get(i).getKeycode() != null) {
                return actionList.get(i).getKeycode();
            }
            ++i;
        }
        return null;
    }

    public String getActionName(Pointer point) {
        String name;
        if (this.getDevice() != null && this.getDevice().getVirtualkeys() != null && StringUtils.isNotEmpty((String)(name = this.getDevice().getVirtualkeys().getPointerName(point)))) {
            return String.format("%s%s", name, point);
        }
        return point.toString();
    }

    public IDeviceShell.KeyCode getKeyCode(Pointer point) {
        if (this.getDevice() != null && this.getDevice().getVirtualkeys() != null) {
            return this.getDevice().getVirtualkeys().getPointerKeyCode(point);
        }
        return null;
    }

    public DeviceInfo getDevice() {
        return this.device;
    }

    public void setDevice(DeviceInfo device) {
        this.device = device;
        if (this.device != null) {
            this.setHasUpAndDownEvent(this.device.isSupportBtnTouchEvent());
        }
    }

    public boolean isHasUpAndDownEvent() {
        return this.hasUpAndDownEvent;
    }

    public void setHasUpAndDownEvent(boolean hasUpAndDownEvent) {
        this.hasUpAndDownEvent = hasUpAndDownEvent;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public String getCurWindowInfo() {
        return this.curWindowInfo;
    }

    public void setCurWindowInfo(String curWindowInfo) {
        this.curWindowInfo = curWindowInfo;
    }
}

