/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device.event;

import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.device.event.EventAnalyzer;
import com.testin.itestin.device.event.EventDispatcher;
import com.testin.itestin.device.event.EventOutputReceiver;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EventDetector
extends Thread {
    private static Logger log = Logger.getLogger(EventDetector.class);
    private DeviceInfo eventSource = null;
    private ArrayList<DeviceInfo> consumers = null;
    private boolean allowDispatchEvent = true;
    private EventAnalyzer eventAnalyzer = null;
    private EventDispatcher eventDispatcher = null;
    private EventOutputReceiver getEventOutputReceiver = null;

    public EventDetector() {
        this.setEventSource(DevicesManager.getDevice());
        this.setEventAnalyzer(new EventAnalyzer(this.getEventSource()));
        this.setEventDispatcher(new EventDispatcher());
    }

    @Override
    public void run() {
        block16: {
            try {
                if (UIController.getScreenEventListener() == null) {
                    log.error((Object)"\u5c4f\u5e55\u4e8b\u4ef6\u5904\u7406\u5668\u672a\u51c6\u5907\u597d\uff0c\u6ca1\u6709\u5fc5\u8981\u542f\u52a8\u76d1\u542c\u5668");
                    return;
                }
                if (this.getEventSource() == null || this.getEventSource().getDevice() == null || !this.getEventSource().getDevice().isOnline()) {
                    log.error((Object)"\u8bbe\u5907\u6709\u95ee\u9898\uff0c\u65e0\u6cd5\u542f\u52a8\u4e8b\u4ef6\u76d1\u542c\u3002");
                    return;
                }
                if (this.getEventSource().getSdkVer() < 15) {
                    log.info((Object)"\u8bbe\u5907\u7cfb\u7edf\u7248\u672c\u4f4e\u4e8e4.0\uff0c\u65e0\u6cd5\u542f\u52a8\u4e8b\u4ef6\u76d1\u542c\u3002");
                    return;
                }
                try {
                    log.info((Object)"Event Detector Starts...");
                    if (this.getEventAnalyzer() != null) {
                        this.getEventAnalyzer().start();
                    }
                    if (this.getEventDispatcher() != null) {
                        this.getEventDispatcher().start();
                    }
                    this.getEventSource().getDeviceShell().kill("getevent");
                    this.getEventOutputReceiver = new EventOutputReceiver(this.getEventSource().getSdkVer());
                    if (this.getEventSource().getSdkVer() < 15) {
                        this.getEventSource().getDeviceShell().executeShellCommand("getevent", this.getEventOutputReceiver, 0);
                        break block16;
                    }
                    this.getEventSource().getDeviceShell().executeShellCommand("getevent -l", this.getEventOutputReceiver, 0);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            finally {
                if (this.getEventAnalyzer() != null) {
                    this.getEventAnalyzer().setStop(true);
                }
                if (this.getEventDispatcher() != null) {
                    this.getEventDispatcher().setStop(true);
                }
                log.info((Object)"Event detector ends.");
            }
        }
    }

    public void endCurrentEventListener() {
        if (this.getEventSource() != null && this.getEventSource().getDevice().isOnline()) {
            this.getEventSource().getDeviceShell().kill("getevent");
        }
        this.getEventAnalyzer().setStop(true);
        this.getEventDispatcher().setStop(true);
    }

    public DeviceInfo getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(DeviceInfo eventSource) {
        this.eventSource = eventSource;
    }

    public ArrayList<DeviceInfo> getConsumers() {
        return this.consumers;
    }

    public void setConsumers(ArrayList<DeviceInfo> consumers) {
        this.consumers = consumers;
    }

    public boolean isAllowDispatchEvent() {
        return this.allowDispatchEvent;
    }

    public void setAllowDispatchEvent(boolean allowDispatchEvent) {
        this.allowDispatchEvent = allowDispatchEvent;
        if (this.getEventOutputReceiver != null) {
            this.getEventOutputReceiver.setAllowListening(allowDispatchEvent);
        }
    }

    public EventAnalyzer getEventAnalyzer() {
        return this.eventAnalyzer;
    }

    public void setEventAnalyzer(EventAnalyzer eventAnalyzer) {
        this.eventAnalyzer = eventAnalyzer;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }
}

