/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device.event;

import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.event.Action;
import com.testin.itestin.device.event.EventAnalyzer;
import com.testin.itestin.shell.MultiLineReceiver;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EventOutputReceiver
extends MultiLineReceiver {
    static Logger log = Logger.getLogger(EventOutputReceiver.class);
    private int sdkVer = 15;
    private boolean isCancel = false;
    private StringBuffer output = new StringBuffer();
    public int x = 0;
    public int y = 0;
    private boolean xChange = false;
    private boolean yChange = false;
    public int pressure = 0;
    public static boolean hasTrackingId = false;
    public static boolean findTrackingIdEnd = false;
    private boolean allowListening = true;
    private int trackId = 0;

    public EventOutputReceiver(int sdkVer) {
        this.setSdkVer(sdkVer);
    }

    @Override
    public void processNewLines(String[] arg0) {
        if (!this.isAllowListening()) {
            return;
        }
        String[] stringArray = arg0;
        int n = arg0.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (StringUtils.isNotEmpty((String)line)) {
                if (this.getSdkVer() < 15) {
                    this.analyzeAction_2_x_x(line);
                } else {
                    this.analyzeAction_4_x_x(line);
                }
            }
            ++n2;
        }
    }

    private void analyzeAction_2_x_x(String line) {
        Action action;
        if (line.contains(" 0003 0035 ") || line.contains(" 0003 0000 ")) {
            this.x = this.extractValue(line);
            this.xChange = true;
        }
        if (line.contains(" 0003 0036 ") || line.contains(" 0003 0001 ")) {
            this.y = this.extractValue(line);
            this.yChange = true;
        }
        if (line.contains(" 0003 0030 ") || line.contains(" 0003 0018 ")) {
            this.pressure = this.extractValue(line);
        }
        if (line.contains("0000 000") && this.x * this.y > 0 && this.xChange && this.yChange) {
            action = new Action(this.x, this.y);
            if (this.pressure > 0) {
                action.setPressure(this.pressure);
            }
            this.addAction(action);
            this.xChange = false;
            this.yChange = false;
            this.pressure = 0;
            this.x = 0;
            this.y = 0;
        }
        if (line.contains(" 0001 014a ")) {
            if (line.contains("00000000")) {
                action = new Action(0, 0, false, true);
                this.addAction(action);
            } else if (line.contains("00000001")) {
                action = new Action(0, 0, true, false);
                this.addAction(action);
            }
        }
        if (line.contains(" 0001 009e ")) {
            if (line.contains("00000000")) {
                action = new Action(IDeviceShell.KeyCode.BACK, false, true);
                this.addAction(action);
            } else if (line.contains("00000001")) {
                action = new Action(IDeviceShell.KeyCode.BACK, true, false);
                this.addAction(action);
            }
        }
        if (line.contains(" 0001 008b ")) {
            if (line.contains("00000000")) {
                action = new Action(IDeviceShell.KeyCode.MENU, false, true);
                this.addAction(action);
            } else if (line.contains("00000001")) {
                action = new Action(IDeviceShell.KeyCode.MENU, true, false);
                this.addAction(action);
            }
        }
        if (line.contains(" 0001 0066 ")) {
            if (line.contains("00000000")) {
                action = new Action(IDeviceShell.KeyCode.HOME, false, true);
                this.addAction(action);
            } else if (line.contains("00000001")) {
                action = new Action(IDeviceShell.KeyCode.HOME, true, false);
                this.addAction(action);
            }
        }
    }

    private void addAction(Action action) {
        if (action != null) {
            log.info((Object)action);
            EventAnalyzer.actionQueue.add(action);
        }
    }

    private void analyzeAction_4_x_x(String line) {
        Action action;
        if (line.contains("ABS_MT_POSITION_X")) {
            this.x = this.extractValue(line);
            this.xChange = true;
        }
        if (line.contains("ABS_MT_POSITION_Y")) {
            this.y = this.extractValue(line);
            this.yChange = true;
        }
        if (line.contains("ABS_MT_PRESSURE") || line.contains("ABS_PRESSURE")) {
            this.pressure = this.extractValue(line);
        }
        if (line.contains("ABS_MT_TRACKING_ID") && !line.contains("00000000")) {
            if (!line.contains("ffffffff")) {
                this.trackId = this.extractValue(line);
                hasTrackingId = true;
            } else if (line.contains("ffffffff") || this.trackId > 0 && this.extractValue(line) == this.trackId) {
                findTrackingIdEnd = true;
                this.trackId = 0;
            }
        }
        if ((line.contains("SYN_REPORT") || line.contains("SYN_MT_REPORT")) && this.x * this.y > 0 && this.xChange && this.yChange) {
            action = new Action(this.x, this.y);
            if (this.pressure > 0) {
                action.setPressure(this.pressure);
            }
            this.addAction(action);
            this.xChange = false;
            this.yChange = false;
            this.pressure = 0;
            this.x = 0;
            this.y = 0;
        }
        if (line.contains("BTN_TOUCH")) {
            if (line.contains("UP")) {
                action = new Action(0, 0, false, true);
                this.addAction(action);
            } else if (line.contains("DOWN")) {
                action = new Action(0, 0, true, false);
                this.addAction(action);
            }
        }
        if (line.contains("KEY_BACK") && line.contains("UP")) {
            action = new Action(IDeviceShell.KeyCode.BACK, false, true);
            this.addAction(action);
        }
        if (line.contains("KEY_MENU") && line.contains("UP")) {
            action = new Action(IDeviceShell.KeyCode.MENU, false, true);
            this.addAction(action);
        }
        if (line.contains("KEY_HOME") && line.contains("UP")) {
            action = new Action(IDeviceShell.KeyCode.HOME, false, true);
            this.addAction(action);
        }
    }

    private int extractValue(String log) {
        if (StringUtils.isEmpty((String)log)) {
            return -1;
        }
        try {
            return Integer.valueOf(log.substring(log.lastIndexOf(" ") + 1, log.length()), 16);
        }
        catch (Exception e) {
            EventOutputReceiver.log.error((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public String getOutput() {
        return this.output.toString();
    }

    public void cancel() {
        this.isCancel = true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancel;
    }

    public int getSdkVer() {
        return this.sdkVer;
    }

    public void setSdkVer(int sdkVer) {
        this.sdkVer = sdkVer;
    }

    public boolean isAllowListening() {
        return this.allowListening;
    }

    public void setAllowListening(boolean allowListening) {
        this.allowListening = allowListening;
    }
}

