/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device.event;

import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.event.Block;
import com.testin.itestin.device.event.Pointer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class VirtualKeys {
    static Logger log = Logger.getLogger(VirtualKeys.class);
    public static final String BACK_KEY = "BACK";
    public static final String HOME_KEY = "HOME";
    public static final String SEARCH_KEY = "SEARCH";
    public static final String MENU_KEY = "MENU";
    public static final String BACK_SCAN_CODE = "158";
    public static final String HOME_SCAN_CODE_1 = "172";
    public static final String HOME_SCAN_CODE_2 = "102";
    public static final String SEARCH_SCAN_CODE = "217";
    public static final String MENU_SCAN_CODE = "139";
    private String myKeyMapStr = "";
    private Block back = null;
    private Block home = null;
    private Block search = null;
    private Block menu = null;

    public VirtualKeys(String virtualKeyMap) {
        this.setMyKeyMapStr(virtualKeyMap);
        if (StringUtils.isEmpty((String)virtualKeyMap) || !virtualKeyMap.contains("0x01:")) {
            return;
        }
        String[] blocks = virtualKeyMap.split("0x01:");
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i].startsWith(BACK_SCAN_CODE)) {
                this.setBackBlock(this.parseBlock(blocks[i]));
            }
            if (blocks[i].startsWith(HOME_SCAN_CODE_1) || blocks[i].startsWith(HOME_SCAN_CODE_2)) {
                this.setHomeBlock(this.parseBlock(blocks[i]));
            }
            if (blocks[i].startsWith(MENU_SCAN_CODE)) {
                this.setMenuBlock(this.parseBlock(blocks[i]));
            }
            if (blocks[i].startsWith(SEARCH_SCAN_CODE)) {
                this.setSearchBlock(this.parseBlock(blocks[i]));
            }
            ++i;
        }
    }

    public String getPointerName(Pointer point) {
        if (this.isBackKey(point)) {
            return BACK_KEY;
        }
        if (this.isHomeKey(point)) {
            return HOME_KEY;
        }
        if (this.isMenuKey(point)) {
            return MENU_KEY;
        }
        if (this.isSearchKey(point)) {
            return SEARCH_KEY;
        }
        return "";
    }

    public IDeviceShell.KeyCode getPointerKeyCode(Pointer point) {
        if (this.isBackKey(point)) {
            return IDeviceShell.KeyCode.BACK;
        }
        if (this.isHomeKey(point)) {
            return IDeviceShell.KeyCode.HOME;
        }
        if (this.isMenuKey(point)) {
            return IDeviceShell.KeyCode.MENU;
        }
        if (this.isSearchKey(point)) {
            return IDeviceShell.KeyCode.SEARCH;
        }
        return null;
    }

    public boolean isBackKey(Pointer point) {
        if (this.getBackBlock() == null) {
            return false;
        }
        return this.getBackBlock().contains(point);
    }

    public boolean isHomeKey(Pointer point) {
        if (this.getHomeBlock() == null) {
            return false;
        }
        return this.getHomeBlock().contains(point);
    }

    public boolean isMenuKey(Pointer point) {
        if (this.getMenuBlock() == null) {
            return false;
        }
        return this.getMenuBlock().contains(point);
    }

    public boolean isSearchKey(Pointer point) {
        if (this.getSearchBlock() == null) {
            return false;
        }
        return this.getSearchBlock().contains(point);
    }

    private Block parseBlock(String keyinfo) {
        if (StringUtils.isEmpty((String)keyinfo) || !keyinfo.contains(":")) {
            return null;
        }
        String[] segs = keyinfo.split(":");
        if (segs.length < 5) {
            return null;
        }
        try {
            Pointer startPoint = new Pointer(Integer.parseInt(segs[1].trim()), Integer.parseInt(segs[2].trim()));
            int width = Integer.parseInt(segs[3].trim());
            int height = Integer.parseInt(segs[4].trim());
            return new Block(startPoint, width, height);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String mapFunctionalKey(Pointer point) {
        return null;
    }

    public Block getBackBlock() {
        return this.back;
    }

    public void setBackBlock(Block back_start) {
        this.back = back_start;
    }

    public Block getHomeBlock() {
        return this.home;
    }

    public void setHomeBlock(Block home_start) {
        this.home = home_start;
    }

    public Block getSearchBlock() {
        return this.search;
    }

    public void setSearchBlock(Block search_start) {
        this.search = search_start;
    }

    public Block getMenuBlock() {
        return this.menu;
    }

    public void setMenuBlock(Block menu_start) {
        this.menu = menu_start;
    }

    public String getMyKeyMapStr() {
        return this.myKeyMapStr;
    }

    public void setMyKeyMapStr(String myKeyMapStr) {
        this.myKeyMapStr = myKeyMapStr;
    }

    public String toString() {
        return String.format("KeyMapStr: %s\nBACK: %s\nHOME: %s\nMENU: %s\nSEARCH: %s\n", this.getMyKeyMapStr(), this.getBackBlock(), this.getHomeBlock(), this.getMenuBlock(), this.getSearchBlock());
    }
}

