/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device.logcat;

import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.logcat.Logcat;
import com.testin.itestin.device.logcat.LogcatOutputReceiver;
import com.testin.itestin.os.Message;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.Utils;

public class MainLogcat
implements Logcat {
    public static final String restartMsg = "logcat read: Invalid argument";
    public static final int maxTimeToOutputResponse = 3600000;
    private IDeviceShell.ILogcatListener logListener;
    private boolean isCancelled;
    private String command;
    private IDeviceShell deviceShell;
    final Thread logcatProcess = new Thread("LogcatProcess"){

        @Override
        public void run() {
            Message msg = MainLogcat.this.deviceShell.executeShellCommand(MainLogcat.this.command, new LogcatOutputReceiver(MainLogcat.this), 3600000);
            switch (msg.getStatus()) {
                case 0: {
                    MainLogcat.this.logListener.onMainLogExit(0);
                    break;
                }
                default: {
                    MainLogcat.this.logListener.onMainLogExit(1);
                }
            }
            MainLogcat.this.isCancelled = true;
            Utils.gc();
        }
    };

    public MainLogcat(IDeviceShell deviceShell) {
        this.deviceShell = deviceShell;
        deviceShell.getSerialNumber();
    }

    @Override
    public Message clearLog() {
        int timeout = 10000;
        String command = "logcat -c";
        return this.deviceShell.executeShellCommand(command, timeout);
    }

    @Override
    public void startLog(IDeviceShell.LogcatLevel level, String filter, IDeviceShell.ILogcatListener listener) {
        String cmd;
        this.logListener = listener;
        this.isCancelled = false;
        String logcatFilter = this.getLogcatFilter(level, filter);
        this.command = cmd = "logcat -v time " + logcatFilter;
        ThreadPool.execute(this.logcatProcess);
    }

    private String getLogcatFilter(IDeviceShell.LogcatLevel level, String filter) {
        String[] filterArray;
        String lv = "E";
        switch (level) {
            case ALL: {
                lv = "V";
                break;
            }
            case ERROR: {
                lv = "E";
                break;
            }
            case WARN: {
                lv = "W";
                break;
            }
            case INFO: {
                lv = "I";
                break;
            }
            case DEBUG: {
                lv = "D";
                break;
            }
            case VERBOSE: {
                lv = "V";
                break;
            }
            default: {
                lv = "D";
            }
        }
        String androidFilter = "";
        String[] stringArray = filterArray = filter.trim().split(" ");
        int n = filterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if ((f = f.trim()).length() > 0) {
                androidFilter = String.valueOf(androidFilter) + " " + f;
                if (!lv.equals("")) {
                    androidFilter = String.valueOf(androidFilter) + ":" + lv;
                }
            }
            ++n2;
        }
        if (!androidFilter.equals("")) {
            androidFilter = String.valueOf(androidFilter) + " *:S";
        } else if (!lv.equals("")) {
            androidFilter = "*:" + lv;
        }
        return androidFilter;
    }

    @Override
    public void log(String log) {
        if (this.logListener != null) {
            this.logListener.mainLog(log);
        }
    }

    @Override
    public void stopLog() {
        this.isCancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }
}

