/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device.tools;

import com.testin.itestin.device.AaptForm;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.entitys.TestApkInfo;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.shell.ShellCommandUnresponsiveException;
import com.testin.itestin.shell.ShellExecutor;
import com.testin.itestin.util.MD5;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ApkParser {
    static Logger log = Logger.getLogger(ApkParser.class);
    String packagePackageNameRegex = "package:.+?name='([^']+?)'";
    String packageStartPathRegex = "launchable.activity.+?name='([^']+?)'";
    String packageVersionCodeRegex = "versionCode='([^']+?)'";
    String packageVersionNameRegex = "versionName='([^']+?)'";
    String packageMinSdkVersionRegex = "minSdkVersion:'([^']+?)'";
    String packageLabelRegex = "label='([^']+?)'";
    String packageLabelZhRegex = "label-zh:'([^']+?)'";
    String packageLabelEnRegex = "label-en:'([^']+?)'";
    String packageIconRegex = "icon='([^']+?)'";
    String testPackagePackageNameRegex = "package=\"([^\"]+?)\"";
    String testPackageStartPathRegex = "instrumentation[\\s\\S]+?android:name.+?=\"([^\"]+?)\"";
    String testPackageTargetPackageRegex = "android:targetPackage.+?=\"([^\"]+?)\"";
    String testPackageMinSdkVersionRegex = "android:minSdkVersion.+?=.+?type.+?x.+?x([0-9a-fA-F]+)";
    Pattern packagePackageNamePattern = Pattern.compile(this.packagePackageNameRegex, 8);
    Pattern packageStartPathPattern = Pattern.compile(this.packageStartPathRegex, 8);
    Pattern packageVersionCodePattern = Pattern.compile(this.packageVersionCodeRegex, 8);
    Pattern packageVersionNamePattern = Pattern.compile(this.packageVersionNameRegex, 8);
    Pattern packageMinSdkVersionPattern = Pattern.compile(this.packageMinSdkVersionRegex, 8);
    Pattern packageLabelPattern = Pattern.compile(this.packageLabelRegex, 8);
    Pattern packageLabelZhPattern = Pattern.compile(this.packageLabelZhRegex, 8);
    Pattern packageLabelEnPattern = Pattern.compile(this.packageLabelEnRegex, 8);
    Pattern packageIconPattern = Pattern.compile(this.packageIconRegex, 8);
    Pattern testPackagePackageNamePattern = Pattern.compile(this.testPackagePackageNameRegex, 8);
    Pattern testPackageStartPathPattern = Pattern.compile(this.testPackageStartPathRegex, 8);
    Pattern testPackageTargetPackagePattern = Pattern.compile(this.testPackageTargetPackageRegex, 8);
    Pattern testPackageMinSdkVersionPattern = Pattern.compile(this.testPackageMinSdkVersionRegex, 8);
    private static Object paseLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestApkInfo parseTestApp(String localPath) {
        Object object = paseLock;
        synchronized (object) {
            String command = AaptForm.formAaptXmltree(localPath);
            TestApkInfo testApkInfo = new TestApkInfo();
            Message msg = new Message(){};
            msg.setStatus(0);
            int timeout = 60000;
            try {
                testApkInfo.setFilePath(localPath);
                String res = ShellExecutor.executeCommand(DirectoryService.getToolsDir(), command, timeout);
                if (StringUtils.isNotEmpty((String)res)) {
                    Matcher matcher = this.testPackagePackageNamePattern.matcher(res);
                    if (matcher.find()) {
                        testApkInfo.setPackageName(matcher.group(1));
                    }
                    if ((matcher = this.testPackageStartPathPattern.matcher(res)).find()) {
                        testApkInfo.setStartPath(matcher.group(1));
                    }
                    if ((matcher = this.testPackageTargetPackagePattern.matcher(res)).find()) {
                        testApkInfo.setTargetPackage(matcher.group(1));
                    }
                    if ((matcher = this.testPackageMinSdkVersionPattern.matcher(res)).find()) {
                        testApkInfo.setMinSdkVersion(Integer.parseInt(matcher.group(1), 16));
                    }
                } else {
                    msg.setStatus(1);
                    msg.setContent("ShellExecutor executeCommand return Empty");
                }
            }
            catch (ShellCommandUnresponsiveException e) {
                msg.setStatus(10);
                msg.setContent("Exception:" + e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                msg.setStatus(20);
                msg.setContent("Exception:" + e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            testApkInfo.setMsg(msg);
            return testApkInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationInfo parse(String localPath) {
        Object object = paseLock;
        synchronized (object) {
            Message msg;
            ApplicationInfo appInfo;
            block19: {
                String command = AaptForm.formAaptBadging(localPath);
                appInfo = new ApplicationInfo();
                msg = new Message();
                msg.setStatus(0);
                int timeout = 60000;
                try {
                    appInfo.setFilePath(localPath);
                    File f = new File(localPath);
                    String md5 = MD5.md5(f);
                    appInfo.setAppSize(f.length());
                    appInfo.setMd5(md5);
                    String res = ShellExecutor.executeCommand(DirectoryService.getToolsDir(), command, timeout);
                    if (StringUtils.isNotEmpty((String)res)) {
                        Matcher matcher = this.packagePackageNamePattern.matcher(res);
                        if (matcher.find()) {
                            appInfo.setPackageName(matcher.group(1));
                        }
                        if ((matcher = this.packageStartPathPattern.matcher(res)).find()) {
                            String launchableActivity = matcher.group(1);
                            launchableActivity = String.format("%s/%s", appInfo.getPackageName(), launchableActivity);
                            appInfo.setStartPath(launchableActivity);
                        }
                        if ((matcher = this.packageVersionCodePattern.matcher(res)).find()) {
                            appInfo.setVersionCode(matcher.group(1));
                        }
                        if ((matcher = this.packageVersionNamePattern.matcher(res)).find()) {
                            appInfo.setVersionName(matcher.group(1));
                        }
                        if ((matcher = this.packageMinSdkVersionPattern.matcher(res)).find()) {
                            try {
                                appInfo.setMinSdkVersion(Integer.parseInt(matcher.group(1)));
                            }
                            catch (Exception ex) {
                                log.error((Object)ex.getMessage(), (Throwable)ex);
                            }
                        }
                        if ((matcher = this.packageLabelPattern.matcher(res)).find()) {
                            appInfo.setAppName(matcher.group(1));
                        }
                        if (StringUtils.isEmpty((String)appInfo.getAppName()) && (matcher = this.packageLabelZhPattern.matcher(res)).find()) {
                            appInfo.setAppName(matcher.group(1));
                        }
                        if (StringUtils.isEmpty((String)appInfo.getAppName()) && (matcher = this.packageLabelEnPattern.matcher(res)).find()) {
                            appInfo.setAppName(matcher.group(1));
                        }
                        if ((matcher = this.packageIconPattern.matcher(res)).find()) {
                            appInfo.setIcon(matcher.group(1));
                        }
                        break block19;
                    }
                    msg.setStatus(1);
                    msg.setContent("ShellExecutor executeCommand return Empty");
                }
                catch (ShellCommandUnresponsiveException e) {
                    msg.setStatus(10);
                    log.error((Object)e.getMessage(), (Throwable)e);
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    msg.setContent(stringWriter.getBuffer().toString());
                }
                catch (IOException e) {
                    msg.setStatus(20);
                    log.error((Object)e.getMessage(), (Throwable)e);
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    msg.setContent(stringWriter.getBuffer().toString());
                }
                catch (Exception e) {
                    msg.setStatus(20);
                    log.error((Object)e.getMessage(), (Throwable)e);
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    msg.setContent(stringWriter.getBuffer().toString());
                }
            }
            appInfo.setMsg(msg);
            return appInfo;
        }
    }

    private byte[] read(ZipFile zip, ZipEntry entry) {
        byte[] buff;
        block12: {
            buff = null;
            InputStream input = null;
            try {
                try {
                    input = zip.getInputStream(entry);
                    buff = new byte[input.available()];
                    input.read(buff);
                    input.close();
                    input = null;
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    if (input == null) break block12;
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    input = null;
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    input = null;
                }
            }
        }
        return buff;
    }
}

