/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.device.tools;

import com.testin.itestin.business.KeyStore;
import com.testin.itestin.device.AaptForm;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.shell.ShellCommandUnresponsiveException;
import com.testin.itestin.shell.ShellExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.log4j.Logger;

public class ApkTool {
    static Logger log = Logger.getLogger(ApkTool.class);
    private static String Android_Jar = String.valueOf(DirectoryService.getToolsDir()) + File.separator + "android.jar";
    private static String TestinRecord_Dex = String.valueOf(DirectoryService.getRecordDir()) + File.separator + "classes.dex";
    private static final Object resignApkLock = new Object();
    public static KeyStore TestinKeyStore = new KeyStore();

    static {
        TestinKeyStore.setKeystore(String.valueOf(DirectoryService.getToolsDir()) + File.separator + "itestin.keystore");
        TestinKeyStore.setStorepass("itestin");
        TestinKeyStore.setKeypass("itestin");
        TestinKeyStore.setAlias("itestin");
    }

    private String tempapkfn(String name) {
        String regex = "(.*?)(\\.\\w{1,4})$";
        String fn = name.replaceAll(regex, "$1_temp.apk");
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message resignApk(String src, String dest, KeyStore keyStore) throws Exception {
        Object object = resignApkLock;
        synchronized (object) {
            String tempfn;
            File tempApkF;
            Message msg = new Message();
            msg.setStatus(20);
            msg.setContent("resign apk not success");
            File srcF = new File(src);
            File destF = new File(dest);
            if (destF.exists()) {
                msg.setStatus(0);
                msg.setContent("");
                return msg;
            }
            String tempdir = String.valueOf(DirectoryService.getTempDir()) + File.separator + "tmp";
            File tempRootF = new File(tempdir);
            if (!tempRootF.exists()) {
                tempRootF.mkdirs();
            }
            if (this.copyAndDelMetaInf(srcF, tempApkF = new File(tempfn = String.valueOf(tempdir) + File.separator + this.tempapkfn(destF.getName())))) {
                if (this.signApk(dest, tempfn, keyStore)) {
                    try {
                        FileUtils.deleteDirectory((File)tempRootF);
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    msg.setStatus(0);
                    msg.setContent("");
                } else {
                    destF.delete();
                    tempApkF.delete();
                }
            }
            return msg;
        }
    }

    public Message resignTestinRecordApk(String pkgName, String dest, KeyStore keyStore) throws Exception {
        return this.resignTesterApk(pkgName, dest, 0, null, keyStore);
    }

    public Message resignTestinReplayApk(String pkgName, String dest, String jsString, KeyStore keyStore) throws Exception {
        return this.resignTesterApk(pkgName, dest, 1, jsString, keyStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message resignTesterApk(String pkgName, String dest, int flag, String jsString, KeyStore keyStore) throws Exception {
        Object object = resignApkLock;
        synchronized (object) {
            Message msg = new Message();
            msg.setStatus(20);
            msg.setContent("resign tester apk not success");
            File destF = new File(dest);
            if (destF.exists()) {
                msg.setStatus(0);
                msg.setContent("");
                return msg;
            }
            String tempdir = String.valueOf(DirectoryService.getTempDir()) + File.separator + pkgName;
            File tempRootF = new File(tempdir);
            if (!tempRootF.exists()) {
                tempRootF.mkdirs();
            }
            String tempfn = String.valueOf(tempdir) + File.separator + this.tempapkfn(destF.getName());
            File tempApkF = new File(tempfn);
            String manifest = String.valueOf(tempdir) + File.separator + "AndroidManifest.xml";
            File androidManifestF = new File(manifest);
            try {
                String androidManifestStr = "";
                if (flag == 0) {
                    androidManifestStr = this.getITesterAndroidManifest(pkgName);
                } else if (flag == 1) {
                    androidManifestStr = this.getITesterAndroidManifest(pkgName);
                }
                if (androidManifestF.exists()) {
                    androidManifestF.delete();
                }
                FileUtils.write((File)androidManifestF, (CharSequence)androidManifestStr, (String)"utf-8");
            }
            catch (IOException e) {
                msg.setStatus(20);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                msg.setContent(stringWriter.getBuffer().toString());
                return msg;
            }
            boolean b = false;
            if (flag == 0) {
                b = this.createApk(TestinRecord_Dex, manifest, tempfn);
            } else if (flag == 1) {
                try {
                    File dex = new File(TestinRecord_Dex);
                    File dexdir = dex.getParentFile();
                    String jsdir = String.valueOf(dexdir.getAbsolutePath()) + File.separator + "script" + File.separator;
                    String fn = "record.js";
                    String path = String.valueOf(jsdir) + fn;
                    if (jsString != null) {
                        File jsFile;
                        File dir = new File(jsdir);
                        if (!dir.exists()) {
                            dir.mkdir();
                        }
                        if ((jsFile = new File(path)).exists()) {
                            jsFile.delete();
                        }
                        FileUtils.write((File)jsFile, (CharSequence)jsString, (String)"utf-8");
                    } else {
                        File jsFile = new File(path);
                        if (jsFile.exists()) {
                            jsFile.delete();
                        }
                    }
                    b = this.createApk(TestinRecord_Dex, manifest, tempfn);
                }
                catch (IOException e) {
                    msg.setStatus(20);
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    msg.setContent(stringWriter.getBuffer().toString());
                    return msg;
                }
            }
            if (b) {
                if (this.signApk(dest, tempfn, keyStore)) {
                    tempApkF.delete();
                    androidManifestF.delete();
                    msg.setStatus(0);
                    msg.setContent("");
                } else {
                    destF.delete();
                    tempApkF.delete();
                    androidManifestF.delete();
                }
            }
            return msg;
        }
    }

    private boolean signApk(String signPath, String unSignPath, KeyStore keyStore) throws Exception {
        String toolsjar = String.valueOf(DirectoryService.getToolsDir()) + File.separator + "tools.jar";
        String command = String.format("java -classpath \"%s\" sun.security.tools.JarSigner -digestalg SHA1 -sigalg MD5withRSA -keystore \"%s\" -storepass \"%s\" -keypass \"%s\" -signedjar \"%s\" \"%s\" \"%s\"", toolsjar, keyStore.getKeystore(), keyStore.getStorepass(), keyStore.getKeypass(), signPath, unSignPath, keyStore.getAlias());
        int timeout = 120000;
        boolean isSuccessful = true;
        try {
            ShellExecutor.executeCommand(DirectoryService.getToolsDir(), command, timeout);
            File signApkF = new File(signPath);
            if (!signApkF.exists()) {
                isSuccessful = false;
            }
        }
        catch (ShellCommandUnresponsiveException e) {
            isSuccessful = false;
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        catch (IOException e) {
            isSuccessful = false;
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return isSuccessful;
    }

    private boolean createApk(String dexPath, String xmlDirectory, String apkName) {
        boolean isSuccessful = true;
        String command = AaptForm.formAaptPzuxmif(xmlDirectory, Android_Jar, apkName);
        int timeout = 60000;
        try {
            File dex = new File(dexPath);
            File dexdir = dex.getParentFile();
            ShellExecutor.executeCommand(dexdir.getAbsolutePath(), command, timeout);
            command = AaptForm.formAaptA(apkName, "classes.dex");
            ShellExecutor.executeCommand(dexdir.getAbsolutePath(), command, timeout);
            Collection files = FileUtils.listFiles((File)dexdir, (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
            for (File f : files) {
                if (f.getName().equals("classes.dex") || f.getName().equals("AndroidManifest.xml")) continue;
                String res = f.getAbsolutePath().replace(dexdir.getAbsolutePath(), "");
                res = res.replace("\\", "/");
                res = res.substring(1, res.length());
                command = AaptForm.formAaptA(apkName, res);
                ShellExecutor.executeCommand(dexdir.getAbsolutePath(), command, timeout);
            }
            File ApkF = new File(apkName);
            if (!ApkF.exists()) {
                isSuccessful = false;
            }
        }
        catch (ShellCommandUnresponsiveException e) {
            isSuccessful = false;
        }
        catch (IOException e) {
            isSuccessful = false;
        }
        return isSuccessful;
    }

    private boolean copyAndDelMetaInf(File srcFile, File destFile) {
        ZipInputStream zin = null;
        ZipOutputStream zout = null;
        try {
            byte[] buf = new byte[1024];
            zin = new ZipInputStream(new FileInputStream(srcFile));
            zout = new ZipOutputStream(new FileOutputStream(destFile));
            ZipEntry entry = null;
            while ((entry = zin.getNextEntry()) != null) {
                int len;
                String name = entry.getName();
                boolean toBeDeleted = false;
                if (name.startsWith("META-INF")) {
                    toBeDeleted = true;
                }
                if (toBeDeleted) continue;
                ZipEntry tmp = new ZipEntry(name);
                if (entry.getCrc() != -1L && entry.getSize() != -1L && entry.getSize() == entry.getCompressedSize()) {
                    tmp.setMethod(0);
                    tmp.setCompressedSize(entry.getSize());
                    tmp.setSize(entry.getSize());
                    tmp.setCrc(entry.getCrc());
                }
                zout.putNextEntry(tmp);
                while ((len = zin.read(buf)) > 0) {
                    zout.write(buf, 0, len);
                }
            }
            zin.close();
            zin = null;
            zout.close();
            zout = null;
            return true;
        }
        catch (Exception e) {
            log.error((Object)"DelMetaInf:error", (Throwable)e);
        }
        finally {
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (zout != null) {
                try {
                    zout.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    private String getITesterAndroidManifest(String targetPackage) {
        StringBuffer info = new StringBuffer();
        info.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        info.append("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\" package=\"com.testin.itestin.tester\" android:versionCode=\"1\" android:versionName=\"1.0\">");
        info.append("<uses-sdk android:minSdkVersion=\"7\" />");
        info.append("<instrumentation android:name=\"com.testin.itestin.TestRunner\" android:targetPackage=\"" + targetPackage + "\" />");
        info.append("<application android:label=\"iTestinTester\">");
        info.append("<uses-library android:name=\"android.test.runner\" />");
        info.append("</application>");
        info.append("</manifest>");
        String xmlInfo = info.toString();
        return xmlInfo;
    }
}

