/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.entitys;

import com.testin.itestin.entitys.ViewNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ViewNodeRanker {
    private static ArrayList<String> viewNames = new ArrayList();

    static {
        viewNames.add("android.widget.TextView");
        viewNames.add("android.widget.EditText");
        viewNames.add("android.widget.Button");
        viewNames.add("android.widget.CheckBox");
        viewNames.add("android.widget.RadioButton");
        viewNames.add("android.widget.ToggleButton");
        viewNames.add("android.widget.ImageButton");
        viewNames.add("android.widget.ProgressBar");
        viewNames.add("android.widget.ImageView");
        viewNames.add("android.widget.DatePicker");
        viewNames.add("android.widget.TimePicker");
        viewNames.add("android.widget.Spinner");
        viewNames.add("android.widget.ListView");
        viewNames.add("android.widget.GridView");
        viewNames.add("android.widget.ScrollView");
        viewNames.add("android.widget.SlidingDrawer");
        viewNames.add("android.view.View");
        viewNames.add("android.view.ViewGroup");
    }

    public static int getViewRanking(ViewNode viewNode) {
        int order = viewNames.indexOf(viewNode.className);
        String index = null;
        String ranking = null;
        index = viewNode.className.equals("android.widget.ImageView") || viewNode.className.equals("android.widget.TextView") ? String.valueOf(viewNode.areaOrder) : String.valueOf(viewNode.index);
        index = String.format("%3d", Integer.valueOf(index));
        index = index.replace(" ", "0");
        ranking = String.valueOf(order) + index;
        return Integer.valueOf(ranking);
    }

    public static void setAreaOrder(ArrayList<ViewNode> viewNodes) {
        Collections.sort(viewNodes, new Comparator(){

            public int compare(Object obj0, Object obj1) {
                int anotherRanking;
                ViewNode viewNode0 = (ViewNode)obj0;
                ViewNode viewNode1 = (ViewNode)obj1;
                int viewRanking = viewNode0.getRectangleArea();
                if (viewRanking > (anotherRanking = viewNode1.getRectangleArea())) {
                    return 1;
                }
                if (viewRanking < anotherRanking) {
                    return -1;
                }
                return 0;
            }
        });
        int i = 0;
        while (i < viewNodes.size()) {
            viewNodes.get((int)i).areaOrder = i;
            ++i;
        }
    }

    public static void setClassNameOrder(ArrayList<ViewNode> viewNodes) {
        Collections.sort(viewNodes, new Comparator(){

            public int compare(Object obj0, Object obj1) {
                int anotherRanking;
                ViewNode viewNode0 = (ViewNode)obj0;
                ViewNode viewNode1 = (ViewNode)obj1;
                int viewRanking = ViewNodeRanker.getViewRanking(viewNode0);
                if (viewRanking > (anotherRanking = ViewNodeRanker.getViewRanking(viewNode1))) {
                    return 1;
                }
                if (viewRanking < anotherRanking) {
                    return -1;
                }
                return 0;
            }
        });
    }
}

