/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.os;

import com.testin.itestin.os.Handler;
import com.testin.itestin.os.Message;
import com.testin.itestin.os.MessageQueue;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.Utils;
import javafx.application.Platform;
import org.apache.log4j.Logger;

public class HandlerThread
extends Thread {
    static Logger log = Logger.getLogger(HandlerThread.class);
    private static boolean quit;
    private static MessageQueue messageQueue;
    private static HandlerThread handlerThread;

    static {
        messageQueue = new MessageQueue();
        handlerThread = new HandlerThread();
    }

    private HandlerThread() {
        this.setName("HandlerThread");
    }

    public static void loop() {
        ThreadPool.execute(handlerThread);
    }

    @Override
    public void run() {
        while (!quit) {
            Message msg = null;
            try {
                msg = messageQueue.get();
                if (msg != null) {
                    this.notifyHandler(msg.getTarget(), msg);
                    continue;
                }
                Utils.sleep(100L);
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void notifyHandler(final Handler handler, final Message msg) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                handler.handleMessage(msg);
            }
        });
    }

    public static void quit() {
        quit = true;
        messageQueue.clear();
    }
}

