/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.service;

import com.testin.itestin.api.bean.DispatchInfoReq;
import com.testin.itestin.api.bean.DispatchInfoRes;
import com.testin.itestin.common.Constants;
import com.testin.itestin.entitys.UserInfo;
import com.testin.itestin.service.LoginService;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.Utils;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class DispatchListService {
    static Logger log = Logger.getLogger(DispatchListService.class);
    private static DispatchListService dispatchListService = new DispatchListService();
    private boolean cancel = false;
    Thread threadDispatchList = new Thread("DispatchList"){

        @Override
        public void run() {
            while (!DispatchListService.this.cancel) {
                Utils.sleep(2000L);
                UserInfo userInfo = LoginService.getInstance().getDefaultUser();
                if (userInfo == null) continue;
                String email = userInfo.getEmail();
                String pwd = userInfo.getPassword();
                if (email.equals(Constants.TEST_USER_NAME) && pwd.equals(Constants.TEST_USER_PASSWORD) || userInfo == null || userInfo.getState() != 1) continue;
                try {
                    boolean flag = DispatchListService.this.dispatchList();
                    if (!flag) continue;
                    Utils.sleep(600000L);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    };

    public static DispatchListService getInstance() {
        return dispatchListService;
    }

    public void start() {
        ThreadPool.execute(this.threadDispatchList);
    }

    public void stop() {
        this.cancel = true;
    }

    private boolean dispatchList() {
        boolean b1 = true;
        boolean b2 = false;
        try {
            DispatchInfoReq dispatchInfoReq = new DispatchInfoReq();
            DispatchInfoRes res = this.dispatchList(dispatchInfoReq);
            if (res != null && res.getCode() == 0 && res.getData() != null) {
                DispatchInfoRes.FsesData[] fses;
                DispatchInfoRes.DispatchesData[] dis = res.getData().getDispatches();
                if (dis != null && dis.length > 0) {
                    Constants.setDispatchesData_dis(Arrays.asList(dis));
                    b1 = true;
                }
                if ((fses = res.getData().getFses()) != null && fses.length > 0) {
                    Constants.setFsesData_dis(Arrays.asList(fses));
                    b2 = true;
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return b1 && b2;
    }

    private DispatchInfoRes dispatchList(DispatchInfoReq dispatchInfoReq) {
        try {
            DispatchInfoRes resObj = Constants.SdJsonProxy.dispatchList(dispatchInfoReq);
            if (resObj != null) {
                Constants.sdCkeCodeUtil.sdckeCode(resObj.getCode());
                return resObj;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

