/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.service;

import com.testin.itestin.api.bean.LoginRes;
import com.testin.itestin.api.serviceimp.SdLoginServiceImp;
import com.testin.itestin.common.Constants;
import com.testin.itestin.entitys.UserInfo;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.util.DES3;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LoginService {
    static Logger log = Logger.getLogger(LoginService.class);
    private int autoLogin = 0;
    private String defEmail;
    private UserInfo defaultUser;
    private Set<UserInfo> userList = new HashSet<UserInfo>();
    private String userXML;
    private LoginRes loginRes;
    private static LoginService loginService = new LoginService();
    DefaultHandler handler = new DefaultHandler(){

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("users".equals(qName)) {
                LoginService.this.defEmail = attributes.getValue("default");
                try {
                    LoginService.this.autoLogin = Integer.parseInt(attributes.getValue("auto"));
                }
                catch (NumberFormatException ne) {
                    log.error((Object)ne.getMessage(), (Throwable)ne);
                }
            } else if ("user".equals(qName)) {
                UserInfo u = new UserInfo();
                u.setEmail(attributes.getValue("email"));
                try {
                    char[] key = "itestin3.0".toCharArray();
                    String pwd = attributes.getValue("password");
                    pwd = new String(DES3.decrypt(key, pwd.getBytes()));
                    u.setPassword(pwd);
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (GeneralSecurityException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                LoginService.this.userList.add(u);
                if (StringUtils.isNotEmpty((String)LoginService.this.defEmail) && LoginService.this.defEmail.equals(u.getEmail())) {
                    LoginService.this.defaultUser = u;
                    LoginService.this.defaultUser.setAutologin(LoginService.this.autoLogin);
                }
            }
        }
    };

    public static void main(String[] args) {
    }

    public LoginRes getLoginRes() {
        return this.loginRes;
    }

    private LoginService() {
        this.userXML = String.valueOf(DirectoryService.getUserDir()) + File.separator + "user.xml";
        this.loadXML();
    }

    public static LoginService getInstance() {
        return loginService;
    }

    private void loadXML() {
        File f = new File(this.userXML);
        if (f.exists()) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = null;
            try {
                parser = factory.newSAXParser();
                parser.parse(new File(this.userXML), this.handler);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                f.delete();
            }
        }
    }

    private void updateXML(int flag) {
        File f = new File(this.userXML);
        Document doc = null;
        try {
            DocumentBuilder dombuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element root = null;
            if (f.exists()) {
                doc = dombuilder.parse(f);
                root = doc.getDocumentElement();
            } else {
                doc = dombuilder.newDocument();
                root = doc.createElement("users");
                doc.appendChild(root);
            }
            doc.setXmlStandalone(true);
            root.setAttribute("default", this.defaultUser.getEmail());
            root.setAttribute("auto", String.valueOf(this.defaultUser.getAutologin()));
            if (flag == 0) {
                this.updateUser(doc, root, this.defaultUser);
            } else {
                this.addUser(doc, root, this.defaultUser);
            }
            this.save(doc);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateUser(Document doc, Element parent, UserInfo u) {
        String email = u.getEmail();
        NodeList us = parent.getChildNodes();
        int i = 0;
        while (i < us.getLength()) {
            Node el = us.item(i);
            Node n = el.getAttributes().getNamedItem("email");
            if (email.equals(n.getNodeValue())) {
                try {
                    char[] key = "itestin3.0".toCharArray();
                    String pwd = u.getPassword();
                    pwd = new String(DES3.encrypt(key, pwd.getBytes()));
                    el.getAttributes().getNamedItem("password").setNodeValue(pwd);
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (GeneralSecurityException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                break;
            }
            ++i;
        }
    }

    private void addUser(Document doc, Element parent, UserInfo u) {
        Element el = doc.createElement("user");
        el.setAttribute("email", u.getEmail());
        try {
            char[] key = "itestin3.0".toCharArray();
            String pwd = u.getPassword();
            pwd = new String(DES3.encrypt(key, pwd.getBytes()));
            el.setAttribute("password", pwd);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        parent.appendChild(el);
    }

    private void save(Document doc) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("encoding", "utf-8");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(this.userXML);
        transformer.transform(source, result);
    }

    private UserInfo findByEmail(String email) {
        UserInfo u = null;
        for (UserInfo tmp : this.userList) {
            if (!email.equals(tmp.getEmail())) continue;
            u = tmp;
            break;
        }
        return u;
    }

    public UserInfo getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(UserInfo defaultUser) {
        this.defaultUser = defaultUser;
    }

    public Iterator<UserInfo> getUserList() {
        return this.userList.iterator();
    }

    public LoginRes login(String email, String password, int autologin) throws Exception {
        SdLoginServiceImp lo = new SdLoginServiceImp();
        if (email.equals(Constants.TEST_USER_NAME) && password.equals(Constants.TEST_USER_PASSWORD)) {
            this.loginRes = new LoginRes();
            this.loginRes.code = Constants.SUCCESS;
        } else {
            this.loginRes = lo.dologin(email, password);
        }
        if (this.loginRes != null && this.loginRes.getCode() == Constants.SUCCESS) {
            UserInfo u = this.findByEmail(email);
            int flag = 0;
            if (u == null) {
                this.defaultUser = new UserInfo();
                this.userList.add(this.defaultUser);
                flag = 1;
            } else {
                this.defaultUser = u;
            }
            this.defaultUser.setAutologin(autologin);
            this.defaultUser.setEmail(email);
            this.defaultUser.setPassword(password);
            this.defaultUser.setState(1);
            this.updateXML(flag);
        }
        return this.loginRes;
    }
}

