/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.service;

import com.testin.itestin.common.Proxy;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.util.PropertiesLoader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ProxyLoader {
    static Logger log = Logger.getLogger(ProxyLoader.class);
    private static ProxyLoader configLoader = new ProxyLoader();
    private static HashMap<String, String> list;
    private static final File file;

    static {
        file = new File(DirectoryService.getProxyPath());
    }

    public static ProxyLoader getInstance() {
        if (!file.exists()) {
            try {
                file.createNewFile();
                ProxyLoader.setConfigProperties();
            }
            catch (IOException e) {
                log.error((Object)("\u4ee3\u7406\u52a0\u8f7d\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f\u51fa\u9519\uff1a" + e));
            }
        }
        return configLoader;
    }

    private static void setConfigProperties() {
        PropertiesLoader.addOrUpdateProperties(file.toString(), "http.proxy.type", String.valueOf(Proxy.proxyType));
        PropertiesLoader.addOrUpdateProperties(file.toString(), "http.proxy.host", String.valueOf(Proxy.proxyHost));
        PropertiesLoader.addOrUpdateProperties(file.toString(), "http.proxy.port", String.valueOf(Proxy.proxyPort));
        PropertiesLoader.addOrUpdateProperties(file.toString(), "http.proxy.user", Proxy.proxyUser);
        PropertiesLoader.addOrUpdateProperties(file.toString(), "http.proxy.password", String.valueOf(Proxy.proxyPassword));
    }

    public void saveConfig() {
        ProxyLoader.setConfigProperties();
    }

    public void loadConfig() {
        list = PropertiesLoader.readProperties(file.toString());
        String value = list.get("http.proxy.type");
        if (StringUtils.isNotEmpty((String)value) && StringUtils.isNumeric((String)value)) {
            Proxy.proxyType = Integer.parseInt(value);
        }
        if (StringUtils.isNotEmpty((String)(value = list.get("http.proxy.host")))) {
            Proxy.proxyHost = value;
        }
        if (StringUtils.isNotEmpty((String)(value = list.get("http.proxy.port"))) && StringUtils.isNumeric((String)value)) {
            Proxy.proxyPort = Integer.parseInt(value);
        }
        if (StringUtils.isNotEmpty((String)(value = list.get("http.proxy.user")))) {
            Proxy.proxyUser = value;
        }
        if (StringUtils.isNotEmpty((String)(value = list.get("http.proxy.password")))) {
            Proxy.proxyPassword = value;
        }
    }
}

