/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.shell;

import com.testin.itestin.shell.IShellOutputReceiver;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public abstract class MultiLineReceiver
implements IShellOutputReceiver {
    private boolean mTrimLines = true;
    private String mUnfinishedLine = null;
    private final ArrayList<String> mArray = new ArrayList();

    public void setTrimLine(boolean trim) {
        this.mTrimLines = trim;
    }

    @Override
    public final void addOutput(byte[] data, int offset, int length) {
        if (!this.isCancelled()) {
            String s = null;
            try {
                s = new String(data, offset, length, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                s = new String(data, offset, length);
            }
            if (s != null) {
                if (this.mUnfinishedLine != null) {
                    s = String.valueOf(this.mUnfinishedLine) + s;
                    this.mUnfinishedLine = null;
                }
                this.mArray.clear();
                int start = 0;
                while (true) {
                    int index = s.indexOf("\r\n", start);
                    int linern = 2;
                    if (index == -1) {
                        index = s.indexOf("\n", start);
                        linern = 1;
                    }
                    if (index == -1) break;
                    String line = s.substring(start, index);
                    if (this.mTrimLines) {
                        line = line.trim();
                    }
                    this.mArray.add(line);
                    start = index + linern;
                }
                this.mUnfinishedLine = s.substring(start);
                if (this.mArray.size() > 0) {
                    String[] lines = this.mArray.toArray(new String[this.mArray.size()]);
                    this.processNewLines(lines);
                }
            }
        }
    }

    @Override
    public final void flush() {
        if (this.mUnfinishedLine != null) {
            this.processNewLines(new String[]{this.mUnfinishedLine});
        }
        this.done();
    }

    public void done() {
    }

    public abstract void processNewLines(String[] var1);
}

