/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.shell;

import com.testin.itestin.shell.IShellOutputReceiver;
import com.testin.itestin.shell.MultiLineReceiver;
import com.testin.itestin.shell.ShellCommandUnresponsiveException;
import com.testin.itestin.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ShellExecutor {
    static Logger log = Logger.getLogger(ShellExecutor.class);

    public static void executeCommand(String workDir, String command, IShellOutputReceiver rcvr, int maxTimeToOutputResponse) throws ShellCommandUnresponsiveException, IOException {
        int WAIT_TIME = 5;
        int MAX_TEST_COUNT = 10;
        int test = 0;
        Process proc = null;
        InputStream input = null;
        try {
            List<String> cmds = ShellExecutor.parseCmds(command);
            ProcessBuilder processBuilder = new ProcessBuilder(cmds);
            if (workDir != null) {
                processBuilder.directory(new File(workDir));
            }
            processBuilder.redirectErrorStream(true);
            proc = processBuilder.start();
            input = proc.getInputStream();
            byte[] buffer = new byte[2048];
            int timeToResponseCount = 0;
            while (rcvr == null || !rcvr.isCancelled()) {
                int count = 0;
                if (input.available() > 0) {
                    count = input.read(buffer);
                }
                if (count < 0) {
                    log.info((Object)("execute '" + command + " on device : EOF hit. Read: " + count));
                } else if (count == 0) {
                    int wait = 25;
                    if (maxTimeToOutputResponse > 0 && (timeToResponseCount += wait) > maxTimeToOutputResponse) {
                        throw new ShellCommandUnresponsiveException();
                    }
                    Utils.sleep(wait);
                } else {
                    timeToResponseCount = 0;
                    if (rcvr != null) {
                        rcvr.addOutput(buffer, 0, count);
                    }
                }
                try {
                    proc.exitValue();
                    if (++test < 10) {
                    }
                    break;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    private static List<String> parseCmds(String cmd) {
        Pattern p = Pattern.compile("([\\\"'](\\S+)[\\\"']|[\\\"']([^\\\"^']+)[\\\"']|\\S+)(\\s+|$)");
        Matcher m = p.matcher(cmd);
        ArrayList<String> ss = new ArrayList<String>();
        while (m.find()) {
            if (m.group(3) != null) {
                ss.add(m.group(3));
                continue;
            }
            if (m.group(2) != null) {
                ss.add(m.group(2));
                continue;
            }
            ss.add(m.group(1));
        }
        return ss;
    }

    public static String executeCommand(String workDir, String command, int maxTimeToOutputResponse) throws ShellCommandUnresponsiveException, IOException {
        DefaultShellOutputReceiver rcvr = new DefaultShellOutputReceiver();
        ShellExecutor.executeCommand(workDir, command, rcvr, maxTimeToOutputResponse);
        return rcvr.getOutput();
    }

    public static final class DefaultShellOutputReceiver
    extends MultiLineReceiver {
        private static final String EOF = "\r\n";
        private boolean isCancel = false;
        private StringBuffer output = new StringBuffer();

        @Override
        public void processNewLines(String[] arg0) {
            String[] stringArray = arg0;
            int n = arg0.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.length() > 0) {
                    this.output.append(String.valueOf(line) + EOF);
                }
                ++n2;
            }
        }

        public String getOutput() {
            return this.output.toString();
        }

        public void cancel() {
            this.isCancel = true;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancel;
        }
    }
}

