/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.uiautomator;

import com.testin.itestin.business.MyRectangle;
import com.testin.itestin.uiautomator.tree.BasicTreeNode;
import com.testin.itestin.uiautomator.tree.UiHierarchyXmlLoader;
import com.testin.itestin.uiautomator.tree.UiNode;
import java.util.List;
import org.apache.log4j.Logger;

public class UiAutomatorModel {
    static Logger log = Logger.getLogger(UiAutomatorModel.class);
    private BasicTreeNode mRootNode;
    private BasicTreeNode mSelectedNode;
    private List<MyRectangle> mNafNodes;
    private boolean mExploreMode = true;
    private boolean mShowNafNodes = false;

    public UiAutomatorModel(String xmlDoc) {
        UiHierarchyXmlLoader loader = new UiHierarchyXmlLoader();
        BasicTreeNode rootNode = loader.parseXml(xmlDoc);
        if (rootNode == null) {
            log.error((Object)"null rootnode after parsing.");
            throw new IllegalArgumentException("Invalid ui automator hierarchy file.");
        }
        this.mNafNodes = loader.getNafNodes();
        if (this.mRootNode != null) {
            this.mRootNode.clearAllChildren();
        }
        this.mRootNode = rootNode;
        this.mExploreMode = true;
    }

    public BasicTreeNode getXmlRootNode() {
        return this.mRootNode;
    }

    public BasicTreeNode getSelectedNode() {
        return this.mSelectedNode;
    }

    public void setSelectedNode(BasicTreeNode node) {
        this.mSelectedNode = node;
    }

    public MyRectangle getCurrentDrawingRect() {
        MyRectangle mCurrentDrawingRect = null;
        if (this.getSelectedNode() instanceof UiNode) {
            UiNode uiNode = (UiNode)this.getSelectedNode();
            mCurrentDrawingRect = new MyRectangle(uiNode.getX(), uiNode.getY(), uiNode.getWidth(), uiNode.getHeight());
        }
        return mCurrentDrawingRect;
    }

    public BasicTreeNode getSelectedNodeByCoordinates(int x, int y) {
        MinAreaFindNodeListener listener;
        boolean found;
        BasicTreeNode node = null;
        if (this.mRootNode != null && (found = this.mRootNode.findLeafMostNodesAtPoint(x, y, listener = new MinAreaFindNodeListener())) && listener.mNode != null && !listener.mNode.equals(this.getSelectedNode())) {
            node = listener.mNode;
        }
        return node;
    }

    public BasicTreeNode getContainerNode(BasicTreeNode ... nodes) {
        return null;
    }

    public boolean isExploreMode() {
        return this.mExploreMode;
    }

    public void toggleExploreMode() {
        this.mExploreMode = !this.mExploreMode;
    }

    public void setExploreMode(boolean exploreMode) {
        this.mExploreMode = exploreMode;
    }

    public List<MyRectangle> getNafNodes() {
        return this.mNafNodes;
    }

    public void toggleShowNaf() {
        this.mShowNafNodes = !this.mShowNafNodes;
    }

    public boolean shouldShowNafNodes() {
        return this.mShowNafNodes;
    }

    private static class MinAreaFindNodeListener
    implements BasicTreeNode.IFindNodeListener {
        BasicTreeNode mNode = null;

        private MinAreaFindNodeListener() {
        }

        @Override
        public void onFoundNode(BasicTreeNode node) {
            boolean enabled = false;
            if (node instanceof UiNode) {
                UiNode cur = (UiNode)node;
                enabled = Boolean.parseBoolean(cur.getAttribute("enabled"));
            }
            if (this.mNode == null && enabled) {
                this.mNode = node;
            } else if (enabled && node.getHeight() * node.getWidth() < this.mNode.getHeight() * this.mNode.getWidth()) {
                this.mNode = node;
            }
        }
    }
}

