/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.uiautomator.tree;

import com.testin.itestin.uiautomator.tree.UiNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BasicTreeNode {
    private static final BasicTreeNode[] CHILDREN_TEMPLATE = new BasicTreeNode[0];
    protected BasicTreeNode mParent;
    protected final List<BasicTreeNode> mChildren = new ArrayList<BasicTreeNode>();
    private int x;
    private int y;
    private int width;
    private int height;
    protected boolean mHasBounds = false;

    public void addChild(BasicTreeNode child) {
        if (child == null) {
            throw new NullPointerException("Cannot add null child");
        }
        if (this.mChildren.contains(child)) {
            throw new IllegalArgumentException("node already a child");
        }
        this.removeImproperUiNode(child);
        this.mChildren.add(child);
        child.mParent = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeImproperUiNode(BasicTreeNode newChild) {
        if (newChild == null) {
            return;
        }
        List<BasicTreeNode> list = this.mChildren;
        synchronized (list) {
            ArrayList<BasicTreeNode> nodes2remove = new ArrayList<BasicTreeNode>();
            for (BasicTreeNode node : this.mChildren) {
                UiNode uinode;
                if (!newChild.isSameNode(node) || !(node instanceof UiNode) || Boolean.valueOf((uinode = (UiNode)node).getAttribute("clickable")).booleanValue()) continue;
                nodes2remove.add(node);
            }
            for (BasicTreeNode impropernode : nodes2remove) {
                this.mChildren.remove(impropernode);
            }
        }
    }

    public List<BasicTreeNode> getChildrenList() {
        return Collections.unmodifiableList(this.mChildren);
    }

    public BasicTreeNode[] getChildren() {
        return this.mChildren.toArray(CHILDREN_TEMPLATE);
    }

    public BasicTreeNode getParent() {
        return this.mParent;
    }

    public boolean hasChild() {
        return this.mChildren.size() != 0;
    }

    public int getChildCount() {
        return this.mChildren.size();
    }

    public void clearAllChildren() {
        for (BasicTreeNode child : this.mChildren) {
            child.clearAllChildren();
        }
        this.mChildren.clear();
    }

    public boolean findLeafMostNodesAtPoint(int px, int py, IFindNodeListener listener) {
        boolean foundInChild = false;
        for (BasicTreeNode node : this.mChildren) {
            foundInChild |= node.findLeafMostNodesAtPoint(px, py, listener);
        }
        if (foundInChild) {
            return true;
        }
        if (this.mHasBounds) {
            boolean enabled = false;
            if (this instanceof UiNode) {
                UiNode cur = (UiNode)this;
                enabled = Boolean.parseBoolean(cur.getAttribute("enabled"));
            }
            if (enabled && this.x <= px && px <= this.x + this.width && this.y <= py && py <= this.y + this.height) {
                listener.onFoundNode(this);
                return true;
            }
            return false;
        }
        return false;
    }

    public Object[] getAttributesArray() {
        return null;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getInfo() {
        return String.format("(x: %s, y: %s)(h: %s, w: %s)(children: %s)", this.x, this.y, this.width, this.height, this.getChildCount());
    }

    public String toString() {
        return String.format("(x: %s, y: %s)(h: %s, w: %s)(children: %s)", this.x, this.y, this.width, this.height, this.getChildCount());
    }

    public boolean isSameNode(BasicTreeNode node) {
        if (node == null) {
            return false;
        }
        return this.getX() == node.getX() && this.getY() == node.getY() && this.getWidth() == this.getWidth() && this.getHeight() == node.getHeight();
    }

    public static interface IFindNodeListener {
        public void onFoundNode(BasicTreeNode var1);
    }
}

