/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.uiautomator.tree;

import com.testin.itestin.business.MyRectangle;
import com.testin.itestin.uiautomator.tree.BasicTreeNode;
import com.testin.itestin.uiautomator.tree.RootWindowNode;
import com.testin.itestin.uiautomator.tree.UiNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UiHierarchyXmlLoader {
    static Logger log = Logger.getLogger(UiHierarchyXmlLoader.class);
    private BasicTreeNode mRootNode;
    private List<MyRectangle> mNafNodes;

    public BasicTreeNode parseXml(String xmlDoc) {
        if (xmlDoc == null || xmlDoc.equals("")) {
            return null;
        }
        this.mRootNode = null;
        this.mNafNodes = new ArrayList<MyRectangle>();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        DefaultHandler handler = new DefaultHandler(){
            BasicTreeNode mParentNode;
            BasicTreeNode mWorkingNode;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                boolean nodeCreated = false;
                this.mParentNode = this.mWorkingNode;
                if ("hierarchy".equals(qName)) {
                    this.mWorkingNode = new RootWindowNode(attributes.getValue("windowName"));
                    RootWindowNode tmpNode = new RootWindowNode(attributes.getValue("windowName"));
                    int i = 0;
                    while (i < attributes.getLength()) {
                        tmpNode.addAtrribute(attributes.getQName(i), attributes.getValue(i));
                        ++i;
                    }
                    this.mWorkingNode = tmpNode;
                    nodeCreated = true;
                } else if ("node".equals(qName)) {
                    UiNode tmpNode = new UiNode();
                    int i = 0;
                    while (i < attributes.getLength()) {
                        tmpNode.addAtrribute(attributes.getQName(i), attributes.getValue(i));
                        ++i;
                    }
                    this.mWorkingNode = tmpNode;
                    nodeCreated = true;
                    String naf = tmpNode.getAttribute("NAF");
                    if ("true".equals(naf)) {
                        UiHierarchyXmlLoader.this.mNafNodes.add(new MyRectangle(tmpNode.getX(), tmpNode.getY(), tmpNode.getWidth(), tmpNode.getHeight()));
                    }
                }
                if (nodeCreated) {
                    if (UiHierarchyXmlLoader.this.mRootNode == null) {
                        UiHierarchyXmlLoader.this.mRootNode = this.mWorkingNode;
                    }
                    if (this.mParentNode != null) {
                        this.mParentNode.addChild(this.mWorkingNode);
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (this.mParentNode != null) {
                    this.mWorkingNode = this.mParentNode;
                    this.mParentNode = this.mParentNode.getParent();
                }
            }
        };
        try {
            if (!xmlDoc.startsWith("<")) {
                xmlDoc = xmlDoc.substring(1);
            }
            parser.parse((InputStream)new ByteArrayInputStream(xmlDoc.getBytes()), handler);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return this.mRootNode;
    }

    public List<MyRectangle> getNafNodes() {
        return Collections.unmodifiableList(this.mNafNodes);
    }
}

