/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.util;

import com.testin.itestin.business.TestViewNode;
import com.testin.itestin.business.actions.ActionDrag;
import com.testin.itestin.business.actions.ActionRule;
import com.testin.itestin.business.actions.ActionTouch;
import com.testin.itestin.business.actions.ActionType;
import com.testin.itestin.business.actions.RemoteActionKey;
import com.testin.itestin.business.actions.TestAction;
import com.testin.itestin.business.actions.TestActionAssert;
import com.testin.itestin.business.actions.TestActionCheck;
import com.testin.itestin.business.actions.TestActionClick;
import com.testin.itestin.business.actions.TestActionDrag;
import com.testin.itestin.business.actions.TestActionInputkey;
import com.testin.itestin.business.actions.TestActionInputtext;
import com.testin.itestin.business.actions.TestActionScreenshot;
import com.testin.itestin.business.actions.TestActionSleep;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.event.EventOutputReceiver;
import com.testin.itestin.uiautomator.tree.BasicTreeNode;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class Utils {
    static Logger log = Logger.getLogger(Utils.class);
    public static String version = "4.1.0";
    public static Object updateDate = "2015-04-27";
    public static boolean enableScreenEventDetector = true;
    public static boolean autoFetchWindowInfo = true;
    public static long CURRENT_SCREENSHOT_TAKEN_TIME = 0L;
    public static boolean IS_SYNCING_SCREEN = false;
    public static int SCREENSHOT_INTERVAL = 1000;
    public static int WINDOW_INFO_FETCH_INTERVAL = 200;
    public static int FORCE_WINDOW_UPDATE_THRESHOLD = 10000;

    public static void gc() {
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isWindowInfoValid(String windowInfo) {
        return windowInfo != null && !windowInfo.equals("") && !windowInfo.equals("null");
    }

    public static String getCalleeNames() {
        int maxLevel = 20;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        if (stack.length <= 1) {
            return "The method call himself!";
        }
        String callStack = "";
        int i = 1;
        while (i < stack.length && i < maxLevel) {
            callStack = String.valueOf(callStack) + stack[i].getClassName().substring(stack[i].getClassName().lastIndexOf(".") + 1) + "." + stack[i].getMethodName() + "[" + stack[i].getLineNumber() + "]" + " >>";
            ++i;
        }
        callStack = stack.length > maxLevel ? String.valueOf(callStack) + (stack.length - maxLevel) + " more level(s) ..." : String.valueOf(callStack) + "End!";
        return callStack;
    }

    public static String getEncodedString(String string2encode) {
        try {
            Base64 base64 = new Base64();
            byte[] data = base64.encode(string2encode.getBytes("utf-8"));
            String newStr = new String(data, "utf-8");
            return newStr;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return string2encode;
        }
    }

    public static String getDecodedString(String encodedString) {
        byte[] data = Base64.decodeBase64((String)encodedString);
        try {
            return new String(data, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return encodedString;
        }
    }

    public static String getFirstLine(String multiLines) {
        String str2ret = multiLines;
        if (str2ret != null && str2ret.trim().contains("\n")) {
            str2ret = String.valueOf(str2ret.split("\n")[0].trim()) + "*";
        }
        return str2ret;
    }

    public static void startEventListener(DeviceInfo deviceinfo) {
        if (deviceinfo == null || deviceinfo.getDeviceShell() == null || deviceinfo.getDevice() == null || !deviceinfo.getDevice().isOnline()) {
            return;
        }
        EventOutputReceiver outputReceiver = new EventOutputReceiver(deviceinfo.getSdkVer());
        if (deviceinfo.getSdkVer() < 15) {
            deviceinfo.getDeviceShell().executeShellCommand("getevent", outputReceiver, 0);
        } else {
            deviceinfo.getDeviceShell().executeShellCommand("getevent -l", outputReceiver, 0);
        }
    }

    public static TestAction generateDragOnScreenAction(int rotation, float fromX, float toX, float fromY, float toY) {
        ActionDrag action = new ActionDrag();
        action.setAction(ActionType.local_drag);
        action.setRule(ActionRule.none);
        action.setRotation(rotation);
        action.setFromX(fromX);
        action.setToX(toX);
        action.setFromY(fromY);
        action.setToY(toY);
        return action;
    }

    public static TestAction generateTouchOnScreenAction(int rotation, float x, float y) {
        ActionTouch action = new ActionTouch();
        action.setAction(ActionType.local_touch);
        action.setRule(ActionRule.tap);
        action.setRotation(rotation);
        action.setX(x);
        action.setY(y);
        return action;
    }

    public static TestAction generateClickAction(ActionRule rule, int rotation, BasicTreeNode selectUiNode) {
        TestActionClick action_click = new TestActionClick();
        action_click.setAction(ActionType.click);
        action_click.setRule(rule);
        action_click.setRotation(rotation);
        action_click.setViewNode(TestViewNode.Factory.getInstance(selectUiNode));
        return action_click;
    }

    public static TestAction generateDragInNodeAction(ActionRule rule, int rotation, BasicTreeNode selectUiNode) {
        TestActionDrag action_drag = new TestActionDrag();
        action_drag.setAction(ActionType.drag);
        action_drag.setRule(rule);
        action_drag.setRotation(rotation);
        action_drag.setViewNode(TestViewNode.Factory.getInstance(selectUiNode));
        return action_drag;
    }

    public static TestAction generateInputTextAction(ActionRule rule, String text, BasicTreeNode selectUiNode) {
        TestActionInputtext action_inputtext = new TestActionInputtext();
        action_inputtext.setAction(ActionType.inputtext);
        action_inputtext.setRule(rule);
        if (rule == ActionRule.randomtext) {
            if (Utils.isNumber(text)) {
                int len = Integer.parseInt(text);
                len = len > 20 ? (len = 20) : len;
                action_inputtext.setLen(len);
            } else {
                action_inputtext.setLen(text.length());
            }
        }
        action_inputtext.setText(text);
        action_inputtext.setViewNode(TestViewNode.Factory.getInstance(selectUiNode));
        return action_inputtext;
    }

    public static TestAction generateCheckAction(ActionRule rule, BasicTreeNode selectUiNode) {
        TestActionCheck action_check = new TestActionCheck();
        action_check.setAction(ActionType.check);
        action_check.setRule(rule);
        action_check.setViewNode(TestViewNode.Factory.getInstance(selectUiNode));
        return action_check;
    }

    public static TestAction generateAssertAction(ActionRule rule, int rotation, String text, BasicTreeNode selectUiNode) {
        TestActionAssert action_assert = new TestActionAssert();
        action_assert.setAction(ActionType.assertfor);
        action_assert.setRule(rule);
        action_assert.setRotation(rotation);
        if (rule == ActionRule.waittext) {
            action_assert.setText(text);
        } else if (rule == ActionRule.waitwidget) {
            action_assert.setText("");
        }
        action_assert.setTimeout(30000);
        action_assert.setViewNode(TestViewNode.Factory.getInstance(selectUiNode));
        return action_assert;
    }

    public static TestAction generateInputkeyAction(ActionRule rule, String keyName) {
        TestActionInputkey action_inputkey = new TestActionInputkey();
        action_inputkey.setAction(ActionType.inputkey);
        action_inputkey.setRule(rule);
        action_inputkey.setKeyName(keyName);
        return action_inputkey;
    }

    public static TestAction generateScreenshotAction(String screenshotName) {
        TestActionScreenshot action_screenshot = new TestActionScreenshot();
        action_screenshot.setAction(ActionType.screenshot);
        action_screenshot.setRule(ActionRule.none);
        action_screenshot.setImageName(screenshotName);
        return action_screenshot;
    }

    public static TestAction generateSleepAction(int sleeptime) {
        TestActionSleep action_sleep = new TestActionSleep();
        action_sleep.setAction(ActionType.sleep);
        action_sleep.setRule(ActionRule.none);
        action_sleep.setSleep(sleeptime);
        return action_sleep;
    }

    public static TestAction generateAutoScreenshot(String sreenshotName, boolean isautoshot) {
        if (isautoshot) {
            TestAction takeScreenAction = null;
            takeScreenAction = Utils.generateScreenshotAction(UIController.getNextAutoImgName());
            return takeScreenAction;
        }
        return null;
    }

    public static TestAction generateRemoteKeyAction(String keycode) {
        RemoteActionKey action = new RemoteActionKey();
        action.setAction(ActionType.remote_key);
        action.setKeyName(keycode);
        action.setRule(ActionRule.press);
        return action;
    }

    public static boolean isNumber(String text) {
        Pattern p = Pattern.compile("[\\d]{1,}[\\.]{0,1}[\\d]{0,}");
        Matcher m = p.matcher(text);
        return m.matches();
    }

    public static File getHOMEDirectory() {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        return fsv.getHomeDirectory();
    }

    public static void beep() {
        Frame f = new Frame();
        Toolkit kit = f.getToolkit();
        kit.beep();
    }

    public static int getLargestDivisionFactor(int num1, int num2) {
        int t = 1;
        int i = 1;
        while (i <= num1) {
            if (num1 % i == 0 && num2 % i == 0) {
                t = i;
            }
            ++i;
        }
        return t;
    }

    public static long getInternetBeijingTime() {
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT+8"));
            URL url = new URL("http://www.baidu.com");
            URLConnection uc = url.openConnection();
            uc.connect();
            long ld = uc.getDate();
            return ld;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
    }
}

