/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class ZipUtil {
    public static void compressedFile(String resourcesPath, String targetZipFile) throws Exception {
        File resourcesFile = new File(resourcesPath);
        File targetFile = new File(targetZipFile);
        if (targetFile.exists()) {
            FileUtils.deleteQuietly((File)targetFile);
        }
        FileOutputStream outputStream = new FileOutputStream(targetZipFile);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(outputStream));
        ZipUtil.createCompressedFile(out, resourcesFile, "");
        out.close();
    }

    public static void createCompressedFile(ZipOutputStream out, File file, String dir) throws Exception {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            out.putNextEntry(new ZipEntry(String.valueOf(dir) + File.separator));
            dir = dir.length() == 0 ? "" : String.valueOf(dir) + File.separator;
            int i = 0;
            while (i < files.length) {
                ZipUtil.createCompressedFile(out, files[i], String.valueOf(dir) + files[i].getName());
                ++i;
            }
        } else {
            FileInputStream fis = new FileInputStream(file);
            out.putNextEntry(new ZipEntry(dir));
            int j = 0;
            byte[] buffer = new byte[1024];
            while ((j = fis.read(buffer)) > 0) {
                out.write(buffer, 0, j);
            }
            fis.close();
        }
    }

    public static void compressedFiles(File[] files, String targetZipFile) throws Exception {
        File targetFile = new File(targetZipFile);
        if (targetFile.exists()) {
            FileUtils.deleteQuietly((File)targetFile);
        }
        FileOutputStream outputStream = new FileOutputStream(targetZipFile);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(outputStream));
        ZipUtil.createCompressedFiles(out, files);
        out.close();
    }

    public static void createCompressedFiles(ZipOutputStream out, File[] files) throws Exception {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            FileInputStream fis = new FileInputStream(file);
            out.putNextEntry(new ZipEntry(file.getName()));
            int j = 0;
            byte[] buffer = new byte[1024];
            while ((j = fis.read(buffer)) > 0) {
                out.write(buffer, 0, j);
            }
            fis.close();
            ++n2;
        }
    }
}

