/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx;

import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.os.HandlerThread;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.service.ServicesManager;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.Utils;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.DialogResponse;
import com.testin.javafx.ui.control.UpgradeConfirmDialog;
import com.testin.javafx.update.UpdateConfig;
import com.testin.javafx.update.Updater;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import org.apache.log4j.Logger;

public class Main
extends Application
implements DevicesManager.DeviceStateListener {
    private static Logger log = Logger.getLogger(Main.class);
    private static Stage stage;
    private static ResourceBundle resourceBundle;

    public static void main(String[] args) {
        Thread.currentThread().setName("UI-Main");
        log.info((Object)("version: " + Utils.version));
        log.info((Object)("java.version: " + System.getProperty("java.version")));
        Locale defaultLocale = Locale.getDefault();
        String country = defaultLocale.getCountry();
        log.info((Object)("country.code: " + country));
        if (country.equals("CN")) {
            Locale currentLocale = new Locale("zh", "CN");
            resourceBundle = ResourceBundle.getBundle("zh", currentLocale);
        } else {
            Locale currentLocale = new Locale("zh", "CN");
            resourceBundle = ResourceBundle.getBundle("zh", currentLocale);
        }
        File mClientFileNew = new File(UpdateConfig.getClientDat());
        File mClientFileOld = new File(UpdateConfig.getClientDatOld());
        if (!mClientFileNew.exists() && mClientFileOld.exists()) {
            try {
                Updater.getInstance().copyFile(mClientFileOld, mClientFileNew);
                mClientFileOld.deleteOnExit();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Main.launch((String[])args);
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static String getInternationalString(String keyname) {
        if (resourceBundle == null) {
            return keyname;
        }
        try {
            return new String(resourceBundle.getString(keyname).getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return keyname;
        }
    }

    public void start(Stage primaryStage) {
        try {
            String yh = String.valueOf(DirectoryService.getFontPath()) + File.separator + "MSYH.TTF";
            String yhBD = String.valueOf(DirectoryService.getFontPath()) + File.separator + "MSYHBD.TTF";
            FileInputStream msyh = new FileInputStream(yh);
            FileInputStream msyhbd = new FileInputStream(yhBD);
            Font.loadFont((InputStream)msyh, (double)12.0);
            Font.loadFont((InputStream)msyhbd, (double)12.0);
            Font.loadFont((InputStream)msyh, (double)14.0);
            Font.loadFont((InputStream)msyhbd, (double)14.0);
            Font.loadFont((InputStream)msyh, (double)16.0);
            Font.loadFont((InputStream)msyhbd, (double)16.0);
            try {
                msyh.close();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                msyhbd.close();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            String defaultFamily = Font.getDefault().getFamily();
            List fontFamilies = Font.getFamilies();
            log.info((Object)String.format("Default Family: %s", defaultFamily));
            log.info((Object)String.format("FamilyList: %s", fontFamilies));
            TestinStage.setPrimaryStage(primaryStage);
            TestinStage.setHostServices(this.getHostServices());
            HandlerThread.loop();
            String url = Main.class.getResource("/com/testin/javafx/resources/logo.png").toExternalForm();
            Image icon = new Image(url);
            stage = primaryStage;
            stage.getIcons().add((Object)icon);
            stage.initStyle(StageStyle.UNDECORATED);
            stage.setResizable(false);
            stage.setTitle(String.format("iTestin %s", Utils.version));
            stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent arg0) {
                    System.exit(0);
                }
            });
            TestinStage.gotoTemplate();
            TestinStage.gotoLogin();
            primaryStage.show();
            this.checkUpdate();
            ServicesManager.getInstance().start();
            DevicesManager.getInstance().start();
            DevicesManager.getInstance().addDeviceStateListener(this);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void checkUpdate() {
        Thread t = new Thread("UpdateChecker"){

            @Override
            public void run() {
                log.info((Object)"Checking new version of iTestin.");
                if (Updater.getInstance().isUpdateNeeded()) {
                    DialogResponse resp = UpgradeConfirmDialog.show(Main.getInternationalString("main.checkupdate.confirmupdate"), "");
                    if (resp.option == DialogResponse.Options.OK) {
                        TestinStage.gotoUpdate();
                    }
                }
                Utils.gc();
            }
        };
        ThreadPool.execute(t);
    }

    @Override
    public void onStateChange(DeviceInfo deviceInfo, int state) {
        int statusCode;
        if (state == 0) {
            DeviceInfo di = DevicesManager.getDevice();
            if (!DevicesManager.isDeviceOK(di)) {
                DevicesManager.getInstance().setCurrentDeviceInfo(deviceInfo);
            }
            statusCode = 257;
        } else {
            statusCode = 258;
        }
        if (UIController.getTopHandler() != null) {
            Message tmpmsg = new Message();
            tmpmsg.setStatus(statusCode);
            tmpmsg.setContent(deviceInfo);
            UIController.getTopHandler().sendMessage(tmpmsg);
        }
    }
}

