/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.api.bean.CloudInfoRes;
import com.testin.itestin.business.utils.UIController;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.LoginController;
import com.testin.javafx.ui.control.AlertDialog;
import com.testin.javafx.ui.control.DialogResponse;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class CloudSelectController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    AnchorPane CloudSelect;
    @FXML
    ListView<RadioButton> listView;
    @FXML
    Button ok;
    @FXML
    Button cancel;
    @FXML
    RadioButton publicCloud;
    @FXML
    RadioButton privateCloud;
    @FXML
    Label accountLabel;
    @FXML
    TextField accoutnTextField;
    @FXML
    Label accountSelect;
    @FXML
    Label accountHint;
    private static CloudSelectController csc = new CloudSelectController();
    private static String cloudName;
    private Stage stage;
    private DialogResponse response = new DialogResponse();
    LoginController lc = new LoginController();
    ArrayList<CloudInfoRes> cr = this.lc.getCloudName();

    public static CloudSelectController getInstance() {
        return csc;
    }

    public String getCloudName() {
        return cloudName;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setAccountFlag(boolean f) {
        if (!f) {
            this.accountLabel.setDisable(true);
            this.accoutnTextField.setDisable(true);
            this.accountSelect.setDisable(true);
            this.accountHint.setDisable(true);
        } else {
            this.accountLabel.setDisable(false);
            this.accoutnTextField.setDisable(false);
            this.accountSelect.setDisable(false);
            this.accountHint.setDisable(false);
        }
    }

    public DialogResponse getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = TestinStage.getStylesheet();
        this.CloudSelect.getStylesheets().add((Object)css);
        ToggleGroup group1 = new ToggleGroup();
        int i = 0;
        while (i < this.cr.size()) {
            String name = "";
            name = !this.cr.get(i).getData().getDeviceSource().getIcloudName().equals("") ? this.cr.get(i).getData().getDeviceSource().getIcloudName() : (!this.cr.get(i).getData().getDeviceSource().getDescr().equals("") ? this.cr.get(i).getData().getDeviceSource().getDescr() : this.cr.get(i).getData().getDeviceSource().getName());
            RadioButton temp = new RadioButton();
            temp.setText(name);
            temp.setToggleGroup(group1);
            temp.setDisable(true);
            this.listView.getItems().add((Object)temp);
            ++i;
        }
        if (this.cr.size() == 0) {
            this.privateCloud.setDisable(true);
        }
        ToggleGroup group = new ToggleGroup();
        this.publicCloud.setToggleGroup(group);
        this.publicCloud.setSelected(true);
        this.privateCloud.setToggleGroup(group);
    }

    @FXML
    public void clickPublic(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        int i = 0;
        while (i < this.cr.size()) {
            ((RadioButton)this.listView.getItems().get(i)).setDisable(true);
            ++i;
        }
    }

    @FXML
    public void keyPublicClick(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        int i = 0;
        while (i < this.cr.size()) {
            ((RadioButton)this.listView.getItems().get(i)).setDisable(true);
            ++i;
        }
    }

    @FXML
    public void clickPrivate(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        int i = 0;
        while (i < this.cr.size()) {
            ((RadioButton)this.listView.getItems().get(i)).setDisable(false);
            ++i;
        }
    }

    @FXML
    public void keyPrivateClick(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        int i = 0;
        while (i < this.cr.size()) {
            ((RadioButton)this.listView.getItems().get(i)).setDisable(false);
            ++i;
        }
    }

    @FXML
    public void clickOk(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        int i = -1;
        if (this.publicCloud.isSelected()) {
            this.response.value = "adapt.testin";
            cloudName = "adapt.testin";
        } else {
            i = 0;
            while (i < this.cr.size()) {
                if (((RadioButton)this.listView.getItems().get(i)).isSelected()) {
                    this.response.value = this.cr.get(i).getData().getDeviceSource().getName();
                    cloudName = this.cr.get(i).getData().getDeviceSource().getName();
                    break;
                }
                ++i;
            }
        }
        if (i == this.cr.size()) {
            AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("cloudselectcontroller.clickok.cloudselect"));
        } else {
            this.response.option = DialogResponse.Options.OK;
            this.response.value2 = this.accoutnTextField.getText();
            this.stage.close();
        }
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.CANCEL;
        this.response.value = null;
        this.stage.close();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getText().equals("\r")) {
            int i = -1;
            if (this.publicCloud.isSelected()) {
                this.response.value = "adapt.testin";
                cloudName = "adapt.testin";
            } else {
                i = 0;
                while (i < this.cr.size()) {
                    if (((RadioButton)this.listView.getItems().get(i)).isSelected()) {
                        this.response.value = this.cr.get(i).getData().getDeviceSource().getName();
                        cloudName = this.cr.get(i).getData().getDeviceSource().getName();
                        break;
                    }
                    ++i;
                }
            }
            if (i == this.cr.size()) {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("cloudselectcontroller.clickok.cloudselect"));
            } else {
                this.response.option = DialogResponse.Options.OK;
                this.response.value2 = this.accoutnTextField.getText();
                this.stage.close();
            }
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getText().equals("\r")) {
            this.response.option = DialogResponse.Options.CANCEL;
            this.stage.close();
        }
    }

    @FXML
    public void selectClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            UIController.updateNodeSytleClass((Node)this.accountSelect, "labelBtnPress");
            FileChooser chooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("*.txt", new String[]{"*.txt"});
            chooser.getExtensionFilters().add((Object)extFilter);
            File f = chooser.showOpenDialog(null);
            if (f != null) {
                this.accoutnTextField.setText(f.getPath());
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            UIController.updateNodeSytleClass((Node)this.accountSelect, "labelBtnEnter");
        } else if (eventType.equals("MOUSE_EXITED")) {
            UIController.updateNodeSytleClass((Node)this.accountSelect, "labelBtnNormal");
        } else if (eventType.equals("MOUSE_PRESSED")) {
            UIController.updateNodeSytleClass((Node)this.accountSelect, "labelBtnPress");
        }
    }
}

