/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.utils.UIController;
import com.testin.javafx.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import org.apache.log4j.Logger;

public class CoordRecordController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(CoordRecordController.class);
    @FXML
    AnchorPane child;
    Label startButton;
    Label stopButton;
    Label replayTimesValue;
    Label saveScript;
    Label scriptTimer;
    Label scriptName;
    Label nameandVersion;
    Label separatorLine;
    Label startReplay;
    ImageView iconImage;
    @FXML
    AnchorPane scriptChild;
    Label sleepbtn;
    Label shotbtn;
    Label editbtn;
    Label delbtn;
    Label descbtn;

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.startButton = (Label)this.child.lookup("#startButton");
        this.stopButton = (Label)this.child.lookup("#stopButton");
        this.saveScript = (Label)this.child.lookup("#scriptSave");
        this.scriptTimer = (Label)this.child.lookup("#scriptTimer");
        this.replayTimesValue = (Label)this.child.lookup("#replayTimesValue");
        this.scriptName = (Label)this.child.lookup("#scriptName");
        this.startReplay = (Label)this.child.lookup("#startReplay");
        this.nameandVersion = (Label)this.child.lookup("#nameandVersion");
        this.separatorLine = (Label)this.child.lookup("#separatorLine");
        this.iconImage = (ImageView)this.child.lookup("#iconImage");
        this.sleepbtn = (Label)this.scriptChild.lookup("#sleepbtn");
        this.shotbtn = (Label)this.scriptChild.lookup("#shotbtn");
        this.delbtn = (Label)this.scriptChild.lookup("#delbtn");
        this.editbtn = (Label)this.scriptChild.lookup("#editbtn");
        this.descbtn = (Label)this.scriptChild.lookup("#descbtn");
    }

    public void setRunStyle() {
        this.setIconimage();
        String txt = "";
        if (SingleTestCase.getInstance().getRunType() == 0) {
            UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnDisable");
            this.separatorLine.setVisible(false);
            this.scriptName.setVisible(false);
            this.setSaveScript(false);
        } else {
            UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnNormal");
            this.scriptName.setVisible(true);
            this.separatorLine.setVisible(true);
            String showname = "";
            showname = SingleTestCase.getInstance().getCoordScriptPath() != null ? String.valueOf(SingleTestCase.getInstance().getName()) + " (" + SingleTestCase.getInstance().getCoordPixel() + ")" : SingleTestCase.getInstance().getName();
            UIController.updateLabelText(this.scriptName, showname);
            this.updateBottomButtonsStyle();
        }
        txt = String.format("%s %s", SingleTestCase.getInstance().getAppName(), "null".equals(SingleTestCase.getInstance().getVersion()) || SingleTestCase.getInstance().getVersion() == null ? "" : SingleTestCase.getInstance().getVersion());
        UIController.updateLabelText(this.nameandVersion, txt);
        this.startButton.setTooltip(new Tooltip(Main.getInternationalString("recordactioncontroller.lable.start")));
        this.startReplay.setTooltip(new Tooltip(Main.getInternationalString("recordactioncontroller.lable.replay")));
        this.stopButton.setTooltip(new Tooltip(Main.getInternationalString("recordactioncontroller.lable.stop")));
        UIController.updateLabelText(this.scriptTimer, "00:00");
        this.replayTimesValue.setVisible(false);
    }

    public void setSaveScript(boolean flag) {
        if (flag) {
            SingleTestCase.getInstance().setSaved(false);
            UIController.updateNodeSytleClass((Node)this.saveScript, "saveBtnNormal");
        } else {
            SingleTestCase.getInstance().setSaved(true);
            UIController.updateNodeSytleClass((Node)this.saveScript, "saveBtnDisable");
        }
    }

    public void autoRecord() {
        try {
            Constructor con = MouseEvent.class.getDeclaredConstructor(EventType.class);
            con.setAccessible(true);
            Object obj = con.newInstance(MouseEvent.MOUSE_CLICKED);
            MouseEvent mouseEvent = (MouseEvent)obj;
            this.startButton.fireEvent((Event)mouseEvent);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setIconimage() {
        try {
            String rootPath = TestFileUtils.getTestRootDir();
            File f = new File(String.valueOf(rootPath) + "icon.png");
            FileInputStream in = new FileInputStream(f);
            Image icon = new Image((InputStream)in);
            this.iconImage.setImage(icon);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void updateBottomButtonsStyle() {
        UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkg");
        UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkg");
        UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkg");
        UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkg");
        UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkg");
    }
}

