/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.api.bean.CloudInfoRes;
import com.testin.itestin.api.bean.LoginRes;
import com.testin.itestin.api.bean.UserInfoRes;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.common.Constants;
import com.testin.itestin.common.Proxy;
import com.testin.itestin.entitys.UserInfo;
import com.testin.itestin.os.Handler;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.LoginService;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.NetDialog;
import com.testin.javafx.ui.control.InputIEProxyPwdDialog;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.apache.log4j.Logger;

public class LoginController
extends AnchorPane
implements Initializable {
    @FXML
    AnchorPane loginPage;
    @FXML
    Pane loginPane;
    @FXML
    TextField username;
    @FXML
    TextField password;
    @FXML
    CheckBox autoLogin;
    @FXML
    Label login;
    @FXML
    ImageView loginImg;
    @FXML
    Hyperlink register;
    @FXML
    Label loginState;
    static Logger log = Logger.getLogger(LoginController.class);
    private static ArrayList<CloudInfoRes> cr = new ArrayList();
    private Handler handler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.getStatus()) {
                case 0: {
                    LoginController.this.loginState.setText("");
                    break;
                }
                case -1: {
                    LoginController.this.loginState.setText(msg.getContent());
                }
            }
        }
    };

    public ArrayList<CloudInfoRes> getCloudName() {
        return cr;
    }

    private void doLogin(final String email, final String pwd, final int auto) {
        Thread t = new Thread("AutoLogin"){

            @Override
            public void run() {
                log.info((Object)("Doing login for user: " + email));
                LoginRes res = null;
                try {
                    res = LoginService.getInstance().login(email, pwd, auto);
                    LoginController.this.onLogin(res, email, pwd, auto);
                    cr.clear();
                    if (res != null && res.getCode() == Constants.SUCCESS) {
                        UserInfo userInfo = LoginService.getInstance().getDefaultUser();
                        String email2 = userInfo.getEmail();
                        String pwd2 = userInfo.getPassword();
                        UserInfoRes ur = null;
                        while (ur == null && userInfo.getState() == 1) {
                            if (email2.equals(Constants.TEST_USER_NAME) && pwd2.equals(Constants.TEST_USER_PASSWORD)) break;
                            ur = Constants.SdJsonProxy.userInfo(email2);
                            Utils.sleep(1000L);
                        }
                        if (ur != null && ur.getData().getUserinfo() != null) {
                            String[] cloudId = ur.getData().getUserinfo().getMatchSources();
                            int i = 0;
                            while (i < cloudId.length - 1) {
                                cr.add(i, Constants.SdJsonProxy.CloudInfo(cloudId[i]));
                                ++i;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    if (e.getMessage() != null) {
                        if (e.getMessage().contains("java.net.UnknownHostException")) {
                            res = new LoginRes();
                            res.setCode(90401);
                        } else if (e.getMessage().contains("java.net.SocketException")) {
                            res = new LoginRes();
                            res.setCode(90402);
                        } else if (e.getMessage().contains("Connection timed out")) {
                            res = new LoginRes();
                            res.setCode(90404);
                        } else if (e.getMessage().contains("No route to host")) {
                            res = new LoginRes();
                            res.setCode(90405);
                        } else if (e.getMessage().contains("java.io.IOException: Server returned HTTP response code: 407") || e.getMessage().contains("java.net.ProtocolException: Server redirected too many  times")) {
                            if (Proxy.proxyType == 2) {
                                InputIEProxyPwdDialog.show();
                            } else {
                                res = new LoginRes();
                                res.setCode(90403);
                            }
                        }
                    } else {
                        res = new LoginRes();
                        res.setCode(90403);
                    }
                    LoginController.this.onLogin(res, email, pwd, auto);
                }
                Utils.gc();
            }
        };
        ThreadPool.execute(t);
    }

    public void initialize(URL location, ResourceBundle resources) {
        LoginService loginService = LoginService.getInstance();
        UserInfo user = loginService.getDefaultUser();
        if (user != null) {
            String email = user.getEmail();
            String pwd = user.getPassword();
            int auto = user.getAutologin();
            this.username.setText(email);
            this.password.setText(pwd);
            if (auto == 0) {
                this.autoLogin.setSelected(false);
            } else {
                this.autoLogin.setSelected(true);
                this.doLogin(email, pwd, auto);
            }
        }
    }

    private void onLogin(LoginRes res, String email, String pwd, int auto) {
        Message msg = new Message();
        msg.setStatus(-1);
        if (res != null) {
            if (res.getCode() == Constants.SUCCESS) {
                log.info((Object)("User " + email + " login successful."));
                msg = new Message();
                msg.setStatus(513);
                msg.setContent(email);
                UIController.getTopHandler().sendMessage(msg);
                msg = new Message();
                msg.setStatus(0);
                msg.setContent(email);
                this.handler.sendMessage(msg);
            } else {
                log.info((Object)("User " + email + " login failed. Error code: " + res.getCode()));
                switch (res.getCode()) {
                    case 10401: {
                        msg.setContent(String.valueOf(Main.getInternationalString("logincontroller.onlogin.invalidusername")) + "(10401)");
                        break;
                    }
                    case 10403: {
                        msg.setContent(String.valueOf(Main.getInternationalString("logincontroller.onlogin.invalidpassword")) + "(10403)");
                        break;
                    }
                    case 10404: {
                        msg.setContent(String.valueOf(Main.getInternationalString("logincontroller.onlogin.networkerror3")) + "(10404)");
                        break;
                    }
                    case 90401: {
                        msg.setContent(String.valueOf(Main.getInternationalString("logincontroller.onlogin.networkerror1")) + "(90401)");
                        break;
                    }
                    case 90402: {
                        msg.setContent(String.valueOf(Main.getInternationalString("logincontroller.onlogin.networkerror2")) + "(90402)");
                        break;
                    }
                    case 90403: {
                        msg.setContent(String.valueOf(Main.getInternationalString("logincontroller.onlogin.networkerror")) + "(90403)");
                        break;
                    }
                    case 90404: {
                        msg.setContent(String.valueOf(Main.getInternationalString("logincontroller.onlogin.networkerror4")) + "(90404)");
                        break;
                    }
                    case 90405: {
                        msg.setContent(String.valueOf(Main.getInternationalString("logincontroller.onlogin.networkerror5")) + "(90405)");
                        break;
                    }
                    case 1000504: {
                        msg.setContent(String.valueOf(Main.getInternationalString("logincontroller.onlogin.networkerror6")) + "(1000504)");
                        break;
                    }
                    default: {
                        msg.setContent(Main.getInternationalString("logincontroller.onlogin.othererror"));
                    }
                }
            }
        }
        this.handler.sendMessage(msg);
    }

    @FXML
    public void Register() {
        TestinStage.getHostServices().showDocument(Constants.REGISTRY_WEB_URL);
    }

    @FXML
    public void logIn(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            String email = this.username.getText();
            String pwd = this.password.getText();
            int auto = this.autoLogin.isSelected() ? 1 : 0;
            this.doLogin(email, pwd, auto);
        } else if (eventType.equals("MOUSE_ENTERED")) {
            UIController.updateNodeSytleClass((Node)this.login, "labelBtnEnter");
        } else if (eventType.equals("MOUSE_EXITED")) {
            UIController.updateNodeSytleClass((Node)this.login, "labelBtnNormal");
        } else if (eventType.equals("MOUSE_PRESSED")) {
            UIController.updateNodeSytleClass((Node)this.login, "labelBtnPress");
        }
    }

    @FXML
    public void FindPwd() {
        String url = "http://sso.testin.cn/ucenter.action?op=Password.retakePwd";
        TestinStage.getHostServices().showDocument(url);
    }

    @FXML
    public void keyTyped(KeyEvent e) {
        if (e.getCharacter().equals("\r")) {
            String email = this.username.getText();
            String pwd = this.password.getText();
            int auto = this.autoLogin.isSelected() ? 1 : 0;
            this.doLogin(email, pwd, auto);
        }
    }

    @FXML
    public void netSet(MouseEvent event) {
        NetDialog.show();
    }
}

