/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.common.Proxy;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.AlertDialog;
import com.testin.javafx.ui.control.DialogResponse;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.apache.commons.lang.StringUtils;

public class NetDialogController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Button btnYes;
    @FXML
    Button btnNo;
    @FXML
    TextField textNetHost;
    @FXML
    TextField textNetPort;
    @FXML
    TextField textNetUser;
    @FXML
    TextField textNetPassword;
    @FXML
    ComboBox<NetType> choiceNetType;
    @FXML
    AnchorPane netDialog;
    private DialogResponse response = new DialogResponse();
    private Stage stage;

    public DialogResponse getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = TestinStage.getStylesheet();
        this.netDialog.getStylesheets().add((Object)css);
        this.initChoiceItems();
        this.initDatas();
    }

    private void initChoiceItems() {
        this.choiceNetType.getItems().add((Object)new NetType(0, Main.getInternationalString("netset.item.proxy.no")));
        this.choiceNetType.getItems().add((Object)new NetType(1, Main.getInternationalString("netset.item.proxy.http")));
        this.choiceNetType.getItems().add((Object)new NetType(2, "\u4f7f\u7528\u6d4f\u89c8\u5668\u4ee3\u7406"));
        this.choiceNetType.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NetType>(){

            public void changed(ObservableValue<? extends NetType> observable, NetType oldValue, NetType newValue) {
                if (newValue.id == 0) {
                    NetDialogController.this.textNetHost.setDisable(true);
                    NetDialogController.this.textNetPort.setDisable(true);
                    NetDialogController.this.textNetUser.setDisable(true);
                    NetDialogController.this.textNetPassword.setDisable(true);
                } else if (newValue.id == 1) {
                    NetDialogController.this.textNetHost.setDisable(false);
                    NetDialogController.this.textNetPort.setDisable(false);
                    NetDialogController.this.textNetUser.setDisable(false);
                    NetDialogController.this.textNetPassword.setDisable(false);
                } else if (newValue.id == 2) {
                    NetDialogController.this.textNetHost.setDisable(true);
                    NetDialogController.this.textNetHost.setText("");
                    NetDialogController.this.textNetPort.setDisable(true);
                    NetDialogController.this.textNetPort.setText("0");
                    NetDialogController.this.textNetUser.setEditable(true);
                    NetDialogController.this.textNetPassword.setEditable(true);
                }
            }
        });
    }

    private void initDatas() {
        if (Proxy.proxyType == 0) {
            this.choiceNetType.getSelectionModel().select(0);
            this.textNetHost.setText(Proxy.proxyHost);
            this.textNetPort.setText(String.valueOf(Proxy.proxyPort));
            this.textNetUser.setText(Proxy.proxyUser);
            this.textNetPassword.setText(Proxy.proxyPassword);
        } else if (Proxy.proxyType == 1) {
            this.choiceNetType.getSelectionModel().select(1);
            this.textNetHost.setText(Proxy.proxyHost);
            this.textNetPort.setText(String.valueOf(Proxy.proxyPort));
            this.textNetUser.setText(Proxy.proxyUser);
            this.textNetPassword.setText(Proxy.proxyPassword);
        } else if (Proxy.proxyType == 2) {
            this.choiceNetType.getSelectionModel().select(2);
            this.textNetUser.setText(Proxy.proxyUser);
            this.textNetPassword.setText(Proxy.proxyPassword);
        }
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void show() {
        if (this.stage == null) {
            return;
        }
        this.stage.show();
    }

    public void close() {
        if (this.stage == null) {
            return;
        }
        this.stage.close();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void clickBtnYes(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        NetType netType = (NetType)this.choiceNetType.getSelectionModel().getSelectedItem();
        if (netType.id == 1) {
            if (StringUtils.isEmpty((String)this.textNetHost.getText())) {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("netset.error.addr"));
                return;
            }
            if (StringUtils.isEmpty((String)this.textNetPort.getText())) {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("netset.error.port.str"));
                return;
            }
            if (!StringUtils.isNumeric((String)this.textNetPort.getText())) {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("netset.error.port.num"));
                return;
            }
            Proxy.proxyType = netType.id;
            Proxy.proxyHost = this.textNetHost.getText().trim();
            Proxy.proxyPort = Integer.parseInt(this.textNetPort.getText().trim());
            Proxy.proxyUser = this.textNetUser.getText().trim();
            Proxy.proxyPassword = this.textNetPassword.getText().trim();
            Proxy.save();
        } else if (netType.id == 2) {
            Proxy.proxyType = netType.id;
            Proxy.proxyUser = this.textNetUser.getText().trim();
            Proxy.proxyPassword = this.textNetPassword.getText().trim();
            Proxy.save();
        } else {
            Proxy.proxyType = 0;
            Proxy.proxyHost = this.textNetHost.getText().trim();
            Proxy.proxyPort = Integer.parseInt(this.textNetPort.getText().trim());
            Proxy.proxyUser = this.textNetUser.getText().trim();
            Proxy.proxyPassword = this.textNetPassword.getText().trim();
            Proxy.save();
        }
        this.response.option = DialogResponse.Options.OK;
        this.stage.close();
    }

    @FXML
    public void clickBtnNo(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.CLOSED;
        this.stage.close();
    }

    class NetType {
        int id;
        String name;

        public NetType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

