/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.business.BizUtils;
import com.testin.itestin.business.KeyStore;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.device.tools.ApkParser;
import com.testin.itestin.device.tools.ApkTool;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.os.Message;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.DefaultPath;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.SignChooseDialog;
import com.testin.javafx.ui.control.AlertDialog;
import com.testin.javafx.ui.control.DetailsDialog;
import com.testin.javafx.ui.control.DialogResponse;
import com.testin.javafx.ui.control.ProgressDialog;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class RecordSetController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(RecordSetController.class);
    @FXML
    AnchorPane recordSetPage;
    @FXML
    TextField ApkPath;
    @FXML
    CheckBox signed;
    @FXML
    CheckBox shot;
    @FXML
    CheckBox chkReinstall;
    @FXML
    ImageView imgRecord;
    @FXML
    Label next;
    @FXML
    Label chooseApk;
    @FXML
    AnchorPane recordStyle;
    @FXML
    AnchorPane coordRecordStyle;
    @FXML
    Label circle1;
    @FXML
    Label circle2;
    @FXML
    Label circle3;
    @FXML
    Label circle4;
    private String originapkPath;
    private ApplicationInfo appInfo;
    private File of = null;
    private int recType;
    private String message = Main.getInternationalString("recordsetcontroller.mssage");
    private KeyStore keyStore;
    Thread startRecording = new Thread("RecorderStarter"){

        @Override
        public void run() {
            ProgressDialog progressDialog = new ProgressDialog(ProgressDialog.DialogOptions.NONE);
            progressDialog.show();
            progressDialog.setMessage(RecordSetController.this.message);
            RecordSetController.this.appInfo = new ApkParser().parse(RecordSetController.this.originapkPath);
            if (BizUtils.isMalfunctionApk(RecordSetController.this.appInfo)) {
                progressDialog.close();
                return;
            }
            RecordSetController.this.constructOneSingleTestCase(RecordSetController.this.appInfo);
            boolean res = false;
            progressDialog.setProgressValue(10);
            String rootPath = TestFileUtils.getTestRootDir();
            BizUtils.handleWorkFolder(rootPath, RecordSetController.this.appInfo.getMd5());
            BizUtils.copyIcon(rootPath, RecordSetController.this.appInfo);
            BizUtils.saveAppInfo(rootPath, RecordSetController.this.appInfo);
            progressDialog.setProgressValue(20);
            Message msg = BizUtils.copyApp(rootPath, RecordSetController.this.appInfo);
            progressDialog.setProgressValue(40);
            boolean bl = res = msg.getStatus() == 0;
            if (RecordSetController.this.recType == 0 && res) {
                msg = RecordSetController.this.resignApkFiles(rootPath, progressDialog);
            }
            progressDialog.setProgressValue(100);
            progressDialog.close();
            boolean bl2 = res = msg.getStatus() == 0;
            if (res) {
                SingleTestCase.getInstance().setRunType(0);
                TestinStage.gotoRecord();
                UIController.cleenScreens();
            } else {
                DetailsDialog.show(Main.getInternationalString("recordsetcontroller.threadHandler.preparefailure"), msg.getContent());
            }
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    public void chooseApkClick(MouseEvent event) throws IOException {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            File f;
            UIController.updateNodeSytleClass((Node)this.chooseApk, "labelBtnPress");
            FileChooser chooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("apk files (*.apk)", new String[]{"*.apk"});
            chooser.getExtensionFilters().add((Object)extFilter);
            if (this.of != null) {
                if (this.of.exists()) {
                    chooser.setInitialDirectory(this.of);
                }
            } else {
                this.of = DefaultPath.getPathFile("apkPath");
                if (this.of != null && this.of.exists()) {
                    chooser.setInitialDirectory(this.of);
                }
            }
            if ((f = chooser.showOpenDialog(null)) != null) {
                this.of = f.getParentFile();
                DefaultPath.savePathFile("apkPath", this.of.toString());
                this.ApkPath.setText(f.getPath());
                this.originapkPath = f.getPath();
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            UIController.updateNodeSytleClass((Node)this.chooseApk, "labelBtnEnter");
        } else if (eventType.equals("MOUSE_EXITED")) {
            UIController.updateNodeSytleClass((Node)this.chooseApk, "labelBtnNormal");
        } else if (eventType.equals("MOUSE_PRESSED")) {
            UIController.updateNodeSytleClass((Node)this.chooseApk, "labelBtnPress");
        }
    }

    @FXML
    public void nextClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (DevicesManager.getDevice() != null) {
                UIController.updateNodeSytleClass((Node)this.next, "labelBtnPress");
                this.originapkPath = this.ApkPath.getText();
                if (this.originapkPath == null || !new File(this.originapkPath).exists()) {
                    return;
                }
                ThreadPool.execute(this.startRecording);
            } else {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("recordsetcontorller.nextClick.nodevice"));
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            UIController.updateNodeSytleClass((Node)this.next, "labelBtnEnter");
        } else if (eventType.equals("MOUSE_EXITED")) {
            UIController.updateNodeSytleClass((Node)this.next, "labelBtnNormal");
        } else if (eventType.equals("MOUSE_PRESSED")) {
            UIController.updateNodeSytleClass((Node)this.next, "labelBtnPress");
        }
    }

    private Message resignApkFiles(String rootPath, ProgressDialog progressDialog) {
        PrintWriter printWriter;
        StringWriter stringWriter;
        KeyStore localKeyStore;
        Message msg = new Message();
        if (this.keyStore != null && this.signed.isSelected()) {
            try {
                StringBuffer buff = new StringBuffer();
                buff.append("alias=" + this.keyStore.getAlias() + "\r\n");
                buff.append("storepass=" + this.keyStore.getStorepass() + "\r\n");
                buff.append("aliaspass=" + this.keyStore.getKeypass() + "\r\n");
                File f = new File(TestFileUtils.getKeystoreInfoPath(rootPath));
                FileUtils.write((File)f, (CharSequence)buff.toString());
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                String local = TestFileUtils.getKeystorePath(rootPath);
                File sec = new File(this.keyStore.getKeystore());
                File f = new File(local);
                if (!f.exists()) {
                    FileUtils.copyFile((File)sec, (File)f);
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        KeyStore tmp = (localKeyStore = TestFileUtils.getKeystore(rootPath)) == null ? ApkTool.TestinKeyStore : localKeyStore;
        try {
            msg = BizUtils.resignMainApk(rootPath, this.appInfo, tmp);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            msg.setStatus(20);
            msg.setContent(stringWriter.getBuffer().toString());
        }
        progressDialog.setProgressValue(60);
        if (msg.getStatus() == 0) {
            try {
                msg = this.resignRecordApk(rootPath, this.appInfo, tmp);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                stringWriter = new StringWriter();
                printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                msg.setStatus(20);
                msg.setContent(stringWriter.getBuffer().toString());
            }
            progressDialog.setProgressValue(90);
        }
        return msg;
    }

    private void constructOneSingleTestCase(ApplicationInfo appInfo) {
        BizUtils.parseApplicationToSTC(appInfo);
        SingleTestCase.getInstance().setRecordStyle(this.recType);
        SingleTestCase.getInstance().setRunResult("0");
        SingleTestCase.getInstance().setAutoShot(this.shot.isSelected());
        SingleTestCase.getInstance().setSettingUninstall(this.chkReinstall.isSelected());
        SingleTestCase.getInstance().setResignSelected(this.signed.isSelected());
        SingleTestCase.getInstance().setEditing(false);
        SingleTestCase.getInstance().setRecording(false);
        SingleTestCase.getInstance().setSaved(false);
        SingleTestCase.getInstance().setName(null);
        SingleTestCase.getInstance().setRunType(0);
    }

    @FXML
    public void signedChecked() {
        if (this.signed.isSelected()) {
            DialogResponse response = SignChooseDialog.show(this.keyStore);
            if (response.option == DialogResponse.Options.OK) {
                this.keyStore = response.keyStore;
            } else {
                this.signed.setSelected(false);
            }
        }
    }

    private Message resignRecordApk(String rootPath, ApplicationInfo appInfo, KeyStore keyStore) throws Exception {
        String recordPath = TestFileUtils.getAppRecordPath(rootPath);
        File f = new File(recordPath);
        if (f.exists()) {
            FileUtils.deleteQuietly((File)f);
        }
        ApkTool tool = new ApkTool();
        Message msg = tool.resignTestinRecordApk(appInfo.getPackageName(), recordPath, keyStore);
        return msg;
    }

    @FXML
    public void endEnter() {
        this.next.setTextFill((Paint)Color.BLUE);
    }

    @FXML
    public void endExit() {
        this.next.setTextFill((Paint)Color.BLACK);
    }

    @FXML
    public void recordStyleClick(MouseEvent event) {
        this.recType = 0;
        this.signed.disableProperty().set(false);
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            UIController.updateNodeSytleClass((Node)this.recordStyle, "paneRecordSelect");
            UIController.updateNodeSytleClass((Node)this.coordRecordStyle, "paneRecord");
        }
    }

    @FXML
    public void coordRecordStyleClick(MouseEvent event) {
        this.recType = 1;
        this.signed.disableProperty().set(true);
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            UIController.updateNodeSytleClass((Node)this.coordRecordStyle, "paneRecordSelect");
            UIController.updateNodeSytleClass((Node)this.recordStyle, "paneRecord");
        }
    }

    @FXML
    public void recordStyleEnter() {
    }

    @FXML
    public void coordRecordStyleEnter(MouseEvent event) {
    }
}

