/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.alibaba.fastjson.JSONObject;
import com.testin.itestin.business.BizUtils;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.UploadScript;
import com.testin.itestin.business.actions.TestAction;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.common.Constants;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.entitys.UserInfo;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.service.LoginService;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.ZipUtil;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.CloudSelect;
import com.testin.javafx.ui.apk.CopyScriptManager;
import com.testin.javafx.ui.control.AlertDialog;
import com.testin.javafx.ui.control.ConfirmDialog;
import com.testin.javafx.ui.control.DialogResponse;
import com.testin.javafx.ui.control.FolderSelectDialog;
import com.testin.javafx.ui.control.InputDialog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Cursor;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ScriptManageController
extends AnchorPane
implements Initializable,
UploadScript.UploadCallback {
    static Logger log = Logger.getLogger(ScriptManageController.class);
    @FXML
    AnchorPane scriptManagePage;
    @FXML
    Label apkname;
    @FXML
    Label backtofolder;
    @FXML
    private TableView<ScriptManage> tableview;
    private static String userPassStr;
    private static ScriptManageController smc;
    private static String caseName;
    private String apkFolderName;
    private String apkName;
    private String version;
    private List<Label> listSubmit = new ArrayList<Label>();

    static {
        smc = new ScriptManageController();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getApkName() {
        return this.apkName;
    }

    public void setApkNameAndVersion(String apkName, String version) {
        this.apkName = apkName;
        if (version != null && !"".equals(version)) {
            this.version = version;
            this.apkname.setText(">> " + apkName + " " + version);
        } else {
            this.apkname.setText(">> " + apkName);
            this.version = "null";
        }
    }

    public String getApkFolderName() {
        return this.apkFolderName;
    }

    public void setApkFolderName(String apkFolderName) {
        this.apkFolderName = apkFolderName;
    }

    public String getCaseName() {
        return caseName;
    }

    public static ScriptManageController getInstance() {
        return smc;
    }

    public String getUserPassStr() {
        return userPassStr;
    }

    @FXML
    public void backToApkFolder() {
        TestinStage.gotoScriptTilesManage();
    }

    private TableColumn<String, String> createTableColumn(double width, String show, String data) {
        TableColumn col = new TableColumn(show);
        col.setResizable(false);
        col.setSortable(false);
        col.setPrefWidth(width);
        col.setCellValueFactory((Callback)new PropertyValueFactory(data));
        return col;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Object[] columns = new TableColumn[]{this.createTableColumn(100.0, Main.getInternationalString("scriptmanagercontroller.initialize.columntext1"), "scriptName"), this.createTableColumn(100.0, Main.getInternationalString("scriptmanagercontroller.initialize.columntext2"), "appName"), this.createTableColumn(120.0, Main.getInternationalString("scriptmanagercontroller.initialize.columntext3"), "recordStyle"), this.createTableColumn(150.0, Main.getInternationalString("scriptmanagercontroller.initialize.columntext4"), "createTime"), this.createTableColumn(100.0, Main.getInternationalString("scriptmanagercontroller.initialize.columntext5"), "runResult"), this.createTableColumn(100.0, Main.getInternationalString("scriptmanagercontroller.initialize.columntext6"), "clundTest"), this.createTableColumn(192.0, Main.getInternationalString("scriptmanagercontroller.initialize.columntext7"), "op")};
        this.tableview.getColumns().setAll(columns);
        this.tableview.getColumns().addListener((ListChangeListener)new ListChangeListener<Object>((TableColumn[])columns){
            public boolean suspended = true;
            private final /* synthetic */ TableColumn[] val$columns;
            {
                this.val$columns = tableColumnArray;
            }

            public void onChanged(ListChangeListener.Change<?> change) {
                change.next();
                if (change.wasReplaced() && this.suspended) {
                    this.suspended = false;
                    ScriptManageController.this.tableview.getColumns().setAll((Object[])this.val$columns);
                    this.suspended = true;
                }
            }
        });
        this.tableview.setEditable(false);
        this.tableview.setRowFactory((Callback)new Callback<TableView<ScriptManage>, TableRow<ScriptManage>>(){

            public TableRow<ScriptManage> call(TableView<ScriptManage> arg0) {
                final TableRow row = new TableRow();
                row.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        ScriptManage sm;
                        if (event.getClickCount() == 2 && (sm = (ScriptManage)row.getItem()).isScript) {
                            ScriptManageController.this.changeScriptName(sm);
                        }
                    }
                });
                return row;
            }
        });
    }

    private void changeScriptName(ScriptManage sm) {
        DialogResponse response = InputDialog.show(Main.getInternationalString("scriptmanagecontroller.changeScript.name.text"), sm.getScriptName());
        String name = response.value;
        if (response.option == DialogResponse.Options.OK && !sm.getScriptName().equals(response.value)) {
            if (this.isInvalidScriptName(name)) {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptmanagecontroller.changeScript.name.text.invalid"));
                this.changeScriptName(sm);
                return;
            }
            if (this.isFolderExisted(sm, name)) {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptmanagecontroller.changeScript.name.text.existed"));
                this.changeScriptName(sm);
                return;
            }
            try {
                String filePath = "";
                if (!"".equals(sm.getAppName())) {
                    filePath = String.valueOf(new File(sm.getScriptPath()).getParentFile().getParent()) + File.separator + name + "_dir";
                    new File(filePath).mkdirs();
                    FileUtils.copyFileToDirectory((File)new File(sm.getScriptPath()), (File)new File(filePath));
                    BizUtils.changeTestCaseName(name, filePath);
                    FileUtils.deleteDirectory((File)new File(sm.getScriptPath()).getParentFile());
                } else {
                    filePath = String.valueOf(new File(sm.getScriptPath()).getParent()) + File.separator + name + "_dir";
                    new File(filePath).mkdirs();
                    FileUtils.copyDirectory((File)new File(sm.getScriptPath()), (File)new File(filePath));
                    FileUtils.deleteDirectory((File)new File(sm.getScriptPath()));
                }
                this.loadScript();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isFolderExisted(ScriptManage sm, String name) {
        String fileName = "";
        fileName = !"".equals(sm.getAppName()) ? String.valueOf(new File(sm.getScriptPath()).getParentFile().getParent()) + File.separator + name + "_dir" : String.valueOf(new File(sm.getScriptPath()).getParent()) + File.separator + name + "_dir";
        return new File(fileName).exists();
    }

    private boolean isInvalidScriptName(String value) {
        String regex = "[\\\\|\\/|\\:|\\*|\\?|\\\"|\\<|\\>]";
        return Pattern.compile(regex).matcher(value).find();
    }

    private void setSingleTestCaseInfo(String spath, Element root, String casePath, boolean needActions) {
        NodeList subnodes;
        Element subnode;
        NodeList node;
        SingleTestCase.getInstance().setCasePath(casePath);
        String casename = root.getAttribute("name");
        SingleTestCase.getInstance().setName(casename);
        NodeList info = root.getElementsByTagName("Info");
        Element infonode = (Element)info.item(0);
        NodeList timenode = infonode.getElementsByTagName("createtime");
        SingleTestCase.getInstance().setCreateTime(timenode.item(0).getTextContent());
        NodeList stylenode = infonode.getElementsByTagName("recordtype");
        SingleTestCase.getInstance().setRecordStyle(Integer.parseInt(stylenode.item(0).getTextContent()));
        NodeList runnode = infonode.getElementsByTagName("runresult");
        SingleTestCase.getInstance().setRunResult(runnode.item(0).getTextContent());
        if (needActions && new File(spath).isFile() && (node = root.getElementsByTagName("TestActions")) != null && node.getLength() > 0 && (subnode = (Element)node.item(0)) != null && (subnodes = subnode.getElementsByTagName("TestAction")) != null) {
            SingleTestCase.getInstance().removeAllAction();
            int i = 0;
            while (i < subnodes.getLength()) {
                Node n = subnodes.item(i);
                NamedNodeMap attributes = n.getAttributes();
                String expr = attributes.getNamedItem("expr").getNodeValue();
                TestAction ac = TestAction.newInstance(expr);
                SingleTestCase.getInstance().addTestAction(ac);
                ++i;
            }
        }
    }

    private void createCase(final String spath, final ApplicationInfo appInfo) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(new File(spath));
            final Element root = doc.getDocumentElement();
            String casename = root.getAttribute("name");
            NodeList info = root.getElementsByTagName("Info");
            Element infonode = (Element)info.item(0);
            String scriptPath = DirectoryService.getScriptDir();
            final String casePath = "script" + spath.substring(scriptPath.length(), spath.length() - "testCase.xml".length());
            Label open = new Label(Main.getInternationalString("scriptmanagercontroller.createcase.open"));
            open.setCursor(Cursor.HAND);
            open.setTextFill((Paint)Color.BLUE);
            open.underlineProperty().set(true);
            open.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    BizUtils.parseApplicationToSTC(appInfo);
                    ScriptManageController.this.setSingleTestCaseInfo(spath, root, casePath, true);
                    SingleTestCase.getInstance().setRunType(1);
                    SingleTestCase.getInstance().setCoordScriptPath(null);
                    SingleTestCase.getInstance().setAutoShot(false);
                    SingleTestCase.getInstance().setUninstallInReplay(false);
                    TestinStage.gotoRecord();
                    if (UIController.getScriptShowHandler() != null) {
                        Message m = new Message();
                        m.setStatus(1282);
                        UIController.getScriptShowHandler().sendMessage(m);
                    }
                }
            });
            open.maxWidth(15.0);
            Label copy = new Label(Main.getInternationalString("scriptmanagercontroller.createcase.copy"));
            copy.setCursor(Cursor.HAND);
            copy.setTextFill((Paint)Color.BLUE);
            copy.underlineProperty().set(true);
            copy.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    BizUtils.parseApplicationToSTC(appInfo);
                    ScriptManageController.this.setSingleTestCaseInfo(spath, root, casePath, true);
                    SingleTestCase.getInstance().setResignSelected(false);
                    CopyScriptManager.show();
                }
            });
            copy.maxWidth(15.0);
            Label del = new Label(Main.getInternationalString("scriptmanagercontroller.createcase.delete"));
            del.setCursor(Cursor.HAND);
            del.setTextFill((Paint)Color.BLUE);
            del.underlineProperty().set(true);
            del.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    DialogResponse confirm = ConfirmDialog.show(Main.getInternationalString("scriptmanagercontroller.createscript.isdelscript"), null);
                    if (confirm.option == DialogResponse.Options.OK) {
                        ScriptManageController.this.tableview.getItems().remove(ScriptManageController.this.tableview.getSelectionModel().getSelectedIndex());
                        try {
                            FileUtils.deleteDirectory((File)new File(casePath));
                        }
                        catch (IOException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    } else {
                        return;
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ScriptManageController.this.loadScript();
                        }
                    });
                }
            });
            del.maxWidth(15.0);
            Label export = new Label(Main.getInternationalString("scriptmanagecontroller.export.text"));
            String State2 = infonode.getElementsByTagName("runresult").item(0).getTextContent();
            if (!State2.equals("1")) {
                export.disableProperty().set(true);
            }
            export.setCursor(Cursor.HAND);
            export.setTextFill((Paint)Color.BLUE);
            export.underlineProperty().set(true);
            export.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    DialogResponse response = FolderSelectDialog.show();
                    if (response.option == DialogResponse.Options.OK) {
                        File f = new File(response.value);
                        if (!f.exists()) {
                            AlertDialog.show(AlertDialog.DialogOptions.INFO, Main.getInternationalString("folderselectdialogcontroller.selectClick.nodirectory"));
                            return;
                        }
                        ScriptManageController.this.export(casePath, response.value);
                    }
                }
            });
            export.maxWidth(15.0);
            AnchorPane pane = new AnchorPane();
            FXCollections.observableArrayList();
            pane.maxWidth(130.0);
            pane.getChildren().add((Object)open);
            open.setLayoutX(20.0);
            open.setLayoutY(4.0);
            pane.getChildren().add((Object)copy);
            copy.setLayoutX(60.0);
            copy.setLayoutY(4.0);
            pane.getChildren().add((Object)del);
            del.setLayoutX(100.0);
            del.setLayoutY(4.0);
            pane.getChildren().add((Object)export);
            export.setLayoutX(140.0);
            export.setLayoutY(4.0);
            Date date = new Date();
            try {
                date = new Date(Long.parseLong(infonode.getElementsByTagName("createtime").item(0).getTextContent()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = sdf.format(date);
            String style = infonode.getElementsByTagName("recordtype").item(0).getTextContent().equals("0") ? Main.getInternationalString("scriptmanagercontroller.createcase.controllerrecord") : Main.getInternationalString("scriptmanagercontroller.createcase.pointrecord");
            AnchorPane linkPane = new AnchorPane();
            Label link = new Label();
            String runState = infonode.getElementsByTagName("runresult").item(0).getTextContent();
            if (runState.equals("0")) {
                runState = Main.getInternationalString("scriptmanagercontroller.createcase.runstate1");
                link.disableProperty().set(true);
            } else if (runState.equals("1")) {
                runState = Main.getInternationalString("scriptmanagercontroller.createcase.runstate2");
            } else if (runState.equals("2")) {
                runState = Main.getInternationalString("scriptmanagercontroller.createcase.runstate3");
                link.disableProperty().set(true);
            }
            link.setText(Main.getInternationalString("scriptmanagercontroller.createcase.submit"));
            link.setCursor(Cursor.HAND);
            link.setTextFill((Paint)Color.BLUE);
            link.underlineProperty().set(true);
            link.setLayoutY(4.0);
            link.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    Thread t = new Thread("StartRunOnCloud"){

                        @Override
                        public void run() {
                            LoginService loginService = LoginService.getInstance();
                            UserInfo user = loginService.getDefaultUser();
                            String email = user.getEmail();
                            String pwd = user.getPassword();
                            if (email.equals(Constants.TEST_USER_NAME) && pwd.equals(Constants.TEST_USER_PASSWORD)) {
                                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptmanagecontroller.submit.testaccount"));
                            } else {
                                boolean res = true;
                                DialogResponse response = CloudSelect.show(true);
                                if (response.option == DialogResponse.Options.OK && (res = ScriptManageController.this.genUPJson(response.value2))) {
                                    UploadScript.upload(ScriptManageController.this);
                                }
                            }
                        }
                    };
                    ThreadPool.execute(t);
                }
            });
            linkPane.getChildren().add((Object)link);
            linkPane.setMaxWidth(100.0);
            if (link.disabledProperty().get()) {
                Label lb = new Label();
                lb.setPrefWidth(50.0);
                lb.setTooltip(new Tooltip(Main.getInternationalString("scriptmanagecontroller.submit.tooltip")));
                linkPane.getChildren().add((Object)lb);
            }
            ScriptManage tt = new ScriptManage(casename, appInfo.getAppName(), style, createTime, runState, linkPane, pane, true, spath);
            this.tableview.getItems().add((Object)tt);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void export(String casePath, String dir) {
        File f1 = new File(casePath);
        String replayPath = String.valueOf(casePath) + File.separator + "replay.apk";
        String testtypeIni = String.valueOf(casePath) + File.separator + "testtype.ini";
        String targetZipFile = String.valueOf(dir) + File.separator + f1.getName() + ".zip";
        ScriptManageController.newIni(testtypeIni, "11");
        File[] zipFiles = new File[]{new File(replayPath), new File(testtypeIni)};
        try {
            ZipUtil.compressedFiles(zipFiles, targetZipFile);
            File tf = new File(targetZipFile);
            if (tf.exists()) {
                AlertDialog.show(AlertDialog.DialogOptions.INFO, Main.getInternationalString("scriptmanagecontroller.exportsuccess.text"));
            } else {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptmanagecontroller.exportfailure.text"));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static boolean newIni(String path, String text) {
        boolean b = false;
        try {
            File f = new File(path);
            if (f.exists()) {
                f.delete();
            }
            if (StringUtils.isNotEmpty((String)text)) {
                FileUtils.writeStringToFile((File)f, (String)text);
            } else {
                FileUtils.writeStringToFile((File)f, (String)"");
            }
            b = true;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return b;
    }

    private boolean genUPJson(String path) {
        boolean res = true;
        if (path.isEmpty()) {
            return res;
        }
        String jarray = "";
        File f = new File(path);
        if (!f.exists()) {
            AlertDialog.show(AlertDialog.DialogOptions.INFO, Main.getInternationalString("scriptmanagecontroller.submit.accountfilenull"));
            res = false;
            return res;
        }
        try {
            String dat = FileUtils.readFileToString((File)f, (String)"utf-8");
            String[] lines = dat.split("\r\n");
            int i = 0;
            while (i < lines.length) {
                if (!lines[i].contains("|")) {
                    AlertDialog.show(AlertDialog.DialogOptions.INFO, Main.getInternationalString("scriptmanagecontroller.genupjson.accounterror"));
                    res = false;
                    return res;
                }
                String temp = lines[i].replace("|", ":");
                temp = i == lines.length - 1 ? "{" + temp + "}" : "{" + temp + "},";
                jarray = String.valueOf(jarray) + temp;
                ++i;
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        jarray = "[" + jarray + "]";
        Base64 base64 = new Base64(2048);
        byte[] data = base64.encode(jarray.getBytes());
        userPassStr = new String(data);
        userPassStr = userPassStr.replaceAll("\r", "").replaceAll("\n", "");
        return res;
    }

    private void createScript(final String Path2, final ApplicationInfo appInfo) {
        File[] ff;
        String scriptName = new File(Path2).getName();
        AnchorPane linkPane = new AnchorPane();
        final Label linksubmit = new Label();
        if (scriptName.contains("_dir")) {
            String path = this.getLastRunState(Path2);
            if (path == null) {
                linksubmit.disableProperty().set(true);
            }
            linksubmit.setText(Main.getInternationalString("scriptmanagercontroller.createcase.submit"));
            linksubmit.setCursor(Cursor.HAND);
            linksubmit.setTextFill((Paint)Color.BLUE);
            linksubmit.underlineProperty().set(true);
            linksubmit.setUserData((Object)path);
            linksubmit.setLayoutY(4.0);
            linksubmit.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    Thread t = new Thread("CreateCase.Submit"){

                        @Override
                        public void run() {
                            if (ScriptManageController.this.listSubmit.contains(linksubmit)) {
                                DialogResponse response = ConfirmDialog.show(Main.getInternationalString("scriptmanagercontroller.creatscript.scriptsubmit"), "");
                                if (response.option == DialogResponse.Options.CANCEL) {
                                    return;
                                }
                            }
                            LoginService loginService = LoginService.getInstance();
                            UserInfo user = loginService.getDefaultUser();
                            String email = user.getEmail();
                            String pwd = user.getPassword();
                            if (email.equals(Constants.TEST_USER_NAME) && pwd.equals(Constants.TEST_USER_PASSWORD)) {
                                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptmanagecontroller.submit.testaccount"));
                            } else {
                                boolean res = true;
                                DialogResponse response = CloudSelect.show(true);
                                if (response.option == DialogResponse.Options.OK && (res = ScriptManageController.this.genUPJson(response.value2))) {
                                    UploadScript.upload(Path2, ScriptManageController.this);
                                }
                            }
                        }
                    };
                    ThreadPool.execute(t);
                }
            });
            linkPane.getChildren().add((Object)linksubmit);
            linkPane.setMaxWidth(100.0);
            if (linksubmit.disabledProperty().get()) {
                Label lb = new Label();
                lb.setPrefWidth(50.0);
                lb.setTooltip(new Tooltip(Main.getInternationalString("scriptmanagecontroller.submit.tooltip")));
                linkPane.getChildren().add((Object)lb);
            }
            Label export = new Label(Main.getInternationalString("scriptmanagecontroller.export.text"));
            String state = this.getLastRunState(Path2);
            if (state == null) {
                export.disableProperty().set(true);
            }
            export.setCursor(Cursor.HAND);
            export.setTextFill((Paint)Color.BLUE);
            export.underlineProperty().set(true);
            export.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    DialogResponse response = FolderSelectDialog.show();
                    if (response.option == DialogResponse.Options.OK) {
                        File f = new File(response.value);
                        if (!f.exists()) {
                            AlertDialog.show(AlertDialog.DialogOptions.INFO, Main.getInternationalString("scriptmanagecontroller.submit.accountfilenull"));
                            return;
                        }
                        ScriptManageController.this.CoordExport(Path2, response.value);
                    }
                }
            });
            export.maxWidth(15.0);
            AnchorPane aPane = new AnchorPane();
            FXCollections.observableArrayList();
            aPane.maxWidth(130.0);
            aPane.getChildren().add((Object)export);
            export.setLayoutX(140.0);
            export.setLayoutY(4.0);
            scriptName = scriptName.substring(0, scriptName.lastIndexOf("_"));
            ScriptManage t = new ScriptManage(scriptName, "", "", "", "", linkPane, aPane, true, Path2);
            this.tableview.getItems().add((Object)t);
        }
        File[] fileArray = ff = TestFileUtils.getFilterList(Path2, ".script");
        int n = ff.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String appName = "";
            String runState = "";
            Date date = new Date(f.lastModified());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = sdf.format(date);
            String fileName = f.getName();
            String[] lists = fileName.split("\\.");
            if (lists.length > 0) {
                String[] list = lists[0].split("_");
                if (list.length > 1) {
                    appName = list[1];
                    runState = list[2];
                }
                fileName = list[0];
            }
            final String path = f.getPath();
            Label open = new Label(Main.getInternationalString("scriptmanagercontroller.createcase.open"));
            open.setCursor(Cursor.HAND);
            open.setTextFill((Paint)Color.BLUE);
            open.underlineProperty().set(true);
            open.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    BizUtils.parseApplicationToSTC(appInfo);
                    SingleTestCase.getInstance().setCoordScriptPath(path);
                    SingleTestCase.getInstance().setRecordStyle(1);
                    SingleTestCase.getInstance().setName(ScriptManageController.this.getNameFromScriptPath(path));
                    SingleTestCase.getInstance().setRunType(1);
                    SingleTestCase.getInstance().setCoordPixel(SingleTestCase.getInstance().getPixelByScriptPath());
                    SingleTestCase.getInstance().setAutoShot(false);
                    SingleTestCase.getInstance().setUninstallInReplay(false);
                    TestinStage.gotoRecord();
                    if (UIController.getCoordscriptShowHandler() != null) {
                        Message m = new Message();
                        m.setStatus(1282);
                        UIController.getCoordscriptShowHandler().sendMessage(m);
                    }
                }
            });
            open.maxWidth(15.0);
            Label copy = new Label(Main.getInternationalString("scriptmanagercontroller.createcase.copy"));
            copy.setCursor(Cursor.HAND);
            copy.setTextFill((Paint)Color.BLUE);
            copy.underlineProperty().set(true);
            copy.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    BizUtils.parseApplicationToSTC(appInfo);
                    SingleTestCase.getInstance().setCoordScriptPath(path);
                    SingleTestCase.getInstance().setRecordStyle(1);
                    SingleTestCase.getInstance().setName(ScriptManageController.this.getNameFromScriptPath(path));
                    SingleTestCase.getInstance().setCasePath(null);
                    SingleTestCase.getInstance().removeAllAction();
                    SingleTestCase.getInstance().setResignSelected(false);
                    CopyScriptManager.show();
                }
            });
            copy.maxWidth(15.0);
            Label del = new Label(Main.getInternationalString("scriptmanagercontroller.createcase.delete"));
            del.setUserData((Object)path);
            del.setCursor(Cursor.HAND);
            del.setTextFill((Paint)Color.BLUE);
            del.underlineProperty().set(true);
            del.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    Label label = (Label)event.getSource();
                    DialogResponse confirm = ConfirmDialog.show(Main.getInternationalString("scriptmanagercontroller.createscript.isdelscript"), null);
                    if (confirm.option == DialogResponse.Options.OK) {
                        ScriptManageController.this.tableview.getItems().remove(ScriptManageController.this.tableview.getSelectionModel().getSelectedIndex());
                        String scriptPath = (String)label.getUserData();
                        String parent = new File(scriptPath).getParent();
                        File[] scripts = TestFileUtils.getFilterList(parent, ".script");
                        if (scripts.length == 1) {
                            try {
                                FileUtils.deleteDirectory((File)new File(parent));
                            }
                            catch (IOException e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        } else {
                            new File(scriptPath).delete();
                        }
                    } else {
                        return;
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ScriptManageController.this.loadScript();
                        }
                    });
                }
            });
            del.maxWidth(15.0);
            AnchorPane pane = new AnchorPane();
            FXCollections.observableArrayList();
            pane.maxWidth(130.0);
            pane.getChildren().add((Object)open);
            open.setLayoutX(20.0);
            open.setLayoutY(4.0);
            pane.getChildren().add((Object)copy);
            copy.setLayoutX(60.0);
            copy.setLayoutY(4.0);
            pane.getChildren().add((Object)del);
            del.setLayoutX(100.0);
            del.setLayoutY(4.0);
            String style = Main.getInternationalString("scriptmanagercontroller.createcase.pointrecord");
            if (runState.equals("0")) {
                runState = Main.getInternationalString("scriptmanagercontroller.createcase.runstate1");
                this.listSubmit.add(linksubmit);
            } else if (runState.equals("1")) {
                runState = Main.getInternationalString("scriptmanagercontroller.createcase.runstate2");
            } else if (runState.equals("2")) {
                runState = Main.getInternationalString("scriptmanagercontroller.createcase.runstate3");
                this.listSubmit.add(linksubmit);
            }
            ScriptManage tt = new ScriptManage("    " + fileName, appName, style, createTime, runState, null, pane, false, null);
            this.tableview.getItems().add((Object)tt);
            ++n2;
        }
    }

    private String getNameFromScriptPath(String path) {
        String str = path.substring(0, path.lastIndexOf(File.separator));
        str = str.substring(str.lastIndexOf(File.separator) + 1);
        str = str.substring(0, str.length() - 4);
        return str;
    }

    private void CoordExport(String Path2, String dir) {
        boolean res;
        String casePath = Path2;
        File f1 = new File(casePath);
        String testtypeIni = String.valueOf(casePath) + File.separator + "testtype.ini";
        String targetZipFile = String.valueOf(dir) + File.separator + f1.getName() + ".zip";
        File[] scripts = f1.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("_1.script");
            }
        });
        boolean bl = res = scripts.length > 0;
        if (res) {
            res = ScriptManageController.newIni(testtypeIni, "10");
            File[] zipFiles = new File[scripts.length + 1];
            zipFiles[0] = new File(testtypeIni);
            try {
                String sdir = String.valueOf(DirectoryService.getTempDir()) + File.separator + "export";
                File fdir = new File(sdir);
                if (fdir.exists()) {
                    FileUtils.deleteDirectory((File)fdir);
                    fdir.mkdirs();
                } else {
                    fdir.mkdirs();
                }
                File[] scriptsFiles = new File[scripts.length];
                int i = 0;
                while (i < scripts.length) {
                    File destFile;
                    File sourFile = scripts[i];
                    String tmp = sourFile.getName().split("_")[0];
                    String destFileName = String.valueOf(tmp) + "_" + System.currentTimeMillis() + "_1.script";
                    String newPath = String.valueOf(sdir) + File.separator + destFileName;
                    ScriptManageController.Copy(sourFile, newPath);
                    scriptsFiles[i] = destFile = new File(newPath);
                    ++i;
                }
                System.arraycopy(scriptsFiles, 0, zipFiles, 1, scripts.length);
                ZipUtil.compressedFiles(zipFiles, targetZipFile);
                File tf = new File(targetZipFile);
                if (tf.exists()) {
                    AlertDialog.show(AlertDialog.DialogOptions.INFO, Main.getInternationalString("scriptmanagecontroller.exportsuccess.text"));
                } else {
                    AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptmanagecontroller.exportfailure.text"));
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void Copy(File oldfile, String newPath) {
        try {
            FileUtils.copyFile((File)oldfile, (File)new File(newPath));
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Vector<String> getScriptList() {
        Vector<String> v = new Vector<String>();
        String scriptPath = DirectoryService.getScriptDir();
        if (new File(scriptPath).listFiles().length > 0) {
            File[] files;
            File[] fileArray = files = TestFileUtils.getFilterList(scriptPath, "_dir");
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().startsWith(String.valueOf(this.getApkFolderName()) + "_" + this.getVersion()) && f.listFiles().length > 0) {
                    File[] ff;
                    File[] fileArray2 = ff = TestFileUtils.getFilterList(f.getPath(), "_dir");
                    int n3 = ff.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File script = fileArray2[n4];
                        File[] coords = TestFileUtils.getFilterList(script.getPath(), ".script");
                        File[] xml = TestFileUtils.getFilterList(script.getPath(), ".xml");
                        if (coords.length > 0) {
                            v.add(script.getPath());
                        } else if (xml.length > 0) {
                            v.add(String.valueOf(script.getPath()) + File.separator + "testCase.xml");
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return v;
    }

    public void loadScript() {
        this.listSubmit.clear();
        this.tableview.getItems().clear();
        Vector<String> v = this.getScriptList();
        if (v != null && v.size() > 0) {
            int i = 0;
            while (i < v.size()) {
                ApplicationInfo appInfo;
                if (v.get(i).endsWith("xml")) {
                    String rootPath = TestFileUtils.getTestRootDir(v.get(i));
                    appInfo = TestFileUtils.getAppInfo(rootPath);
                    this.createCase(v.get(i), appInfo);
                } else {
                    String rPath = v.get(i);
                    rPath = rPath.substring(0, rPath.lastIndexOf(File.separator));
                    appInfo = TestFileUtils.getAppInfo(rPath);
                    this.createScript(v.get(i), appInfo);
                }
                ++i;
            }
        }
        this.tableview.getItems().add((Object)new ScriptManage("", "", "", "", "", null, null, false, null));
    }

    private String getLastRunState(String path) {
        File[] files;
        File[] fileArray = files = new File(path).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".script");
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String s = f.getName().substring(f.getName().lastIndexOf("_") + 1, f.getName().lastIndexOf("_") + 2);
            int state = Integer.parseInt(s);
            if (state == 1) {
                return f.getPath();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void failed(int errorCode, String errorMsg) {
        AlertDialog.show(AlertDialog.DialogOptions.ERROR, errorMsg);
    }

    @Override
    public void succeeded(ApplicationInfo appInfo, String appUrl, String scriptUrl, String iconUrl) {
        TestinStage.gotoSubmitScript(appInfo, appUrl, scriptUrl, iconUrl);
    }

    public class ScriptManage {
        private String scriptName;
        private String appName;
        private String recordStyle;
        private String createTime;
        private String runResult;
        private AnchorPane clundTest;
        private AnchorPane op;
        private boolean isScript;
        private String scriptPath;

        public ScriptManage(String scriptName, String appName, String recordStyle, String createTime, String runResult, AnchorPane clundTest, AnchorPane op, boolean isScript, String scriptPath) {
            this.scriptName = scriptName;
            this.appName = appName;
            this.recordStyle = recordStyle;
            this.createTime = createTime;
            this.clundTest = clundTest;
            this.runResult = runResult;
            this.op = op;
            this.isScript = isScript;
            this.scriptPath = scriptPath;
        }

        public String getScriptName() {
            return this.scriptName;
        }

        public void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getRecordStyle() {
            return this.recordStyle;
        }

        public void setRecordStyle(String recordStyle) {
            this.recordStyle = recordStyle;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getRunResult() {
            return this.runResult;
        }

        public void setRunResult(String runResult) {
            this.runResult = runResult;
        }

        public AnchorPane getClundTest() {
            return this.clundTest;
        }

        public void setClundTest(AnchorPane clundTest) {
            this.clundTest = clundTest;
        }

        public AnchorPane getOp() {
            return this.op;
        }

        public void setOp(AnchorPane op) {
            this.op = op;
        }

        public boolean isScript() {
            return this.isScript;
        }

        public void setScript(boolean isScript) {
            this.isScript = isScript;
        }

        public String getScriptPath() {
            return this.scriptPath;
        }

        public void setScriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
        }

        public String toString() {
            JSONObject json = new JSONObject();
            json.put("ScriptName", (Object)this.getScriptName());
            json.put("appName", (Object)this.getAppName());
            json.put("time", (Object)this.getCreateTime());
            json.put("replayResult", (Object)this.getRunResult());
            json.put("recordStyle", (Object)this.getRecordStyle());
            json.put("isScript", (Object)this.isScript);
            json.put("path", (Object)this.getScriptPath());
            return json.toString();
        }
    }
}

