/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.service.DirectoryService;
import com.testin.javafx.ui.apk.ApkFolderController;
import com.testin.javafx.ui.apk.ApkFolderModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import org.apache.log4j.Logger;

public class ScriptTilesManageController
implements Initializable {
    static Logger log = Logger.getLogger(ScriptTilesManageController.class);
    @FXML
    AnchorPane scriptTilesManagePage;
    @FXML
    private TilePane tilepaneview;
    Vector<ApkFolderModel> afm = new Vector();

    public void initialize(URL location, ResourceBundle resources) {
        this.tilepaneview.setPrefColumns(4);
    }

    public void loadApkFolders() {
        this.afm.clear();
        this.afm = this.getApkFolderInfo();
        this.tilepaneview.getChildren().clear();
        for (ApkFolderModel a : this.afm) {
            VBox box = this.loadFxmlForApkFolder(a);
            this.tilepaneview.getChildren().add((Object)box);
        }
    }

    private VBox loadFxmlForApkFolder(ApkFolderModel am) {
        VBox page = new VBox();
        ApkFolderController controller = new ApkFolderController();
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/com/testin/javafx/ui/apk/ApkFolder.fxml"));
        fxmlLoader.setRoot((Object)controller.vboxholder);
        fxmlLoader.setController((Object)controller);
        try {
            page = (VBox)fxmlLoader.load();
            page.setSpacing(5.0);
            controller.setApkFolderModel(am);
            controller.updateView();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return page;
    }

    private Vector<ApkFolderModel> getApkFolderInfo() {
        Vector<ApkFolderModel> v = new Vector<ApkFolderModel>();
        String scriptPath = DirectoryService.getScriptDir();
        if (new File(scriptPath).listFiles().length > 0) {
            File[] files;
            File[] fileArray = files = TestFileUtils.getFilterList(scriptPath, "_dir");
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                ApplicationInfo info;
                File f = fileArray[n2];
                ApkFolderModel am = new ApkFolderModel();
                File icon = new File(String.valueOf(f.getPath()) + File.separator + "icon.png");
                if (icon.exists()) {
                    am.setIcon(icon.getAbsolutePath());
                }
                if ((info = TestFileUtils.getAppInfo(f.getPath())) != null) {
                    am.setPkgname(info.getPackageName());
                    am.setVersion(info.getVersionName() == null ? "" : info.getVersionName());
                    am.setStringProperty((StringProperty)new SimpleStringProperty(info.getAppName()));
                    am.setApkname(info.getAppName());
                    v.add(am);
                }
                ++n2;
            }
        }
        return v;
    }
}

