/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.business.KeyStore;
import com.testin.itestin.util.DefaultPath;
import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.AlertDialog;
import com.testin.javafx.ui.control.DialogResponse;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import org.apache.commons.lang.StringUtils;

public class SignChooseDialogController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Label chooseSign;
    @FXML
    Label save;
    @FXML
    TextField signFile;
    @FXML
    TextField alias;
    @FXML
    TextField stoppass;
    @FXML
    TextField aliaspass;
    @FXML
    AnchorPane SignChooseDialog;
    private static File sof = null;
    private DialogResponse response = new DialogResponse();
    private Stage stage;

    public DialogResponse getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void setValue(KeyStore keyStore) {
        if (this.stage == null) {
            return;
        }
        if (keyStore != null) {
            this.response.keyStore = keyStore;
            if (StringUtils.isNotEmpty((String)keyStore.getKeystore())) {
                this.signFile.setText(keyStore.getKeystore());
            }
            if (StringUtils.isNotEmpty((String)keyStore.getAlias())) {
                this.alias.setText(keyStore.getAlias());
            }
            if (StringUtils.isNotEmpty((String)keyStore.getStorepass())) {
                this.stoppass.setText(keyStore.getStorepass());
            }
            if (StringUtils.isNotEmpty((String)keyStore.getKeypass())) {
                this.aliaspass.setText(keyStore.getKeypass());
            }
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = TestinStage.getStylesheet();
        this.SignChooseDialog.getStylesheets().add((Object)css);
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void show() {
        if (this.stage == null) {
            return;
        }
        this.stage.show();
    }

    public void close() {
        if (this.stage == null) {
            return;
        }
        this.stage.close();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void save() {
        String fn = this.signFile.getText();
        if (StringUtils.isEmpty((String)fn)) {
            this.signFile.requestFocus();
            AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("signchoosedialogcontroller.save.selectsign"));
            return;
        }
        String fn1 = this.alias.getText();
        if (StringUtils.isEmpty((String)fn1)) {
            this.alias.requestFocus();
            AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("signchoosedialogcontroller.save.alias"));
            return;
        }
        String fn2 = this.stoppass.getText();
        if (StringUtils.isEmpty((String)fn2)) {
            this.stoppass.requestFocus();
            AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("signchoosedialogcontroller.save.stoppass"));
            return;
        }
        String fn3 = this.aliaspass.getText();
        if (StringUtils.isEmpty((String)fn3)) {
            this.aliaspass.requestFocus();
            AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("signchoosedialogcontroller.save.aliaspass"));
            return;
        }
        File f = new File(fn);
        if (!f.exists()) {
            return;
        }
        String strAlias = this.alias.getText();
        if (StringUtils.isEmpty((String)strAlias)) {
            return;
        }
        String strStorepass = this.stoppass.getText();
        if (StringUtils.isEmpty((String)strStorepass)) {
            return;
        }
        String strAliaspass = this.aliaspass.getText();
        if (StringUtils.isEmpty((String)strAliaspass)) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("alias=" + strAlias + "\r\n");
        buff.append("storepass=" + strStorepass + "\r\n");
        buff.append("aliaspass=" + strAliaspass + "\r\n");
        KeyStore keyStore = new KeyStore();
        keyStore.setKeystore(fn);
        keyStore.setAlias(strAlias);
        keyStore.setStorepass(strStorepass);
        keyStore.setKeypass(strAliaspass);
        this.response.keyStore = keyStore;
        this.response.value = buff.toString();
        this.response.option = DialogResponse.Options.OK;
        this.stage.close();
    }

    @FXML
    public void chooseFile() throws IOException {
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("*.keystore", new String[]{"*.keystore"});
        chooser.getExtensionFilters().add((Object)extFilter);
        if (sof == null) {
            sof = DefaultPath.getPathFile("keystorePath");
        }
        if (sof != null && sof.exists()) {
            chooser.setInitialDirectory(sof);
        } else {
            chooser.setInitialDirectory(Utils.getHOMEDirectory());
        }
        File f = chooser.showOpenDialog(null);
        if (f != null) {
            sof = f.getParentFile();
            DefaultPath.savePathFile("keystorePath", sof.toString());
            this.signFile.setText(f.getPath());
        }
    }

    @FXML
    public void clickClose(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.CLOSED;
        this.stage.close();
    }
}

