/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.android.ddmlib.ViewClient;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.os.Message;
import com.testin.itestin.util.Utils;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.include.TopController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.apache.log4j.Logger;

public class TemplateController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(TemplateController.class);
    @FXML
    AnchorPane templatePage;
    @FXML
    Pane top;
    @FXML
    Pane content;
    @FXML
    Pane bottom;
    @FXML
    TopController topController;
    final BooleanProperty ctrlPressed = new SimpleBooleanProperty(false);
    final BooleanProperty keySavePressed = new SimpleBooleanProperty(false);
    final BooleanBinding ctrlAndSavePressed = this.ctrlPressed.and((ObservableBooleanValue)this.keySavePressed);

    public void initialize(URL location, ResourceBundle resources) {
        this.ctrlAndSavePressed.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (UIController.getRecordActionController() != null) {
                    UIController.getRecordActionController().saveScriptclicked();
                }
            }
        });
        this.templatePage.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode() == KeyCode.CONTROL) {
                    TemplateController.this.ctrlPressed.set(true);
                } else if (ke.getCode() == KeyCode.S) {
                    TemplateController.this.keySavePressed.set(true);
                }
            }
        });
        this.templatePage.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode() == KeyCode.CONTROL) {
                    TemplateController.this.ctrlPressed.set(false);
                } else if (ke.getCode() == KeyCode.S) {
                    TemplateController.this.keySavePressed.set(false);
                }
            }
        });
        this.templatePage.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){
            private long controlLastPressedTime = 0L;
            private boolean isFetchingWindowInfo = false;

            public void handle(KeyEvent event) {
                this.handleControlPressed(event);
            }

            private void handleControlPressed(KeyEvent event) {
                if (!UIController.isEventDetectorRunning()) {
                    return;
                }
                if (event.getCode().equals((Object)KeyCode.CONTROL)) {
                    if (this.controlLastPressedTime == 0L || System.currentTimeMillis() - this.controlLastPressedTime > 1000L) {
                        this.controlLastPressedTime = System.currentTimeMillis();
                    } else {
                        if (System.currentTimeMillis() - this.controlLastPressedTime < 600L) {
                            log.info((Object)"Detect double press of Control key.");
                            this.controlLastPressedTime = 0L;
                            boolean bl = Utils.enableScreenEventDetector = !Utils.enableScreenEventDetector;
                            if (Utils.enableScreenEventDetector) {
                                log.info((Object)"Enable screen event detector.");
                            } else {
                                log.info((Object)"Disable screen event detector.");
                            }
                        }
                        UIController.updateDeviceSideRecordStatusDisplay();
                        this.controlLastPressedTime = 0L;
                    }
                } else {
                    this.controlLastPressedTime = 0L;
                    if (event.getCode().equals((Object)KeyCode.SPACE)) {
                        if (this.isFetchingWindowInfo) {
                            return;
                        }
                        this.isFetchingWindowInfo = true;
                        Message msg = new Message();
                        msg.setStatus(1552);
                        UIController.getEmulatorHandler().sendMessage(msg);
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    try {
                                        ViewClient.getWindowInfoFromDevice();
                                    }
                                    catch (Exception e) {
                                        log.error((Object)e.getMessage(), (Throwable)e);
                                        Message msg = new Message();
                                        msg.setStatus(1553);
                                        UIController.getEmulatorHandler().sendMessage(msg);
                                        isFetchingWindowInfo = false;
                                    }
                                }
                                finally {
                                    Message msg = new Message();
                                    msg.setStatus(1553);
                                    UIController.getEmulatorHandler().sendMessage(msg);
                                    isFetchingWindowInfo = false;
                                }
                            }
                        }.start();
                    }
                }
            }
        });
        String css = TestinStage.getStylesheet();
        this.templatePage.getStylesheets().add((Object)css);
    }

    public void gotoPage(Node node) {
        this.content.getChildren().clear();
        this.content.getChildren().add((Object)node);
        this.content.requestLayout();
    }
}

