/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.apk;

import com.testin.itestin.business.SingleTestCase;
import com.testin.javafx.Main;
import com.testin.javafx.ui.apk.ApkFolderModel;
import com.testin.javafx.ui.control.AlertDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class CopyScriptApkFolderController
extends VBox {
    static Logger log = Logger.getLogger(CopyScriptApkFolderController.class);
    private ApkFolderModel am;
    @FXML
    private ImageView apkIcon;
    @FXML
    private Label apkName;
    @FXML
    private Label apkVersion;
    @FXML
    public VBox vboxholder;
    private Stage stage;

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    @FXML
    public void apkFolderClicked(MouseEvent event) {
        String notice = this.copyScriptTothisVersion();
        this.stage.close();
        AlertDialog.show(AlertDialog.DialogOptions.INFO, notice);
    }

    private String copyScriptTothisVersion() {
        String notice = "";
        String originalName = "";
        String srcFileName = "";
        String destDir = "";
        boolean save = false;
        boolean rename = false;
        String newName = this.getSrcScriptFolderName();
        originalName = newName.substring(0, newName.length() - 4);
        if (this.isSameNameScriptExist(newName)) {
            newName = this.getDestFolderWithSuffixNumber(originalName);
            if (SingleTestCase.getInstance().getRecordStyle() == 0) {
                SingleTestCase.getInstance().setCasePath(String.valueOf(this.getScriptPath()) + newName);
                SingleTestCase.getInstance().setName(newName.substring(0, newName.length() - 4));
                SingleTestCase.getInstance().saveScript();
                notice = String.valueOf(originalName) + Main.getInternationalString("copyscriptmanage.copy.notice.text") + Main.getInternationalString("copyscriptmanage.copy.notice.text.rename") + SingleTestCase.getInstance().getName();
                return notice;
            }
            if (SingleTestCase.getInstance().getRecordStyle() == 1) {
                srcFileName = SingleTestCase.getInstance().getCoordScriptPath();
                destDir = String.valueOf(this.getScriptPath()) + newName;
                save = true;
                rename = true;
            }
        } else {
            save = true;
            if (SingleTestCase.getInstance().getRecordStyle() == 0) {
                srcFileName = String.valueOf(SingleTestCase.getInstance().getCasePath()) + "testCase.xml";
            }
            if (SingleTestCase.getInstance().getRecordStyle() == 1) {
                srcFileName = SingleTestCase.getInstance().getCoordScriptPath();
            }
            destDir = String.valueOf(this.getScriptPath()) + this.getSrcScriptFolderName();
        }
        if (save) {
            try {
                if (new File(destDir).mkdirs()) {
                    FileUtils.copyFileToDirectory((File)new File(srcFileName), (File)new File(destDir));
                }
                if (rename) {
                    String s = this.getNameByPath(destDir);
                    notice = String.valueOf(notice) + originalName + Main.getInternationalString("copyscriptmanage.copy.notice.text") + Main.getInternationalString("copyscriptmanage.copy.notice.text.rename") + s;
                } else {
                    notice = String.valueOf(notice) + originalName + Main.getInternationalString("copyscriptmanage.copy.notice.text");
                }
            }
            catch (IOException e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        return notice;
    }

    private String getNameByPath(String destDir) {
        String[] strn = destDir.split("\\\\");
        String n = strn[strn.length - 1];
        return n.substring(0, n.length() - 4);
    }

    private String getDestFolderWithSuffixNumber(String scriptName) {
        int i = 1;
        String filename = String.valueOf(this.getScriptPath()) + scriptName + "(" + i + ")" + "_dir";
        while (new File(filename).exists()) {
            filename = String.valueOf(this.getScriptPath()) + scriptName + "(" + ++i + ")" + "_dir";
        }
        return filename.substring(this.getScriptPath().length());
    }

    private boolean isSameNameScriptExist(String dirName) {
        File[] files;
        String path = this.getScriptPath();
        File[] fileArray = files = new File(path).listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().equals(dirName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getScriptPath() {
        String dir_fn = String.format("%s_%s_dir", this.am.getPkgname(), this.am.getVersion());
        return "script" + File.separator + dir_fn + File.separator;
    }

    private String getSrcScriptFolderName() {
        String dir = "";
        if (SingleTestCase.getInstance().getRecordStyle() == 0) {
            dir = SingleTestCase.getInstance().getCasePath().split("\\\\")[2];
        }
        if (SingleTestCase.getInstance().getRecordStyle() == 1) {
            String[] strs = SingleTestCase.getInstance().getCoordScriptPath().split("\\\\");
            dir = strs[strs.length - 2];
        }
        return dir;
    }

    @FXML
    public void onMouseMoved() {
        this.apkIcon.setRotate(-30.0);
    }

    @FXML
    public void onMouseExited() {
        this.apkIcon.setRotate(360.0);
    }

    public ApkFolderModel getApkFolderModel() {
        return this.am;
    }

    public void setApkFolderModel(ApkFolderModel am) {
        this.am = am;
    }

    public void updateView() {
        try {
            if (this.am.getIcon() != null) {
                File f = new File(this.am.getIcon());
                FileInputStream in = new FileInputStream(f);
                Image icon = new Image((InputStream)in);
                this.apkIcon.setImage(icon);
            }
            this.apkName.setText(this.am.getApkname());
            this.apkVersion.setText(this.am.getVersion());
            this.apkVersion.setAlignment(Pos.TOP_CENTER);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

