/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.apk;

import com.testin.itestin.business.BizUtils;
import com.testin.itestin.business.KeyStore;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.tools.ApkParser;
import com.testin.itestin.device.tools.ApkTool;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.util.DefaultPath;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.apk.ApkFolderModel;
import com.testin.javafx.ui.apk.CopyScriptApkFolderController;
import com.testin.javafx.ui.control.AlertDialog;
import com.testin.javafx.ui.control.DetailsDialog;
import com.testin.javafx.ui.control.DialogResponse;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import org.apache.log4j.Logger;

public class CopyScriptManagerController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(CopyScriptManagerController.class);
    private Stage stage;
    private DialogResponse response = new DialogResponse();
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    private TilePane tilepaneview;
    @FXML
    AnchorPane copyScriptManagePage;
    @FXML
    Label addNewVersion;
    @FXML
    ImageView parsing;
    Vector<ApkFolderModel> afm = new Vector();
    private File of = null;

    public void initialize(URL location, ResourceBundle resources) {
        this.tilepaneview.setPrefColumns(4);
        String css = TestinStage.getStylesheet();
        this.copyScriptManagePage.getStylesheets().add((Object)css);
        this.addNewVersion.setTooltip(new Tooltip(Main.getInternationalString("copyscriptmanage.label.add.tooltip")));
        this.parsing.setVisible(false);
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public DialogResponse getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    @FXML
    public void addNewVersionApk(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            File f;
            FileChooser chooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("apk files (*.apk)", new String[]{"*.apk"});
            chooser.getExtensionFilters().add((Object)extFilter);
            if (this.of != null) {
                if (this.of.exists()) {
                    chooser.setInitialDirectory(this.of);
                }
            } else {
                try {
                    this.of = DefaultPath.getPathFile("apkPath");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.of != null && this.of.exists()) {
                    chooser.setInitialDirectory(this.of);
                }
            }
            if ((f = chooser.showOpenDialog(null)) != null) {
                this.of = f.getParentFile();
                final String filePath = f.getPath();
                this.parsing.setVisible(true);
                this.addNewVersion.setVisible(false);
                new Thread(){

                    @Override
                    public void run() {
                        boolean parseresult = CopyScriptManagerController.this.startParseApk(filePath);
                        if (parseresult) {
                            CopyScriptManagerController.this.loadAppWithSamePkgName();
                        }
                        CopyScriptManagerController.this.addNewVersion.setVisible(true);
                        CopyScriptManagerController.this.parsing.setVisible(false);
                    }
                }.start();
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            UIController.updateNodeSytleClass((Node)this.addNewVersion, "addnewVersionEnter");
        } else if (eventType.equals("MOUSE_EXITED")) {
            UIController.updateNodeSytleClass((Node)this.addNewVersion, "addnewVersion");
        } else if (eventType.equals("MOUSE_PRESSED")) {
            UIController.updateNodeSytleClass((Node)this.addNewVersion, "addnewVersionPress");
        }
    }

    private boolean startParseApk(String path) {
        ApplicationInfo appInfo = new ApkParser().parse(path);
        if (BizUtils.isMalfunctionApk(appInfo)) {
            return false;
        }
        if (!appInfo.getPackageName().equals(SingleTestCase.getInstance().getPkgname())) {
            AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("copyscriptmanage.add.newVersion.pkgDiff"));
            return false;
        }
        if (appInfo.getVersionName().equals(SingleTestCase.getInstance().getVersion()) || this.isSameVersionExists(appInfo.getVersionName())) {
            AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("copyscriptmanage.add.newVersion.sameVer"));
            return false;
        }
        String dir_fn = String.format("%s_%s_dir", appInfo.getPackageName(), appInfo.getVersionName());
        String rootPath = String.valueOf(DirectoryService.getScriptDir()) + File.separator + dir_fn + File.separator;
        BizUtils.handleWorkFolder(rootPath, appInfo.getMd5());
        BizUtils.copyIcon(rootPath, appInfo);
        BizUtils.saveAppInfo(rootPath, appInfo);
        Message msg = BizUtils.copyApp(rootPath, appInfo);
        KeyStore localKeyStore = TestFileUtils.getKeystore(rootPath);
        KeyStore tmp = localKeyStore == null ? ApkTool.TestinKeyStore : localKeyStore;
        try {
            msg = BizUtils.resignMainApk(rootPath, appInfo, tmp);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (msg.getStatus() != 0) {
            DetailsDialog.show(Main.getInternationalString("recordsetcontroller.threadHandler.preparefailure"), msg.getContent());
            return false;
        }
        return true;
    }

    private boolean isSameVersionExists(String versionName) {
        for (ApkFolderModel a : this.afm) {
            if (!versionName.equals(a.getVersion())) continue;
            return true;
        }
        return false;
    }

    public void loadAppWithSamePkgName() {
        if (Platform.isFxApplicationThread()) {
            this.loadApps();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    CopyScriptManagerController.this.loadApps();
                }
            });
        }
    }

    private void loadApps() {
        this.afm.clear();
        this.afm = this.findOtherVersionApks();
        this.tilepaneview.getChildren().clear();
        for (ApkFolderModel a : this.afm) {
            VBox box = this.loadFxmlForApkFolder(a);
            this.tilepaneview.getChildren().add((Object)box);
        }
    }

    private VBox loadFxmlForApkFolder(ApkFolderModel am) {
        VBox page = new VBox();
        CopyScriptApkFolderController controller = new CopyScriptApkFolderController();
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/com/testin/javafx/ui/apk/ApkFolder.fxml"));
        fxmlLoader.setRoot((Object)controller.vboxholder);
        fxmlLoader.setController((Object)controller);
        try {
            page = (VBox)fxmlLoader.load();
            page.setSpacing(5.0);
            controller.setStage(this.stage);
            controller.setApkFolderModel(am);
            controller.updateView();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return page;
    }

    private Vector<ApkFolderModel> findOtherVersionApks() {
        Vector<ApkFolderModel> v = new Vector<ApkFolderModel>();
        String scriptPath = DirectoryService.getScriptDir();
        File[] files = new File(scriptPath).listFiles();
        if (files.length > 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (this.isSamePkgNameFolder(f)) {
                    ApplicationInfo info;
                    ApkFolderModel am = new ApkFolderModel();
                    File icon = new File(String.valueOf(f.getPath()) + File.separator + "icon.png");
                    if (icon.exists()) {
                        am.setIcon(icon.getAbsolutePath());
                    }
                    if ((info = TestFileUtils.getAppInfo(f.getPath())) != null) {
                        am.setPkgname(info.getPackageName());
                        am.setVersion(info.getVersionName() == null ? "" : info.getVersionName());
                        am.setStringProperty((StringProperty)new SimpleStringProperty(info.getAppName()));
                        am.setApkname(info.getAppName());
                        v.add(am);
                    }
                }
                ++n2;
            }
        }
        return v;
    }

    private boolean isSamePkgNameFolder(File f) {
        String str = f.getName();
        return f.isDirectory() && str.startsWith(SingleTestCase.getInstance().getPkgname()) && !str.contains(SingleTestCase.getInstance().getVersion()) && str.endsWith("_dir");
    }

    @FXML
    public void csOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void csOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void closeCopyScriptManager() {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.CLOSED;
        this.stage.close();
    }
}

