/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.ChooseDialogController;
import com.testin.javafx.ui.control.DialogResponse;
import com.testin.javafx.ui.control.InputDialog;
import com.testin.javafx.ui.control.Receiver;
import java.io.IOException;
import java.io.InputStream;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.BuilderFactory;
import org.apache.log4j.Logger;

public class ChooseDialog {
    static Logger log = Logger.getLogger(ChooseDialog.class);

    private ChooseDialog() {
    }

    public static DialogResponse show(final String message, final String newBtn, final String continueBtn) {
        final Receiver receiver = new Receiver();
        if (Platform.isFxApplicationThread()) {
            ChooseDialog.showDialog(message, newBtn, continueBtn, receiver);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ChooseDialog.showDialog(message, newBtn, continueBtn, receiver);
                }
            });
            while (!receiver.exit) {
                Utils.sleep(1L);
            }
        }
        return receiver.response;
    }

    private static void showDialog(String message, String newBtn, String continueBtn, Receiver receiver) {
        AnchorPane page;
        String fxml = "/com/testin/javafx/ui/control/ChooseDialog.fxml";
        FXMLLoader loader = new FXMLLoader();
        InputStream in = InputDialog.class.getResourceAsStream(fxml);
        loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        loader.setLocation(InputDialog.class.getResource(fxml));
        try {
            try {
                loader.setResources(Main.getResourceBundle());
                page = (AnchorPane)loader.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Stage stage = new Stage();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initOwner((Window)TestinStage.getPrimaryStage());
        stage.initStyle(StageStyle.UNDECORATED);
        stage.setResizable(false);
        Scene scene = new Scene((Parent)page);
        stage.setScene(scene);
        ChooseDialogController controller = (ChooseDialogController)((Object)loader.getController());
        controller.setStage(stage);
        controller.setMessage(message);
        controller.setNewBtn(newBtn);
        controller.setContinueBtn(continueBtn);
        stage.showAndWait();
        receiver.response = controller.getValue();
        receiver.exit = true;
    }
}

