/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.utils.UIController;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.DialogResponse;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class ChooseDialogController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Label message;
    @FXML
    Label newBtnDialog;
    @FXML
    Label continueBtnDialog;
    @FXML
    AnchorPane ConfirmDialog;
    @FXML
    HBox newHbox;
    @FXML
    HBox continueHbox;
    @FXML
    ImageView closeBtn;
    private Stage stage;
    private DialogResponse response = new DialogResponse();

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setMessage(String message) {
        if (this.stage == null) {
            return;
        }
        this.message.setText(message);
    }

    public void setNewBtn(String newbtn) {
        if (this.stage == null) {
            return;
        }
        this.newBtnDialog.setText(newbtn);
    }

    public void setContinueBtn(String strContinue) {
        if (this.stage == null) {
            return;
        }
        this.continueBtnDialog.setText(strContinue);
    }

    public DialogResponse getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = TestinStage.getStylesheet();
        this.ConfirmDialog.getStylesheets().add((Object)css);
    }

    @FXML
    public void clickNew(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.OK;
        this.stage.close();
    }

    @FXML
    public void closeBtnEnter(MouseEvent event) {
        String url = ((Object)((Object)this)).getClass().getResource("/com/testin/javafx/resources/dialog_close_enter_blue.png").toExternalForm();
        this.closeBtn.setImage(new Image(url));
    }

    @FXML
    public void closeBtnExit(MouseEvent event) {
        String url = ((Object)((Object)this)).getClass().getResource("/com/testin/javafx/resources/dialog_close_blue.png").toExternalForm();
        this.closeBtn.setImage(new Image(url));
    }

    @FXML
    public void clickContinue(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.CANCEL;
        this.stage.close();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void clickClose(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.CLOSED;
        this.stage.close();
    }

    @FXML
    public void highlightNewHbox() {
        UIController.updateNodeSytleClass((Node)this.newHbox, "hboxHighlight");
    }

    @FXML
    public void exitNewHbox() {
        UIController.updateNodeSytleClass((Node)this.newHbox, "emptyHbox");
    }

    @FXML
    public void highlightContinueHbox() {
        UIController.updateNodeSytleClass((Node)this.continueHbox, "hboxHighlight");
    }

    @FXML
    public void exitContinueHbox() {
        UIController.updateNodeSytleClass((Node)this.continueHbox, "emptyHbox");
    }
}

