/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.utils.UIController;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.DialogResponse;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.DirectoryChooserBuilder;
import javafx.stage.Stage;
import javafx.stage.Window;

public class FolderSelectDialogController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    private static String directory = "";
    @FXML
    Label chooseFile;
    @FXML
    AnchorPane AccountSelectDialog;
    @FXML
    TextField value;
    @FXML
    Button ok;
    private Stage stage;
    private DialogResponse response = new DialogResponse();

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public DialogResponse getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = TestinStage.getStylesheet();
        this.AccountSelectDialog.getStylesheets().add((Object)css);
    }

    @FXML
    public void clickOk(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.OK;
        this.response.value = this.value.getText();
        this.stage.close();
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.CANCEL;
        this.response.value = null;
        this.stage.close();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.response.option = DialogResponse.Options.OK;
            this.response.value = this.value.getText();
            this.stage.close();
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.response.option = DialogResponse.Options.CANCEL;
            this.response.value = null;
            this.stage.close();
        }
    }

    @FXML
    public void selectClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            UIController.updateNodeSytleClass((Node)this.chooseFile, "labelBtnPress");
            DirectoryChooserBuilder builder = DirectoryChooserBuilder.create();
            String cwd = directory.isEmpty() ? System.getProperty("user.dir") : directory;
            File file = new File(cwd);
            builder.initialDirectory(file);
            DirectoryChooser chooser = builder.build();
            File chosenDir = chooser.showDialog((Window)this.stage);
            if (chosenDir != null) {
                this.value.setText(chosenDir.getAbsolutePath());
                directory = chosenDir.getAbsolutePath();
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            UIController.updateNodeSytleClass((Node)this.chooseFile, "labelBtnEnter");
        } else if (eventType.equals("MOUSE_EXITED")) {
            UIController.updateNodeSytleClass((Node)this.chooseFile, "labelBtnNormal");
        } else if (eventType.equals("MOUSE_PRESSED")) {
            UIController.updateNodeSytleClass((Node)this.chooseFile, "labelBtnPress");
        }
    }
}

