/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.DialogResponse;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.apache.log4j.Logger;

public class InputDialogWithOptionsController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(InputDialogWithOptionsController.class);
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Label message;
    @FXML
    AnchorPane InputDialog;
    @FXML
    TextField value;
    @FXML
    Button ok;
    @FXML
    Button cancelBtn;
    @FXML
    RadioButton usernameOpt;
    @FXML
    RadioButton passwordOpt;
    @FXML
    RadioButton normaltextOpt;
    @FXML
    RadioButton randomtextOpt;
    @FXML
    Label errorprompt;
    private Stage stage;
    private DialogResponse response = new DialogResponse();
    private ToggleGroup group = new ToggleGroup();

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setMessage(String message) {
        if (this.stage == null) {
            return;
        }
        this.message.setText(message);
    }

    public DialogResponse getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void setValue(String value) {
        if (this.stage == null) {
            return;
        }
        this.response.value = value;
        this.value.setText(value);
        try {
            Constructor con = MouseEvent.class.getDeclaredConstructor(EventType.class);
            con.setAccessible(true);
            Object obj = con.newInstance(MouseEvent.MOUSE_CLICKED);
            MouseEvent mouseEvent = (MouseEvent)obj;
            this.value.fireEvent((Event)mouseEvent);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void okEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_enter");
    }

    @FXML
    public void okExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_normal");
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelBtn, "buttonstyle_enter");
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelBtn, "buttonstyle_normal");
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = TestinStage.getStylesheet();
        this.InputDialog.getStylesheets().add((Object)css);
        this.usernameOpt.setToggleGroup(this.group);
        this.usernameOpt.setUserData((Object)"username");
        this.passwordOpt.setToggleGroup(this.group);
        this.passwordOpt.setUserData((Object)"password");
        this.normaltextOpt.setToggleGroup(this.group);
        this.normaltextOpt.setUserData((Object)"text");
        this.randomtextOpt.setToggleGroup(this.group);
        this.randomtextOpt.setUserData((Object)"randomtext");
        this.usernameOpt.setSelected(true);
        this.value.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                block9: {
                    if (InputDialogWithOptionsController.this.group.getSelectedToggle().getUserData().toString().equals("randomtext")) {
                        if (!Utils.isNumber(newValue)) {
                            InputDialogWithOptionsController.this.errorprompt.setText(Main.getInternationalString("inputdialog.randomtext.prompt"));
                        } else {
                            try {
                                int len = Integer.parseInt(newValue);
                                if (len > 0 && len <= 20) {
                                    InputDialogWithOptionsController.this.errorprompt.setText("");
                                    break block9;
                                }
                                InputDialogWithOptionsController.this.errorprompt.setText(Main.getInternationalString("inputdialog.randomtext.prompt"));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (newValue.length() > 100) {
                        InputDialogWithOptionsController.this.errorprompt.setText(Main.getInternationalString("inputdialog.text.toolong.prompt"));
                    } else {
                        InputDialogWithOptionsController.this.errorprompt.setText("");
                    }
                }
            }
        });
    }

    @FXML
    public void clickOk(MouseEvent event) {
        this.submitInput();
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.cancelInput();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyText(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.submitInput();
        }
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.submitInput();
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.cancelInput();
        }
    }

    private void submitInput() {
        if (this.stage == null || !this.errorprompt.getText().equals("")) {
            return;
        }
        this.response.option = DialogResponse.Options.OK;
        this.response.value = this.value.getText();
        this.response.value2 = this.group.getSelectedToggle().getUserData().toString();
        this.stage.close();
    }

    private void cancelInput() {
        this.response.option = DialogResponse.Options.CANCEL;
        this.response.value = null;
        this.stage.close();
    }
}

