/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.InputDialog;
import com.testin.javafx.ui.control.ProgressDialogController;
import java.io.IOException;
import java.io.InputStream;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.BuilderFactory;
import org.apache.log4j.Logger;

public class ProgressDialog {
    static Logger log = Logger.getLogger(ProgressDialog.class);
    private ProgressDialogController controller;

    public ProgressDialog(final DialogOptions optionType) {
        if (Platform.isFxApplicationThread()) {
            this.init(optionType);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.init(optionType);
                }
            });
        }
    }

    private void init(DialogOptions optionType) {
        AnchorPane page;
        String fxml = "/com/testin/javafx/ui/control/ProgressDialog.fxml";
        FXMLLoader loader = new FXMLLoader();
        InputStream in = InputDialog.class.getResourceAsStream(fxml);
        loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        loader.setLocation(InputDialog.class.getResource(fxml));
        try {
            try {
                loader.setResources(Main.getResourceBundle());
                page = (AnchorPane)loader.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Stage stage = new Stage();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initOwner((Window)TestinStage.getPrimaryStage());
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setResizable(false);
        Scene scene = new Scene((Parent)page);
        scene.setFill((Paint)Color.TRANSPARENT);
        stage.setScene(scene);
        this.controller = (ProgressDialogController)((Object)loader.getController());
        this.controller.setOptionType(optionType);
        this.controller.setStage(stage);
    }

    public boolean isCanceled() {
        if (this.controller != null) {
            return this.controller.isCanceled();
        }
        return true;
    }

    public void setCancelListener(CancelListener cancelListener) {
        while (this.controller == null) {
            Utils.sleep(10L);
        }
        this.controller.setCancelListener(cancelListener);
    }

    public void show() {
        if (Platform.isFxApplicationThread()) {
            if (this.controller != null) {
                this.controller.show();
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ProgressDialog.this.controller != null) {
                        ProgressDialog.this.controller.show();
                    }
                }
            });
        }
    }

    public void setMessage(final String msg) {
        if (Platform.isFxApplicationThread()) {
            if (this.controller != null) {
                this.controller.setMessage(msg);
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ProgressDialog.this.controller != null) {
                        ProgressDialog.this.controller.setMessage(msg);
                    }
                }
            });
        }
    }

    public void setProgressValue(final int value) {
        if (Platform.isFxApplicationThread()) {
            if (this.controller != null) {
                this.controller.setProgressValue(value);
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ProgressDialog.this.controller != null) {
                        ProgressDialog.this.controller.setProgressValue(value);
                    }
                }
            });
        }
    }

    public void close() {
        if (Platform.isFxApplicationThread()) {
            if (this.controller != null) {
                this.controller.close();
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ProgressDialog.this.controller != null) {
                        ProgressDialog.this.controller.close();
                    }
                }
            });
        }
    }

    public static interface CancelListener {
        public void canceled();
    }

    public static enum DialogOptions {
        CANCEL,
        NONE;

    }
}

