/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.AlertDialog;
import com.testin.javafx.ui.control.DialogResponse;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.apache.log4j.Logger;

public class ScriptAlterDialogController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(ScriptAlterDialogController.class);
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Label message;
    @FXML
    AnchorPane InputDialog;
    @FXML
    TextArea value;
    @FXML
    Button ok;
    private Stage stage;
    private DialogResponse response = new DialogResponse();

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setMessage(String message) {
        if (this.stage == null) {
            return;
        }
        this.message.setText(message);
    }

    public DialogResponse getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void setValue(String value) {
        if (this.stage == null) {
            return;
        }
        this.response.value = value;
        this.value.setText(value);
        try {
            Constructor con = MouseEvent.class.getDeclaredConstructor(EventType.class);
            con.setAccessible(true);
            Object obj = con.newInstance(MouseEvent.MOUSE_CLICKED);
            MouseEvent mouseEvent = (MouseEvent)obj;
            this.value.fireEvent((Event)mouseEvent);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = TestinStage.getStylesheet();
        this.InputDialog.getStylesheets().add((Object)css);
    }

    @FXML
    public void clickOk(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.OK;
        this.response.value = this.value.getText();
        this.response.value = this.response.value.replaceAll("\n", "");
        if (this.response.value.equals("")) {
            AlertDialog.show(AlertDialog.DialogOptions.WARN, String.valueOf(Main.getInternationalString("scriptshowcontroller.handlemenuitem.altererror")) + "," + Main.getInternationalString("scriptshowcontroller.handlemenuitem.alterconnull"));
        } else {
            this.stage.close();
        }
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.CANCEL;
        this.response.value = null;
        this.stage.close();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyText(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.response.option = DialogResponse.Options.OK;
            this.response.value = this.value.getText();
            this.response.value = this.response.value.replace("\n", "");
            if (this.response.value.equals("")) {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, String.valueOf(Main.getInternationalString("scriptshowcontroller.handlemenuitem.altererror")) + "," + Main.getInternationalString("scriptshowcontroller.handlemenuitem.alterconnull"));
            } else {
                this.stage.close();
            }
        }
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.response.option = DialogResponse.Options.OK;
            this.response.value = this.value.getText();
            this.stage.close();
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.response.option = DialogResponse.Options.CANCEL;
            this.response.value = null;
            this.stage.close();
        }
    }
}

