/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.utils.UIController;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.DialogResponse;
import com.testin.javafx.ui.control.GeneralContentDisplayDialog;
import com.testin.javafx.update.UpdateChecker;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class UpgradeConfirmDialogController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(UpgradeConfirmDialogController.class);
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Label message;
    @FXML
    AnchorPane UpgradeConfirmDialog;
    @FXML
    Button cancelbtn;
    @FXML
    Button confirmbtn;
    private Stage stage;
    private DialogResponse response = new DialogResponse();

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setMessage(String message) {
        if (this.stage == null) {
            return;
        }
        this.message.setText(message);
    }

    public DialogResponse getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = TestinStage.getStylesheet();
        this.UpgradeConfirmDialog.getStylesheets().add((Object)css);
    }

    @FXML
    public void clickOk(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.OK;
        this.stage.close();
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.option = DialogResponse.Options.CANCEL;
        this.stage.close();
    }

    @FXML
    public void confirmEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.confirmbtn, "buttonstyle_enter");
    }

    @FXML
    public void confirmExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.confirmbtn, "buttonstyle_normal");
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelbtn, "buttonstyle_enter");
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelbtn, "buttonstyle_normal");
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void checkUpdateInfo(MouseEvent event) {
        UpdateChecker updateChecker = new UpdateChecker();
        try {
            updateChecker.parseRemoteXml();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        GeneralContentDisplayDialog.show(updateChecker.getRemotePublishInfo(), Main.getInternationalString("verdialog.label.checkmsg"));
    }
}

